/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.Stage;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.wbfw.common.WbfSiteContext;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.fx.XdtsStagePane;
import jp.co.extreme.module.xdts.stub.XdtsHttpServerStub;
import jp.co.extreme.scf4.fx.HfxTaskMonitor;

public class XdtsHttpServerPane
extends XdtsStagePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField hostNameField = new FxTextField();
    FxNumberField portField = new FxNumberField();
    FxTextField siteNameField = new FxTextField();
    FxCheckBox checkBox = new FxCheckBox();
    FxButton startButton = FxUtil.createStartButton();
    FxButton stopButton = FxUtil.createStopButton();
    FxButton closeButton = FxUtil.createCloseButton();
    WbfSiteContext siteContext;

    public XdtsHttpServerPane() throws Exception {
        this.initComponant();
        this.setCenter((Node)this.centerPane);
        this.underLineEnabled();
        FxUtil.defaultInitialize((Node)this);
        this.siteContext = XdtsHttpServerStub.getInstance().getSiteContext();
        String hostName = this.siteContext.propertyMap.get(XdtsConstants.Property.hostName.name());
        this.hostNameField.setText(hostName);
        String serverPort = this.siteContext.propertyMap.get(XdtsConstants.Property.port.name());
        this.portField.setValue(BcNumberUtil.parseInteger(serverPort));
        this.siteNameField.setText(this.siteContext.siteName);
        this.stopButton.setDisable(true);
    }

    protected void initComponant() throws Exception {
        this.hostNameField.setPrefColumnCount(60);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().hostName), new Node[]{this.hostNameField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.portField.setPrefColumnCount(6);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().port), new Node[]{this.portField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.siteNameField.setPrefColumnCount(60);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().siteName), new Node[]{this.siteNameField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.startButton.setOnAction(this.actionEventHandler);
        this.stopButton.setOnAction(this.actionEventHandler);
        nodeUnit = new FxNodeUnit((Node)this.startButton, new Node[]{this.stopButton});
        this.centerPane.addNodeUnit(nodeUnit);
        this.closeButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.closeButton);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.startButton) {
            HfxTaskMonitor.getInstance().show();
            this.startButton.setDisable(true);
            this.siteContext.siteName = this.siteNameField.getText();
            try {
                XdtsHttpServerStub.getInstance().start(this.siteContext);
                this.stopButton.setDisable(false);
            }
            catch (Exception ex) {
                this.startButton.setDisable(false);
            }
        } else if (ev.getSource() == this.stopButton) {
            this.stopButton.setDisable(true);
            try {
                BcResult result = XdtsHttpServerStub.getInstance().stop();
                this.startButton.setDisable(false);
            }
            catch (Exception ex) {
                this.stopButton.setDisable(false);
            }
        } else if (ev.getSource() == this.closeButton) {
            this.close();
        }
    }

    @Override
    public void close() throws Exception {
        this.getStage().hide();
    }

    @Override
    protected Stage createStage() throws Exception {
        Stage stage = super.createStage();
        stage.setWidth(1040.0);
        stage.setHeight(240.0);
        stage.setResizable(false);
        stage.getIcons().add((Object)FxImageHelper.getImage("web_64x64.png"));
        return stage;
    }
}

