/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.event.BcEvent;
import jp.co.extreme.base.event.BcEventManager;
import jp.co.extreme.base.util.BcInstanceManager;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcObjectNotFoundException;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextArea;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.module.xdts.stub.XdtsCustomSqlStub;
import jp.co.extreme.module.xsys.validation.XsysValidator;
import jp.co.extreme.sql.SqlWords;

public class XdtsCustomSqlPane
extends FxDecoratePane {
    FxFlowPane topPane = new FxFlowPane(11);
    FxTextField nameTextField = new FxTextField();
    FxTextField groupTextField = new FxTextField();
    FxTextField noteTextField = new FxTextField();
    FxTextArea sqlTextArea = new FxTextArea();
    XdtsCustomSql customSql1;
    public XdtsCustomSql customSql2;
    Button saveButton;
    Button cancelButton;
    Stage stage;

    public XdtsCustomSqlPane() throws Exception {
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.saveButton = FxUtil.createSaveButton(BcWords.getInstance().save, null);
        this.saveButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.saveButton);
        this.cancelButton = FxUtil.createCancelButton();
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.cancelButton);
        this.nameTextField.setPrefColumnCount(160);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().name), new Node[]{this.nameTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.groupTextField.setPrefColumnCount(160);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().group), new Node[]{this.groupTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.noteTextField.setPrefColumnCount(160);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().note), new Node[]{this.noteTextField});
        this.topPane.addNodeUnit(nodeUnit);
        this.topPane.setPrefHeight(84.0);
        this.setTop((Node)this.topPane);
        this.setCenter((Node)this.sqlTextArea);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setCustomQuery(XdtsCustomSql customSql1) throws Exception {
        this.customSql1 = customSql1;
        this.nameTextField.setText(customSql1.name);
        this.groupTextField.setText(customSql1.group);
        this.noteTextField.setText(customSql1.note);
        this.sqlTextArea.setText(customSql1.sql);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.saveButton) {
            if (this.customSql1 == null) {
                this.customSql1 = new XdtsCustomSql();
            }
            this.customSql1.name = this.nameTextField.getText();
            this.customSql1.group = this.groupTextField.getText();
            this.customSql1.note = this.noteTextField.getText();
            this.customSql1.sql = this.sqlTextArea.getText();
            XsysValidator validator = XsysValidator.getInstance();
            BcResult result1 = validator.validateForGui(this.customSql1);
            if (result1.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result1.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().warning, 2);
                return;
            }
            this.customSql2 = XdtsCustomSqlStub.getInstance().putCustomSql(this.customSql1);
            BcEventManager.getInstance().getEventHandlerList(XdtsCustomSql.class).fireEvent(new BcEvent(this.customSql2));
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() throws Exception {
        this.stage.close();
        BcInstanceManager.getInstance().remove(((Object)((Object)this)).getClass(), this.customSql1.getDataId());
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    XdtsCustomSqlPane.this.nameTextField.requestFocus();
                }
                catch (Exception ex) {
                    XdtsCustomSqlPane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsCustomSqlPane.this.close();
                }
                catch (Exception ex) {
                    XdtsCustomSqlPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setResizable(true);
        String title = String.valueOf(SqlWords.getInstance().sql) + " : ";
        title = this.customSql1.getDataId() <= 0 ? String.valueOf(title) + BcWords.getInstance().new_ : String.valueOf(title) + BcStringUtil.toNotNull(this.customSql1.name);
        this.stage.setTitle(title);
        Image image = FxImageHelper.getImage("sql_48x48.png");
        this.stage.getIcons().add((Object)image);
        FxUtil.setWindowCenter((Window)this.stage, 0.8);
        this.stage.show();
    }

    public static void show2(int profileId, int customSqlId) throws Exception {
        XdtsCustomSqlPane customSqlPane = null;
        if (customSqlId > 0) {
            customSqlPane = (XdtsCustomSqlPane)((Object)BcInstanceManager.getInstance().get(XdtsCustomSqlPane.class, customSqlId));
        }
        if (customSqlPane != null) {
            customSqlPane.stage.toFront();
            return;
        }
        customSqlPane = new XdtsCustomSqlPane();
        XdtsCustomSql customSql = null;
        if (customSqlId <= 0) {
            customSql = new XdtsCustomSql();
            customSql.profileId = profileId;
        } else {
            customSql = XdtsCustomSqlStub.getInstance().getCustomSql(customSqlId);
            if (customSql == null) {
                throw new BcObjectNotFoundException();
            }
            BcInstanceManager.getInstance().put(customSql.getDataId(), (Object)customSqlPane);
        }
        customSqlPane.setCustomQuery(customSql);
        customSqlPane.show(null);
    }

    public static void show3(long profileId, String sql) throws Exception {
        XdtsCustomSqlPane customSqlPane = new XdtsCustomSqlPane();
        XdtsCustomSql customSql = new XdtsCustomSql();
        customSql.profileId = (int)profileId;
        customSql.sql = sql;
        customSqlPane.setCustomQuery(customSql);
        customSqlPane.show(null);
    }
}

