/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.xweb.common.HtmlTableModel;

public class WbsHtmlTableCreator
extends BcLoggableObject {
    private HtmlTableModel tableModel;
    private HtmlBuilder htmlBuilder;
    private boolean hasRowNumber;
    private boolean isSticky;
    public String elementId;

    public HtmlTableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(HtmlTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.htmlBuilder;
    }

    public void setHtmlBuilder(HtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    public boolean hasRowNumber() {
        return this.hasRowNumber;
    }

    public void setHasRowNumber(boolean hasRowNumber) {
        this.hasRowNumber = hasRowNumber;
    }

    public boolean isSticky() {
        return this.isSticky;
    }

    public void setSticky(boolean isSticky) {
        this.isSticky = isSticky;
    }

    public WbsHtmlTableCreator() {
        this.setHtmlBuilder(HtmlBuilder.getInstance());
    }

    public String create(WbfwWcbArgument wcbArg) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tableStart());
        BcStringUtil.append(sb, this.createHeader());
        BcStringUtil.append(sb, this.createBody());
        BcStringUtil.append(sb, this.createFooter());
        sb.append(this.tableEnd());
        return sb.toString();
    }

    protected String tableStart() throws Exception {
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = "table_div";
        sb.append(this.getHtmlBuilder().div_start(globalAttribute, true));
        globalAttribute = new HtmlGlobalAttribute();
        this.isSticky();
        globalAttribute.clazz = "sticky_table";
        globalAttribute.id = this.elementId;
        sb.append(this.getHtmlBuilder().table_start(globalAttribute, null, null, 1, 0, 0, null));
        return sb.toString();
    }

    protected String tableEnd() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().table_end());
        sb.append(this.getHtmlBuilder().div_end());
        return sb.toString();
    }

    protected String createHeader() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().thead_start());
        sb.append(this.getHtmlBuilder().tr_start());
        if (this.hasRowNumber()) {
            sb.append("<th class=\"blank\"></th>");
        }
        int i = 0;
        while (i < this.getTableModel().getColumnCount()) {
            sb.append(this.headerCell(i));
            ++i;
        }
        sb.append(this.getHtmlBuilder().tr_end());
        sb.append(this.getHtmlBuilder().thead_end());
        return sb.toString();
    }

    protected String headerCell(int columnId) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.headerCellStart(columnId));
        String value = this.getHeaderValue(columnId);
        if (!BcStringUtil.isEmpty(value)) {
            sb.append(value);
        }
        sb.append(this.getHtmlBuilder().th_end());
        return sb.toString();
    }

    protected StringBuilder headerCellStart(int columnId) throws Exception {
        String style = null;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().th(-1, -1, -1, -1, null, style));
        return sb;
    }

    protected String getHeaderValue(int columnId) throws Exception {
        return this.getTableModel().getHeaderValue(columnId);
    }

    protected String createBody() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.bodyStart());
        String rows = this.createRows();
        BcStringUtil.append(sb, rows);
        sb.append(this.getHtmlBuilder().tbody_end());
        return sb.toString();
    }

    protected String bodyStart() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHtmlBuilder().tbody_start());
        return sb.toString();
    }

    protected String createRows() throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.getTableModel().getRowCount()) {
            sb.append(this.createRow(i));
            ++i;
        }
        return sb.toString();
    }

    protected String createRow(int rowId) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rowStart());
        if (this.hasRowNumber()) {
            sb.append("<th>" + (rowId + 1) + "</th>");
        }
        int i = 0;
        while (i < this.getTableModel().getColumnCount()) {
            sb.append(this.createCell(rowId, i));
            ++i;
        }
        sb.append(this.getHtmlBuilder().tr_end());
        return sb.toString();
    }

    protected String rowStart() throws Exception {
        StringBuilder sb = new StringBuilder();
        String cssClass = null;
        sb.append(this.getHtmlBuilder().tr_start(cssClass));
        return sb.toString();
    }

    protected String createCell(int rowId, int columnId) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.cellStart(rowId, columnId));
        String value = this.getCellValue(rowId, columnId);
        if (!BcStringUtil.isEmpty(value)) {
            sb.append(value);
        } else {
            sb.append(HtmlConstants.HtmlSpecialCharacter.space.value);
        }
        sb.append(this.getHtmlBuilder().td_end());
        return sb.toString();
    }

    protected String cellStart(int rowId, int columnId) throws Exception {
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = null;
        sb.append(this.getHtmlBuilder().tableCell(globalAttribute, 1, 1));
        return sb.toString();
    }

    protected String getCellValue(int rowId, int columnId) throws Exception {
        return this.tableModel.getCellValue(rowId, columnId);
    }

    protected String createFooter() throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.getTableModel().getColumnCount()) {
            String footerValue = this.getTableModel().getFooterValue(i);
            if (!BcStringUtil.isEmpty(footerValue)) {
                HtmlGlobalAttribute globalAttribute = null;
                sb.append(this.getHtmlBuilder().tableCell(globalAttribute, 1, 1));
                sb.append(footerValue);
                sb.append(this.getHtmlBuilder().td_end());
            }
            ++i;
        }
        if (!BcStringUtil.isEmpty(sb)) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append(this.getHtmlBuilder().tfoot(null));
            sb2.append(this.getHtmlBuilder().tr_start(null));
            sb2.append((CharSequence)sb);
            sb2.append(this.getHtmlBuilder().tr_end());
            sb2.append(this.getHtmlBuilder().tfoot_end());
            return sb2.toString();
        }
        return null;
    }
}

