/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.wcb;

import java.util.List;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.module.wbfw.common.WbfSiteContext;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.dao.Wbs1ArticleDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Article;

class Wbs1LinkUtil
extends BcLoggableObject {
    private HtmlBuilder htmlBuilder;

    private Wbs1LinkUtil() {
        this.setHtmlBuilder(HtmlBuilder.getInstance());
    }

    public static Wbs1LinkUtil getInstance() {
        return SingletonHolder.instance;
    }

    public HtmlBuilder getHtmlBuilder() {
        return this.htmlBuilder;
    }

    public void setHtmlBuilder(HtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    public StringBuilder createLink(WbfwWcbArgument wcbArg, DtsSession dtsSession) throws Exception {
        WbfSiteContext siteContext = wcbArg.getSiteContext();
        Wbs1ArticleDAO dao = Wbs1ArticleDAO.getInstance(Wbs1Constants.ArticleCategory.link.tableName);
        List articleList = dao.getList(dtsSession, Wbs1ArticleDAO.Mode.id, -1L, null, null);
        BcLogUtil.debug("articleList.size()=" + articleList.size());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < articleList.size()) {
            Wbs1Article article = (Wbs1Article)articleList.get(i);
            sb.append((CharSequence)this.linkCell(article));
            sb.append("\n\n");
            ++i;
        }
        return sb;
    }

    protected StringBuilder linkCell(Wbs1Article article) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(article.texts[Wbs1Constants.ArticleItem.\u672c\u6587.ordinal()]);
        return sb;
    }

    /* synthetic */ Wbs1LinkUtil(Wbs1LinkUtil wbs1LinkUtil) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1LinkUtil instance = new Wbs1LinkUtil(null);

        private SingletonHolder() {
        }
    }
}

