/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbs1.dao;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.module.wbs1.dao.Wbs1AnswerDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Recruitment;
import jp.co.extreme.module.wbs1.model.WbsJudgementCondition;
import jp.co.extreme.module.wbs1.model.WbsTempCondition;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.sql.SqlConditionParser;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class Wbs1RecruitmentDAO
extends OrmAbstractDAO<Wbs1Recruitment> {
    public static final int MODE_default = 1;
    public static final int MODE_personId = 2;

    private Wbs1RecruitmentDAO() {
        super(new Wbs1Recruitment[0]);
        this.setTableName("wbs1_recruitment");
    }

    public static Wbs1RecruitmentDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, long dataId, long personId, WbsTempCondition tempCondition, WbsJudgementCondition judgementCondition) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (dataId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id =" + dataId);
            selectQuery.addWhereElement(whereElement);
        }
        if (personId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id =" + personId);
            selectQuery.addWhereElement(whereElement);
        }
        boolean isJoin = false;
        if (tempCondition != null) {
            SqlConditionParser.getInstance().parseCondition(selectQuery, sqlContext, String.valueOf(aliasWk) + "occupation", tempCondition.occupation, null);
            if (!BcStringUtil.isEmpty(tempCondition.area) || !BcStringUtil.isEmpty(tempCondition.businessType)) {
                isJoin = true;
                SqlConditionParser.getInstance().parseCondition(selectQuery, sqlContext, "shop.area", tempCondition.area, null);
                SqlConditionParser.getInstance().parseCondition(selectQuery, sqlContext, "shop.business_type", tempCondition.businessType, null);
            }
        }
        Wbs1AnswerDAO.setJudgementCondition(selectQuery, aliasWk, judgementCondition);
        selectQuery.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (isJoin) {
            selectQuery.setFromClause(String.valueOf(selectQuery.getFromClause()) + " LEFT JOIN wbs1_shop AS shop ON shop.id = rct.shop_id");
        }
        if (mode == 1) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
        } else if (mode == 2) {
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "person_id");
        }
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectQuery;
    }

    public <T> List<T> getList(DtsSession dtsSession, int mode, long dataId, long personId, WbsTempCondition tempCondition, WbsJudgementCondition judgementCondition) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "rct";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, dataId, personId, tempCondition, judgementCondition);
        String query = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, query);
    }

    public <T> T getById(DtsSession dtsSession, long dataId) throws Exception {
        if (dataId <= 0L) {
            return null;
        }
        int personId = -1;
        List<T> entityList = this.getList(dtsSession, 1, dataId, personId, null, null);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ Wbs1RecruitmentDAO(Wbs1RecruitmentDAO wbs1RecruitmentDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1RecruitmentDAO instance = new Wbs1RecruitmentDAO(null);

        private SingletonHolder() {
        }
    }
}

