/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.servlet;

import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.app.common.AfbApplicationEvent;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.module.wbfw.common.WbfwResourceHolder;

public class WbfwServletContextListener
extends BcLoggableObject
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.getLogger().info("contextInitialized...");
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            this.contextInitializedL2(servletContextEvent);
        }
        catch (Exception ex) {
            this.getLogger().error(ex);
        }
    }

    private void contextInitializedL2(ServletContextEvent servletContextEvent) throws Exception {
        ServletContext servletContext = servletContextEvent.getServletContext();
        this.getLogger().info("ServletContextName=" + servletContext.getServletContextName());
        if (AfbApplication.getInstance().getAppDirectry() == null) {
            String contextRoot = servletContext.getRealPath("");
            this.getLogger().info("contextRoot=" + contextRoot);
            File contextRootDir = new File(contextRoot);
            this.getLogger().info("contextRootDir=" + contextRootDir.getPath());
            File bootConfigDir = new File(contextRootDir, "BOOT-CONFIG/");
            this.getLogger().info("bootConfigDir=" + bootConfigDir.getPath());
            File containerDir = contextRootDir.getParentFile().getParentFile();
            this.getLogger().info("containerDir=" + containerDir.getPath());
            String appDirStr = servletContext.getInitParameter("appDir");
            File appDir = null;
            if (!BcStringUtil.isEmpty(appDirStr)) {
                appDir = new File(appDirStr);
            }
            if (appDir == null) {
                appDir = containerDir.getParentFile();
            }
            this.getLogger().info("appDir=" + appDir.getPath());
            AfbApplication.getInstance().setAppDirectry(appDir);
            WbfwResourceHolder.getInstance().bootConfigDir = bootConfigDir;
        }
        AfbApplication application = AfbApplication.getInstance();
        application.startForServlet(WbfwResourceHolder.getInstance().bootConfigDir);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        this.getLogger().info("contextDestroyed...");
        AfbApplication application = AfbApplication.getInstance();
        application.fireEvent(new AfbApplicationEvent(this, 31));
    }
}

