/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.server;

import java.util.Date;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.etc.model.EtcMail;
import jp.co.extreme.mail.BcMailUtil;
import jp.co.extreme.module.wbfw.server.XdtsMailAuthenticator;
import jp.co.extreme.module.wbfw.server.XdtsMailPack;
import jp.co.extreme.task.TskAbstractCallable;

public class XdtsMailHelper
extends BcLoggableObject {
    private ConcurrentLinkedQueue<XdtsMailPack> mailQueue = new ConcurrentLinkedQueue();
    private MailSendTask mailSendTask = new MailSendTask();
    public String charCode;
    public boolean active;

    private XdtsMailHelper() {
        this.charCode = BcCharsetNames.UTF_8.value;
        this.active = true;
    }

    public static XdtsMailHelper getInstance() {
        return SingletonHolder.instance;
    }

    public MimeMessage createMessage(Session session, EtcMail mail) throws Exception {
        MimeMessage mimeMessage = new MimeMessage(session);
        mimeMessage.setSentDate(new Date());
        String fromAddress = BcMailUtil.encodeForSubject(mail.from, this.charCode);
        InternetAddress fromInternetAddress = null;
        fromInternetAddress = BcStringUtil.isEmpty(mail.personal) ? new InternetAddress(fromAddress) : new InternetAddress(fromAddress, mail.personal, BcCharsetNames.ISO_2022_JP.value);
        mimeMessage.setFrom((Address)fromInternetAddress);
        mimeMessage.setRecipients(Message.RecipientType.TO, BcMailUtil.encodeForSubject(mail.to, this.charCode));
        if (!BcStringUtil.isEmpty(mail.cc)) {
            InternetAddress[] ccAaddresses = InternetAddress.parse((String)BcMailUtil.encodeForSubject(mail.cc, this.charCode), (boolean)BcMailUtil.isRFC822);
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])ccAaddresses);
        }
        if (!BcStringUtil.isEmpty(mail.bcc)) {
            InternetAddress[] bccAddresses = InternetAddress.parse((String)BcMailUtil.encodeForSubject(mail.bcc, this.charCode), (boolean)BcMailUtil.isRFC822);
            mimeMessage.setRecipients(Message.RecipientType.BCC, (Address[])bccAddresses);
        }
        String subject = BcMailUtil.encodeForSubject(mail.subject, this.charCode);
        mimeMessage.setSubject(subject, this.charCode);
        BcMailUtil.setContent(mimeMessage, mail.content, this.charCode);
        BcMailUtil.fileAttach(mimeMessage, mail.fileCollection);
        mimeMessage.setHeader("User-Agent", "EXT-Mailer");
        return mimeMessage;
    }

    public void sendMessage(Properties smptProps, String userName, String password, EtcMail mail) throws Exception {
        if (!this.active) {
            this.getLogger().warning("sendMessage:active=" + this.active);
            return;
        }
        this.getLogger().debug("userName=" + userName);
        XdtsMailAuthenticator mailAuthenticator = new XdtsMailAuthenticator(userName, password);
        Session session = Session.getInstance((Properties)smptProps, (Authenticator)mailAuthenticator);
        this.getLogger().debug("session=" + session);
        MimeMessage message = this.createMessage(session, mail);
        this.getLogger().debug("message=" + message);
        Transport transport = session.getTransport();
        this.getLogger().debug("transport=" + transport);
        transport.connect();
        this.getLogger().debug("transport connected.");
        try {
            transport.sendMessage((Message)message, message.getAllRecipients());
            this.getLogger().debug("send mail complete.");
        }
        finally {
            transport.close();
        }
    }

    public Future<Object> addMail(Properties smptProps, String userName, String password, EtcMail mail) throws Exception {
        XdtsMailPack mailPack = new XdtsMailPack();
        mailPack.smptProps = smptProps;
        mailPack.userName = userName;
        mailPack.password = password;
        mailPack.mail = mail;
        this.mailQueue.add(mailPack);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Future<Object> future = executorService.submit(this.mailSendTask);
        return future;
    }

    /* synthetic */ XdtsMailHelper(XdtsMailHelper xdtsMailHelper) {
        this();
    }

    class MailSendTask
    extends TskAbstractCallable {
        public Object taskProcess() throws Exception {
            while (true) {
                XdtsMailPack mailPack = (XdtsMailPack)XdtsMailHelper.this.mailQueue.poll();
                this.getLogger().info("poll:mailPack=" + mailPack);
                if (mailPack == null) break;
                EtcMail mail = mailPack.mail;
                try {
                    XdtsMailHelper.this.sendMessage(mailPack.smptProps, mailPack.userName, mailPack.password, mail);
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
            return null;
        }
    }

    private static final class SingletonHolder {
        private static final XdtsMailHelper instance = new XdtsMailHelper(null);

        private SingletonHolder() {
        }
    }
}

