/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.wbfw.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.co.extreme.activation.BcMimeUtil;
import jp.co.extreme.base.charset.BcCharsetNames;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.io.BcStreamTransmitter;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.net.BcNetUtil;
import jp.co.extreme.base.util.BcObjectNotFoundException;
import jp.co.extreme.base.util.BcObjectPoolManager;
import jp.co.extreme.base.util.BcReflectUtil;
import jp.co.extreme.base.yaml.BcYamlUtil;
import jp.co.extreme.css.common.CssConstants;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.http.HttpConstants;
import jp.co.extreme.json.JacksonUtil;
import jp.co.extreme.module.wbfw.common.WbSessionTimeoutException;
import jp.co.extreme.module.wbfw.common.WbfSiteContext;
import jp.co.extreme.module.wbfw.common.WbfwConstants;
import jp.co.extreme.module.wbfw.common.WbfwUploadContext;
import jp.co.extreme.module.wbfw.common.WbfwUrlParameterMap;
import jp.co.extreme.module.wbfw.common.XwebEncryptor;
import jp.co.extreme.module.wbfw.container.WbfwRequestParameter;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.wbfw.session.WbfwHttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class WbfwUtil {
    public static Class[] paramTypeArray = new Class[]{WbfwWcbArgument.class};
    protected static boolean fileCashEnabled = false;
    protected static Map<String, byte[]> fileMap = new HashMap<String, byte[]>();
    public static final String SUFFUX_ARRAY = "[]";

    private WbfwUtil() {
    }

    public static void setCookie(HttpServletRequest servReq, HttpServletResponse httpRes, String name, String value, int maxAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAge);
        cookie.setPath("/");
        if (BcNetUtil.Protocol.https.name().equalsIgnoreCase(servReq.getScheme())) {
            cookie.setSecure(true);
        }
        httpRes.addCookie(cookie);
    }

    public static Cookie getCookie(HttpServletRequest servReq, String cookieName) {
        Cookie[] cookies = servReq.getCookies();
        if (cookies == null) {
            return null;
        }
        int i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            if (cookie.getName().equals(cookieName)) {
                return cookie;
            }
            ++i;
        }
        return null;
    }

    public static String getCookieValue(HttpServletRequest servReq, String cookieName) {
        Cookie \uff43ookie = WbfwUtil.getCookie(servReq, cookieName);
        if (\uff43ookie != null) {
            return \uff43ookie.getValue();
        }
        return null;
    }

    public static void cookieLog(HttpServletRequest servReq) {
        Cookie[] cookies = servReq.getCookies();
        if (cookies == null) {
            return;
        }
        int i = 0;
        while (i < cookies.length) {
            Cookie cookie = cookies[i];
            BcLogUtil.debug("cookie:name=" + cookie.getName() + " value=" + cookie.getValue());
            ++i;
        }
    }

    public static void setResponseHeader(WbfwWcbArgument wcbArg, String fileName) throws Exception {
        String mimeType = BcMimeUtil.getMimeType(fileName);
        wcbArg.getResponse().setContentType(mimeType);
        String fileName2 = URLEncoder.encode(fileName, BcConstants.charset.name());
        wcbArg.getResponse().setHeader("Cache-Control", "public");
        wcbArg.getResponse().setHeader("Content-Disposition", "inline; filename=" + BcStringUtil.doubleQuotation(fileName2));
    }

    public static void output(WbfwWcbArgument wcbArg, String str) throws Exception {
        PrintWriter printWriter = null;
        WbfwConstants.TerminalType terminalType = WbfwConstants.TerminalType.Smartphone;
        switch (terminalType) {
            case CellularPhone: {
                printWriter = wcbArg.getWriter(BcCharsetNames.SJIS.value);
                break;
            }
            default: {
                printWriter = wcbArg.getWriter(BcConstants.charset.name());
            }
        }
        printWriter.print(str);
        printWriter.flush();
    }

    public static void outputHtml(WbfwWcbArgument wcbArg, String html) throws Exception {
        WbfwUtil.setResponseHeader(wcbArg, "dummy.html");
        WbfwUtil.output(wcbArg, html);
    }

    public static void outputText(WbfwWcbArgument wcbArg, String html) throws Exception {
        wcbArg.getResponse().setContentType(BcMimeUtil.MimeType.text_plain.value);
        WbfwUtil.output(wcbArg, html);
    }

    public static void outputJsonStr(WbfwWcbArgument wcbArg, String jsonStr) throws Exception {
        wcbArg.getResponse().setContentType(BcMimeUtil.MimeType.application_json.value);
        WbfwUtil.output(wcbArg, jsonStr);
    }

    public static void outputJson(WbfwWcbArgument wcbArg, Object entity) throws Exception {
        String jsonStr = null;
        if (entity instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)entity;
            jsonStr = jsonNode.toString();
        } else {
            ObjectMapper objectMapper = JacksonUtil.getObjectMapper();
            jsonStr = objectMapper.writeValueAsString(entity);
        }
        WbfwUtil.outputJsonStr(wcbArg, jsonStr);
    }

    public static void outputFile(WbfwWcbArgument wcbArg, String fileName, byte[] bytes) throws Exception {
        WbfwUtil.setResponseHeader(wcbArg, fileName);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        String extention = BcFileUtil.getExtention(fileName);
        if (HtmlUtil.isHtml(extention)) {
            StringBuilder html = new StringBuilder();
            html.append(BcStreamUtil.readAsString((InputStream)byteArrayInputStream, BcConstants.charset));
            WbfwUtil.outputHtml(wcbArg, html.toString());
            return;
        }
        BcStreamUtil.transmit(byteArrayInputStream, (OutputStream)wcbArg.getResponse().getOutputStream(), -1);
    }

    public static void outputFile(WbfwWcbArgument wcbArg, File file) throws Exception {
        byte[] bytes = null;
        if (fileCashEnabled) {
            bytes = fileMap.get(file.getPath());
        }
        if (bytes != null) {
            WbfwUtil.outputFile(wcbArg, file.getName(), bytes);
            return;
        }
        if (!file.exists()) {
            wcbArg.getResponse().sendError(404);
            return;
        }
        if (file.isDirectory()) {
            BcLogUtil.debug("File is directory.");
            wcbArg.getResponse().sendError(404);
            return;
        }
        Throwable throwable = null;
        Object var4_6 = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BcStreamUtil.transmit(is, byteArrayOutputStream, -1);
            if (fileCashEnabled) {
                fileMap.put(file.getPath(), byteArrayOutputStream.toByteArray());
            }
            bytes = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        WbfwUtil.outputFile(wcbArg, file.getName(), bytes);
    }

    protected static File getFile_0(WbfwWcbArgument wcbArg, String path) throws Exception {
        WbfSiteContext siteContext = wcbArg.getSiteContext();
        File file1 = null;
        for (File dir : siteContext.resourceDirList) {
            File file2 = new File(dir, path);
            if (!file2.exists()) continue;
            file1 = file2;
            break;
        }
        return file1;
    }

    public static File getFile(WbfwWcbArgument wcbArg, String path) throws Exception {
        WbfSiteContext siteContext = wcbArg.getSiteContext();
        File file1 = null;
        if (path.endsWith("/color.css")) {
            if (!BcStringUtil.isEmpty(siteContext.theme)) {
                File themeDir = WbfwUtil.getFile_0(wcbArg, "theme");
                BcLogUtil.debug("themeDir=" + themeDir.getPath());
                if (themeDir == null) {
                    return null;
                }
                File cssFile = new File(themeDir, String.valueOf(siteContext.theme) + "." + (Object)((Object)CssConstants.FileExtention.css));
                if (!cssFile.exists()) {
                    String ymlFileName = String.valueOf(siteContext.theme) + BcYamlUtil.EXTENTION_dot_yml;
                    File ymlFile = new File(themeDir, ymlFileName);
                    Map rootMap = (Map)BcYamlUtil.load(ymlFile);
                    String colorFileName = "color.txt";
                    File colorFile = new File(themeDir, colorFileName);
                    byte[] bytes = BcStreamUtil.readWithClose(new FileInputStream(colorFile));
                    String css = new String(bytes);
                    for (Map.Entry mapEentry : rootMap.entrySet()) {
                        css = css.replace(BcStringUtil.toPlaceholder(mapEentry.getKey().toString()), mapEentry.getValue().toString());
                    }
                    BcFileUtil.save(cssFile, css);
                }
                file1 = cssFile;
            }
        } else {
            file1 = WbfwUtil.getFile_0(wcbArg, path);
        }
        return file1;
    }

    public static boolean isPost(String method) {
        return BcStringUtil.equalsIgnoreCase(method, "POST");
    }

    public static boolean isMultipartFormData(String contentType) {
        if (BcStringUtil.isEmpty(contentType)) {
            return false;
        }
        return contentType.startsWith("multipart/form-data");
    }

    public static int calcPageCount(int rowCount, int rowCountAtPage) {
        if (rowCountAtPage <= 0) {
            return -1;
        }
        int pageCount = rowCount / rowCountAtPage;
        if (rowCount % rowCountAtPage > 0) {
            ++pageCount;
        }
        return pageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invoke(String className, String methodName, WbfwWcbArgument wcbArg) throws Exception {
        Object targetInstance = BcObjectPoolManager.getInstance().getObject(className);
        Class<?> clazz = null;
        if (targetInstance == null) {
            Class<?> clazz2 = clazz = Class.forName(className);
            synchronized (clazz2) {
                targetInstance = BcObjectPoolManager.getInstance().getObject(className);
                if (targetInstance == null) {
                    targetInstance = BcReflectUtil.createInstance(clazz);
                    BcObjectPoolManager.getInstance().addObject(className, targetInstance);
                }
            }
        } else {
            clazz = targetInstance.getClass();
        }
        if (clazz == null) {
            String msg = "Not Found. class=" + className;
            throw new BcObjectNotFoundException(msg);
        }
        WbfwUtil.invoke(targetInstance, methodName, wcbArg);
    }

    public static void invoke(Object targetInstance, String methodName, WbfwWcbArgument wcbArg) throws Exception {
        Class<?> clazz = targetInstance.getClass();
        Method method = null;
        do {
            try {
                method = clazz.getDeclaredMethod(methodName, paramTypeArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        } while (method == null && (clazz = clazz.getSuperclass()) != null);
        if (method == null) {
            String msg = "Not Found. method=" + targetInstance.getClass().getName() + "#" + methodName;
            throw new BcObjectNotFoundException(msg);
        }
        Object[] paramArray = new Object[]{wcbArg};
        try {
            method.invoke(targetInstance, paramArray);
        }
        catch (InvocationTargetException ex) {
            Throwable throwable = ex.getCause();
            if (Exception.class.isAssignableFrom(throwable.getClass())) {
                throw (Exception)throwable;
            }
            throw new Exception(throwable);
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    public static WbfwRequestParameter parseRequestParameter(HttpServletRequest httpReq, File tempDir) throws Exception {
        WbfwRequestParameter requestParameter = new WbfwRequestParameter();
        boolean isMultiPart = WbfwUtil.isMultipartFormData(httpReq.getContentType());
        if (!isMultiPart) {
            requestParameter.map = WbfwUtil.extractParameters(httpReq, BcConstants.charset.name());
            return requestParameter;
        }
        DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
        BcFileUtil.mkdirs(tempDir, new FileAttribute[0]);
        diskFileItemFactory.setRepository(tempDir);
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
        List fileItemList = servletFileUpload.parseRequest(httpReq);
        requestParameter.map = new WbfwUrlParameterMap();
        requestParameter.uploadContextList = new ArrayList<WbfwUploadContext>();
        int i = 0;
        while (i < fileItemList.size()) {
            FileItem fileItem = (FileItem)fileItemList.get(i);
            if (fileItem.isFormField()) {
                String itemValue = fileItem.getString(BcConstants.charset.name());
                ArrayList<String> valueList = null;
                Object existingValue = requestParameter.map.get(fileItem.getFieldName());
                if (existingValue instanceof List) {
                    valueList = (ArrayList<String>)existingValue;
                } else if (WbfwUtil.isArrayParam(fileItem.getFieldName())) {
                    valueList = new ArrayList<String>();
                    requestParameter.map.put(fileItem.getFieldName(), valueList);
                } else if (existingValue != null) {
                    valueList = new ArrayList();
                    valueList.add(existingValue.toString());
                    requestParameter.map.put(fileItem.getFieldName(), valueList);
                }
                if (valueList == null) {
                    requestParameter.map.put(fileItem.getFieldName(), itemValue);
                } else {
                    valueList.add(itemValue);
                }
            } else if (!BcStringUtil.isEmpty(fileItem.getName())) {
                WbfwUploadContext uploadContext = WbfwUtil.fileUpload(fileItem, tempDir);
                requestParameter.uploadContextList.add(uploadContext);
            }
            ++i;
        }
        return requestParameter;
    }

    public static boolean isArrayParam(String paramName) {
        return paramName.endsWith(SUFFUX_ARRAY);
    }

    public static WbfwUploadContext fileUpload(FileItem fileItem, File tempDir) throws Exception {
        try (BufferedInputStream is = new BufferedInputStream(fileItem.getInputStream());){
            File destfile = File.createTempFile("upload_", ".tmp", tempDir);
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(destfile));){
                BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
                streamTransmitter.transmit(is, os);
            }
            WbfwUploadContext uploadContext = new WbfwUploadContext();
            uploadContext.fieldName = fileItem.getFieldName();
            uploadContext.fileName = fileItem.getName();
            uploadContext.tempFile = destfile;
            WbfwUploadContext wbfwUploadContext = uploadContext;
            return wbfwUploadContext;
        }
    }

    public static WbfwUrlParameterMap extractParameters(HttpServletRequest httpReq, String encoding) throws Exception {
        WbfwUrlParameterMap parameterMap;
        block3: {
            block4: {
                block2: {
                    parameterMap = null;
                    String userAgent = httpReq.getHeader(HttpConstants.RequestHeader.User_Agent.value);
                    boolean isMobile = HttpConstants.isMobile(userAgent);
                    if (!isMobile) break block2;
                    parameterMap = WbfwUtil.extractParametersMobile(httpReq);
                    break block3;
                }
                parameterMap = new WbfwUrlParameterMap();
                if (!"POST".equalsIgnoreCase(httpReq.getMethod())) break block4;
                Enumeration enumeration = httpReq.getParameterNames();
                httpReq.setCharacterEncoding(encoding);
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    String value = httpReq.getParameter(key);
                    parameterMap.put(key, value);
                }
                break block3;
            }
            if (!"GET".equalsIgnoreCase(httpReq.getMethod())) break block3;
            httpReq.setCharacterEncoding(encoding);
            Enumeration enumeration = httpReq.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = httpReq.getParameter(key);
                parameterMap.put(key, value);
            }
        }
        return parameterMap;
    }

    public static StringBuilder httpSessionInfo(WbfwHttpSession httpSession) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("id=" + httpSession.getId());
        sb.append(" creationTime=" + BcTimeUtil.toString(httpSession.getCreationTime(), "yyyy/MM/dd HH:mm:ss.SSS"));
        sb.append(" lastAccessedTime=" + BcTimeUtil.toString(httpSession.getLastAccessedTime(), "yyyy/MM/dd HH:mm:ss.SSS"));
        sb.append(" maxInactiveInterval=" + httpSession.getMaxInactiveInterval());
        sb.append(" attributeSize=" + httpSession.getAttributeMap().size());
        sb.append(" endTime=" + BcTimeUtil.toString(httpSession.endTime, "yyyy/MM/dd HH:mm:ss.SSS"));
        return sb;
    }

    public static WbfwUrlParameterMap extractParametersMobile(HttpServletRequest httpReq) throws Exception {
        WbfwUrlParameterMap parameterMap = new WbfwUrlParameterMap();
        httpReq.setCharacterEncoding("Windows-31J");
        if (BcStringUtil.equalsIgnoreCase(httpReq.getMethod(), "POST")) {
            Enumeration enumeration = httpReq.getParameterNames();
            BcStringUtil.isEmpty(httpReq.getCharacterEncoding());
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = httpReq.getParameter(key);
                if (BcStringUtil.isEmpty(httpReq.getCharacterEncoding())) {
                    value = new String(value.getBytes("8859_1"), "Windows-31J");
                }
                parameterMap.put(key, value);
            }
        } else if (BcStringUtil.equalsIgnoreCase(httpReq.getMethod(), "GET")) {
            Enumeration enumeration = httpReq.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                String value = httpReq.getParameter(key);
                value = new String(value.getBytes("8859_1"), "Windows-31J");
                parameterMap.put(key, value);
            }
        } else {
            throw new Exception("httpReq.getMethod()=" + httpReq.getMethod());
        }
        return parameterMap;
    }

    public static HttpSession getSession(WbfwWcbArgument wcbArg, boolean doCreate, boolean doThrow) throws Exception {
        HttpSession httpSession = wcbArg.getRequest().getSession(false);
        if (httpSession == null) {
            if (doCreate) {
                httpSession = wcbArg.getRequest().getSession(true);
            } else if (doThrow) {
                throw new WbSessionTimeoutException("\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u3067\u3059");
            }
        }
        if (httpSession != null) {
            WbfwUtil.setCookie(wcbArg.getRequest(), wcbArg.getResponse(), WbfwConstants.CookieName.sessionId.name(), httpSession.getId(), -1);
        }
        return httpSession;
    }

    public static void putMapEntry(Map<String, String> map, Object key, Object value) throws Exception {
        map.put(key.toString(), BcStringUtil.toString(value));
    }

    public static String createParameter(String key, Object value) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(key);
        if (!BcStringUtil.isEmpty(value)) {
            sb.append("=");
            sb.append(value);
        }
        return sb.toString();
    }

    public static String createParameter(String key, Number number) throws Exception {
        return WbfwUtil.createParameter(key, (Object)BcNumberUtil.toString(number));
    }

    public static String createParameter(Enum aEnum, String value) throws Exception {
        return WbfwUtil.createParameter(aEnum.name(), (Object)value);
    }

    public static String createParameter(Enum aEnum, Number number) throws Exception {
        return WbfwUtil.createParameter(aEnum.name(), (Object)BcNumberUtil.toString(number));
    }

    public static List<String> createParameterList(Map<String, Object> map) throws Exception {
        ArrayList<String> parameterList = new ArrayList<String>();
        for (Map.Entry<String, Object> mapEntry : map.entrySet()) {
            parameterList.add(WbfwUtil.createParameter(mapEntry.getKey(), mapEntry.getValue()));
        }
        return parameterList;
    }

    public static String createUrlQuery(String ... parameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < parameters.length) {
            String parameter = parameters[i];
            if (i == 0) {
                sb.append("?");
            } else {
                sb.append("&");
            }
            sb.append(parameter);
            ++i;
        }
        return sb.toString();
    }

    public static String createUrlQuery(List<String> parameterList) throws Exception {
        String[] parameters = parameterList.toArray(new String[0]);
        return WbfwUtil.createUrlQuery(parameters);
    }

    public static String createUrlQuery(Map<String, Object> map) throws Exception {
        List<String> parameterList = WbfwUtil.createParameterList(map);
        return WbfwUtil.createUrlQuery(parameterList);
    }

    public static String createEncryptQuery(WbfwUrlParameterMap map) throws Exception {
        String encryptStr = XwebEncryptor.getInstance().encryptMap(map);
        encryptStr = URLEncoder.encode(encryptStr, BcConstants.charset.name());
        return WbfwUtil.createParameter(WbfwConstants.UrlParam1.param.name(), (Object)encryptStr);
    }

    public static WbfwUrlParameterMap getDecryptMap(Map<String, Object> paramMap) throws Exception {
        Object encryptStr = paramMap.get(WbfwConstants.UrlParam1.param.name());
        WbfwUrlParameterMap map = null;
        map = BcStringUtil.isEmpty(encryptStr) ? new WbfwUrlParameterMap() : XwebEncryptor.getInstance().decryptMap(encryptStr.toString());
        return map;
    }

    public static String toTimeValue(Short hhmm) throws Exception {
        if (hhmm == null) {
            return null;
        }
        String tmpString = BcStringUtil.fillPrefix(Short.toString(hhmm), 4, '0');
        StringBuilder sb = new StringBuilder();
        sb.append(tmpString.substring(0, 2));
        sb.append(':');
        sb.append(tmpString.substring(2, 4));
        return sb.toString();
    }

    public static String toPlaceHolder(String name) {
        return "${" + name + "}";
    }

    public static String toPlaceHolder(Enum aEnum) {
        return WbfwUtil.toPlaceHolder(aEnum.name());
    }

    public static String toElementName(String className, String fieldName, boolean isArray) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append('.');
        sb.append(fieldName);
        if (isArray) {
            sb.append(SUFFUX_ARRAY);
        }
        return sb.toString();
    }

    public static String toElementName(Class clazz, Enum fieldName, boolean isArray) {
        return WbfwUtil.toElementName(clazz.getSimpleName(), fieldName.name(), isArray);
    }

    public static String createRequestUrl(HttpServletRequest httpReq) {
        StringBuilder sb = new StringBuilder();
        sb.append(httpReq.getRequestURL());
        if (!BcStringUtil.isEmpty(httpReq.getQueryString())) {
            sb.append("?");
            sb.append(httpReq.getQueryString());
        }
        return sb.toString();
    }

    public static String getServletPath(HttpServletRequest httpReq) {
        String servletPath = BcFileUtil.deleteTopSlash(httpReq.getServletPath());
        int index = servletPath.indexOf("/");
        if (index > 0) {
            servletPath = servletPath.substring(0, index);
        }
        return servletPath;
    }

    public static String createPathInfo(HttpServletRequest httpReq, String servletPath) {
        int rest = httpReq.getServletPath().length() - servletPath.length() - 1;
        if (rest > 0) {
            return httpReq.getServletPath().substring(servletPath.length() + 2);
        }
        return null;
    }
}

