/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.mmdx.fx;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.table.FxTableUtil;
import jp.co.extreme.fx.table.FxTableView;
import jp.co.extreme.module.mmdx.common.MmdxConstants;
import jp.co.extreme.module.mmdx.fx.MmdxEventHandler;
import jp.co.extreme.module.mmdx.fx.MmdxModelEditor;
import jp.co.extreme.module.mmdx.model.MmdxModel;
import jp.co.extreme.module.mmdx.rmo.MmdxModelListRMO;
import jp.co.extreme.module.mmdx.stub.MmdxModelStub;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.scf4.fx.HfxLoadableTablePane;

public class MmdxModelListPane
extends FxDecoratePane
implements MmdxEventHandler {
    protected InnerTablePane tablePane = new InnerTablePane();
    protected Button button1;
    protected Button button2;
    protected Button button3;
    Integer schemaId;
    String tableName;
    protected Stage stage;

    public MmdxModelListPane() throws Exception {
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        this.button1 = this.createButton(BcWords.getInstance().add);
        this.button2 = this.createButton(BcWords.getInstance().open);
        this.button3 = this.createButton(BcWords.getInstance().close);
        this.setCenter((Node)this.tablePane);
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(MmdxModelListRMO.class.getName());
        rmiReq.setMethodName("modeltList");
        this.tablePane.doLoad(rmiReq);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() != this.button1) {
            if (ev.getSource() == this.button2) {
                MmdxModel mmdxModel = MmdxModelStub.getInstance().getDataModel(this.schemaId, this.tableName);
                MmdxModelEditor modelEditor = new MmdxModelEditor();
                modelEditor.setData(mmdxModel);
                modelEditor.show(this.getScene().getWindow());
            } else if (ev.getSource() == this.button3) {
                this.close();
            }
        }
    }

    public void close() {
        this.stage.close();
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        this.stage.initOwner(ownerWindow);
        if (ownerWindow != null) {
            this.stage.initModality(Modality.APPLICATION_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShowing((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                BcLogUtil.debug("setOnShown");
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setResizable(true);
        this.stage.setWidth(800.0);
        this.stage.setHeight(600.0);
        this.stage.setTitle("Model List");
        this.stage.showAndWait();
    }

    @Override
    public void mmdSelected(Object obj) throws Exception {
        Integer modelId = (Integer)obj;
        MmdxModelEditor modelEditor = new MmdxModelEditor();
    }

    class InnerTablePane
    extends HfxLoadableTablePane {
        @Override
        protected TableView createTableView() throws Exception {
            HfxLoadableTablePane.InnerTableView tableView = new HfxLoadableTablePane.InnerTableView(this);
            tableView.setItems(FXCollections.observableArrayList());
            return tableView;
        }
    }

    class InnerTableView
    extends FxTableView {
        public InnerTableView() throws Exception {
            TableView.TableViewSelectionModel selectionModel = this.getSelectionModel();
            selectionModel.setSelectionMode(SelectionMode.SINGLE);
        }

        @Override
        public void rowSelectionChanged(FxTableView tableView, ObservableList<Integer> rowIdList, int prevRowId, int nextRowId) throws Exception {
            super.rowSelectionChanged((FxTableView)this, rowIdList, prevRowId, nextRowId);
            MmdxModelListPane.this.schemaId = (Integer)FxTableUtil.getCellValue((TableView)this, nextRowId, MmdxConstants.TableColmnName.mdx_model__schema_id.value);
            MmdxModelListPane.this.tableName = (String)FxTableUtil.getCellValue((TableView)this, nextRowId, MmdxConstants.TableColmnName.mdx_model__table_name.value);
            MmdxModelListPane.this.button2.setDisable(false);
        }
    }
}

