/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.lib.editorjs;

import com.fasterxml.jackson.databind.JsonNode;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;

public class EditorJsHtmlConverter
extends BcLoggableObject {
    protected XwebHtmlBuilder htmlBuilder;

    public void setHtmlBuilder(XwebHtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    public StringBuilder create(JsonNode jsonNode) throws Exception {
        StringBuilder sb = new StringBuilder();
        JsonNode blocksNode = jsonNode.get(Node.blocks.name());
        int i = 0;
        while (i < blocksNode.size()) {
            JsonNode blockNode = blocksNode.get(i);
            sb.append((CharSequence)this.parseBlockNode(blockNode));
            ++i;
        }
        return sb;
    }

    protected StringBuilder parseBlockNode(JsonNode blockNode) throws Exception {
        StringBuilder sb = new StringBuilder();
        JsonNode idNode = blockNode.get(Node.id.name());
        JsonNode typeNode = blockNode.get(Node.type.name());
        this.getLogger().debug("typeNode=" + typeNode);
        JsonNode dataNode = blockNode.get(Node.data.name());
        Type type = Type.valueOf(typeNode.asText());
        switch (type) {
            case header: 
            case paragraph: {
                JsonNode textNode = dataNode.get("text");
                this.getLogger().debug("textNode=" + textNode);
                sb.append(this.htmlBuilder.p(textNode.asText(), true));
                break;
            }
            case list: {
                break;
            }
            case image: {
                JsonNode fileNode = dataNode.get("file");
                this.getLogger().debug("fileNode=" + fileNode);
                JsonNode urlNode = fileNode.get("url");
                String imageUrl = this.convImageUrl(urlNode);
                sb.append(this.htmlBuilder.image(imageUrl, "100%", null, null));
            }
        }
        return sb;
    }

    protected String convImageUrl(JsonNode urlNode) throws Exception {
        this.getLogger().debug("urlNode=" + urlNode);
        return urlNode.asText();
    }

    public static enum Node {
        blocks,
        id,
        type,
        data;

    }

    public static enum Type {
        header,
        paragraph,
        list,
        image;

    }
}

