/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.layout;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Region;
import jp.co.extreme.base.core.BcDouble;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.swing.SwgUtil;

public class FxFlowPane
extends Region {
    public static final int VERTICAL_TOP = 11;
    public static final int HORIZONTAL_LEFT = 21;
    public static final int HORIZONTAL_CENTER = 22;
    private int arrangement = 11;
    public double topMargin = FxUtil.insetDefault;
    public double bottomMargin = FxUtil.insetDefault;
    public double leftMargin = FxUtil.insetDefault;
    public double leftRightSpace = 4.0;
    public double rightNodeSpace = 2.0;
    public double rowSpace = 4.0;
    public double unitSpace = FxUtil.insetDefault * 2.0;
    public List<FxNodeUnit> nodeUnitList = new ArrayList<FxNodeUnit>();
    private double preWidth;
    private double preHeight;
    public static final int ARRANGEMENT_null = 0;
    public static final int ARRANGEMENT_continue = 1;
    public static final int HANDLING_null = 0;
    public static final int HANDLING_widthIgnore = 1;
    public boolean isDebug;

    public FxFlowPane(int arrangement) throws Exception {
        this.setArrangement(arrangement);
    }

    public FxFlowPane() throws Exception {
    }

    public void removeAll() throws Exception {
        this.getChildren().clear();
        this.nodeUnitList.clear();
        this.preWidth = -1.0;
        this.preHeight = -1.0;
    }

    public int getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(int arrangement) {
        this.arrangement = arrangement;
        this.layoutChildren();
    }

    public void layoutChildren() {
        if (this.preWidth != this.getWidth() || this.preHeight != this.getHeight()) {
            try {
                this.layoutChildren_L2();
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
        this.preWidth = this.getWidth();
        this.preHeight = this.getHeight();
    }

    protected void layoutChildren_L2() throws Exception {
        switch (this.arrangement) {
            case 11: {
                this.verticalLayout_L1();
                break;
            }
            case 21: 
            case 22: {
                this.horizontalLayout_L1();
            }
        }
    }

    public void addNodeUnit(FxNodeUnit nodeUnit) throws Exception {
        this.nodeUnitList.add(nodeUnit);
        ObservableList children = this.getChildren();
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            children.add((Object)leftNode);
        }
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            if (rightNode != null) {
                children.add((Object)rightNode);
            }
            ++i;
        }
    }

    public void removeNodeUnit(FxNodeUnit nodeUnit) throws Exception {
        this.nodeUnitList.remove(nodeUnit);
    }

    public void clearNodeUnit() throws Exception {
        this.nodeUnitList.clear();
    }

    protected void verticalLayout_L1() throws Exception {
        List<List<FxNodeUnit>> nodeUnitListList1 = this.separate();
        BcDouble x1 = new BcDouble(this.leftMargin);
        BcDouble y1 = new BcDouble(this.topMargin);
        ArrayList<List<FxNodeUnit>> nodeUnitListList2 = new ArrayList<List<FxNodeUnit>>();
        int i = 0;
        while (i < nodeUnitListList1.size()) {
            List<FxNodeUnit> nodeUnitList2 = nodeUnitListList1.get(i);
            double unitHeightMax = FxUtil.computeHeightMax(nodeUnitList2);
            double vRest = this.getHeight() - y1.value - unitHeightMax - this.bottomMargin;
            if (vRest < 0.0) {
                double leftWidthMax = FxUtil.computeLeftWidthMax(nodeUnitListList2);
                y1.value = this.topMargin;
                double rowWidthmax = 0.0;
                int j = 0;
                while (j < nodeUnitListList2.size()) {
                    List nodeUnitList3 = (List)nodeUnitListList2.get(j);
                    if (j > 0) {
                        y1.value += this.rowSpace;
                    }
                    double x2 = x1.value;
                    int k = 0;
                    while (k < nodeUnitList3.size()) {
                        FxNodeUnit nodeUnit = (FxNodeUnit)nodeUnitList3.get(k);
                        double leftWidth = leftWidthMax;
                        if (k > 0) {
                            x2 += this.unitSpace;
                            leftWidth = FxUtil.computeLeftWidth(nodeUnit);
                        }
                        double rowWidth = this.verticalLayout_L2(x2, y1.value, leftWidth, nodeUnit);
                        x2 += rowWidth;
                        ++k;
                    }
                    double nodeUnitHeight2 = FxUtil.computeHeightMax(nodeUnitList3);
                    y1.value += nodeUnitHeight2;
                    rowWidthmax = Math.max(rowWidthmax, x2 - x1.value);
                    ++j;
                }
                nodeUnitListList2.clear();
                x1.value += this.unitSpace;
                x1.value += rowWidthmax;
                y1.value = this.topMargin;
            }
            y1.value += unitHeightMax;
            y1.value += this.rowSpace;
            nodeUnitListList2.add(nodeUnitList2);
            ++i;
        }
        y1.value = this.topMargin;
        double leftMax = FxUtil.computeLeftWidthMax(nodeUnitListList2);
        int j = 0;
        while (j < nodeUnitListList2.size()) {
            List nodeUnitList3 = (List)nodeUnitListList2.get(j);
            double x2 = x1.value;
            int k = 0;
            while (k < nodeUnitList3.size()) {
                FxNodeUnit nodeUnit = (FxNodeUnit)nodeUnitList3.get(k);
                double leftWidth = leftMax;
                if (k > 0) {
                    x2 += this.unitSpace;
                    leftWidth = FxUtil.computeLeftWidth(nodeUnit);
                }
                double rowWidth = this.verticalLayout_L2(x2, y1.value, leftWidth, nodeUnit);
                x2 += rowWidth;
                ++k;
            }
            double nodeUnitHeight2 = FxUtil.computeHeightMax(nodeUnitList3);
            y1.value += nodeUnitHeight2;
            y1.value += this.rowSpace;
            ++j;
        }
    }

    protected double verticalLayout_L2(double x1, double y1, double leftWidth, FxNodeUnit nodeUnit) throws Exception {
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            double prefWidth = FxUtil.getPrefWidth(leftNode);
            double prefHeight = FxUtil.getPrefHeight(leftNode);
            double x2 = x1;
            if (nodeUnit.leftNodeHandling != 1) {
                x2 += leftWidth - prefWidth;
            }
            leftNode.relocate(x2, y1);
            leftNode.resize(prefWidth, prefHeight);
            if (leftNode instanceof Label) {
                Label label = (Label)leftNode;
                label.setAlignment(Pos.CENTER_RIGHT);
            }
        }
        double x2 = x1 + leftWidth + this.leftRightSpace;
        int rightNodeCnt = 0;
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            if (rightNode != null) {
                if (++rightNodeCnt > 1) {
                    x2 += this.rightNodeSpace;
                }
                double prefWidth = FxUtil.getPrefWidth(rightNode);
                double prefHeight = FxUtil.getPrefHeight(rightNode);
                rightNode.relocate(x2, y1);
                rightNode.resize(prefWidth, prefHeight);
                x2 += prefWidth;
            }
            ++i;
        }
        double rowWidth = x2 - x1;
        return rowWidth;
    }

    protected List<List<FxNodeUnit>> separate() throws Exception {
        ArrayList<List<FxNodeUnit>> nodeUnitListList = new ArrayList<List<FxNodeUnit>>();
        ArrayList<FxNodeUnit> nodeUnitList2 = null;
        int i = 0;
        while (i < this.nodeUnitList.size()) {
            FxNodeUnit nodeUnit = this.nodeUnitList.get(i);
            if (i == 0 || nodeUnit.arrangement != 1) {
                nodeUnitList2 = new ArrayList<FxNodeUnit>();
                nodeUnitListList.add(nodeUnitList2);
            }
            nodeUnitList2.add(nodeUnit);
            ++i;
        }
        return nodeUnitListList;
    }

    protected void horizontalLayout_L1() throws Exception {
        double leftMax = FxUtil.computeLeftWidthMax(this.nodeUnitList);
        BcDouble x1 = new BcDouble(this.leftMargin);
        BcDouble y1 = new BcDouble(this.topMargin);
        double heightMax = 0.0;
        if (this.arrangement == 22) {
            double unitWidthSum = 0.0;
            int i = 0;
            while (i < this.nodeUnitList.size()) {
                FxNodeUnit nodeUnit = this.nodeUnitList.get(i);
                unitWidthSum += FxUtil.computeNodeUnitWidth(nodeUnit, this.leftRightSpace, this.rightNodeSpace);
                ++i;
            }
            if (this.nodeUnitList.size() > 0) {
                unitWidthSum += this.rowSpace * (double)this.nodeUnitList.size() - 1.0;
            }
            if (unitWidthSum + this.leftMargin * 2.0 <= this.getWidth()) {
                x1.value = (this.getWidth() - unitWidthSum) / 2.0;
            }
        }
        int i = 0;
        while (i < this.nodeUnitList.size()) {
            FxNodeUnit nodeUnit = this.nodeUnitList.get(i);
            double nodeUnitWidth = FxUtil.computeNodeUnitWidth(nodeUnit, this.leftRightSpace, this.rightNodeSpace);
            double rest = this.getWidth() - x1.value - nodeUnitWidth;
            if (rest < 0.0) {
                x1.value = this.leftMargin;
                y1.value += heightMax;
                y1.value += this.rowSpace;
                heightMax = 0.0;
            }
            heightMax = Math.max(heightMax, FxUtil.computeHeight(nodeUnit));
            this.horizontalLayout_L2(x1, y1, nodeUnit, leftMax);
            x1.value += this.unitSpace;
            ++i;
        }
    }

    protected void horizontalLayout_L2(BcDouble x1, BcDouble y1, FxNodeUnit nodeUnit, double leftMax) throws Exception {
        Node leftNode = nodeUnit.getLeftNode();
        if (leftNode != null) {
            double prefHeight = FxUtil.getPrefHeight(leftNode);
            leftNode.relocate(x1.value, y1.value);
            leftNode.resize(leftMax, prefHeight);
            if (leftNode instanceof Label) {
                Label label = (Label)leftNode;
                label.setAlignment(Pos.CENTER_RIGHT);
            }
        }
        if (leftMax > 0.0) {
            x1.value += leftMax;
            x1.value += this.leftRightSpace;
        }
        int i = 0;
        while (i < nodeUnit.getRightNodeList().size()) {
            Node rightNode = nodeUnit.getRightNodeList().get(i);
            if (rightNode != null) {
                double prefWidth = FxUtil.getPrefWidth(rightNode);
                double prefHeight = FxUtil.getPrefHeight(rightNode);
                rightNode.relocate(x1.value, y1.value);
                rightNode.resize(prefWidth, prefHeight);
                x1.value += prefWidth;
                x1.value += this.rightNodeSpace;
            }
            ++i;
        }
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, (Object)this);
    }

    protected void debugLog(Object log) {
        if (this.isDebug) {
            BcLogUtil.debug(log);
        }
    }
}

