/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.fx.extension;

import javafx.event.ActionEvent;
import javafx.geometry.Dimension2D;
import javafx.scene.Node;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import jp.co.extreme.base.util.BcTextFormatter;
import jp.co.extreme.etc.model.EtcInputText;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxBorderPane;
import jp.co.extreme.fx.util.FxFontUtil;
import jp.co.extreme.fx.util.FxUtil;

public class FxxGeneralControl
extends FxBorderPane
implements EtcInputText {
    public static final int MODE_detail = 1;
    public static final int MODE_condition = 2;
    int paddingSize = 4;
    public FxTextField imputTextField = new InnerInputTextField();
    protected HBox hBox = new HBox();
    public FxTextField nameTextField = new InnerNameTextField();
    protected FxButton optionButton = new FxButton();
    protected BcTextFormatter textFormatter;

    public FxxGeneralControl() throws Exception {
        this.nameTextField.setEditable(false);
        this.optionButton.setOnAction(this.actionEventHandler);
    }

    @Override
    public String getInputText() throws Exception {
        return this.imputTextField.getText();
    }

    @Override
    public void setInputText(String value) throws Exception {
        this.imputTextField.setText(value);
    }

    public void setValue(FxxGeneralControl generalControl) throws Exception {
        this.imputTextField.setText(generalControl.imputTextField.getText());
        this.nameTextField.setText(generalControl.nameTextField.getText());
    }

    public void setControlSize(int inputColumnCount, int nameColumnCount, boolean optionButtonEnabled) throws Exception {
        this.getChildren().clear();
        this.imputTextField.setPrefColumnCount(inputColumnCount);
        int columnCountSum = inputColumnCount;
        this.setLeft((Node)this.imputTextField);
        if (nameColumnCount > 0) {
            this.nameTextField.setPrefColumnCount(nameColumnCount);
            this.hBox.getChildren().add((Object)this.nameTextField);
            columnCountSum += nameColumnCount;
        }
        ++columnCountSum;
        if (optionButtonEnabled) {
            this.optionButton.setText("i");
            this.optionButton.setFont(FxFontUtil.font_10_black);
            this.hBox.getChildren().add((Object)this.optionButton);
            columnCountSum += 2;
            FxUtil.setFixedSize((Region)this.optionButton, 20.0, 18.0);
        }
        this.setRight((Node)this.hBox);
        Dimension2D dim2d = FxUtil.getTextFieldSize(FxFontUtil.getDefaultFont(), columnCountSum);
        FxUtil.setPrefSize((Region)this, dim2d);
    }

    public void setControlSize(int textColumnCount, int nameColumnCount) throws Exception {
        this.setControlSize(textColumnCount, nameColumnCount, false);
    }

    public BcTextFormatter getTextFormatter() throws Exception {
        return this.textFormatter;
    }

    public void setTextFormatter(BcTextFormatter textFormatter) throws Exception {
        this.textFormatter = textFormatter;
    }

    protected void imputTextChanged(String text) throws Exception {
        if (this.textFormatter != null) {
            String newText = this.textFormatter.format(text);
            this.setInputText(newText);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.optionButton) {
            this.optionButtonAction();
        }
    }

    public void optionButtonAction() throws Exception {
    }

    class InnerInputTextField
    extends FxTextField {
        @Override
        protected void keyEvent(KeyEvent ev) throws Exception {
            super.keyEvent(ev);
            ev.getEventType();
        }

        @Override
        protected void textEdited() throws Exception {
            super.textEdited();
            FxxGeneralControl.this.imputTextChanged(this.getText());
        }
    }

    class InnerNameTextField
    extends FxTextField {
        public InnerNameTextField() throws Exception {
            this.setFocusTraversable(false);
        }

        @Override
        public void focusIn() throws Exception {
            super.focusIn();
        }
    }
}

