/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;
import org.apache.xerces.impl.xs.identity.ValueStore;
import org.apache.xerces.impl.xs.identity.XPathMatcher;
import org.apache.xerces.impl.xs.util.ShortListImpl;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class Field {
    protected final XPath fXPath;
    protected final IdentityConstraint fIdentityConstraint;

    public Field(XPath xpath, IdentityConstraint identityConstraint) {
        this.fXPath = xpath;
        this.fIdentityConstraint = identityConstraint;
    }

    public org.apache.xerces.impl.xpath.XPath getXPath() {
        return this.fXPath;
    }

    public IdentityConstraint getIdentityConstraint() {
        return this.fIdentityConstraint;
    }

    public XPathMatcher createMatcher(ValueStore store) {
        return new Matcher(this.fXPath, store);
    }

    public String toString() {
        return this.fXPath.toString();
    }

    protected class Matcher
    extends XPathMatcher {
        protected final ValueStore fStore;
        protected boolean fMayMatch;

        public Matcher(XPath xpath, ValueStore store) {
            super(xpath);
            this.fMayMatch = true;
            this.fStore = store;
        }

        @Override
        protected void matched(Object actualValue, short valueType, ShortList itemValueType, boolean isNil) {
            super.matched(actualValue, valueType, itemValueType, isNil);
            if (isNil && Field.this.fIdentityConstraint.getCategory() == 1) {
                String code = "KeyMatchesNillable";
                this.fStore.reportError(code, new Object[]{Field.this.fIdentityConstraint.getElementName(), Field.this.fIdentityConstraint.getIdentityConstraintName()});
            }
            this.fStore.addValue(Field.this, this.fMayMatch, actualValue, this.convertToPrimitiveKind(valueType), this.convertToPrimitiveKind(itemValueType));
            this.fMayMatch = false;
        }

        private short convertToPrimitiveKind(short valueType) {
            if (valueType <= 20) {
                return valueType;
            }
            if (valueType <= 29) {
                return 2;
            }
            if (valueType <= 42) {
                return 4;
            }
            return valueType;
        }

        private ShortList convertToPrimitiveKind(ShortList itemValueType) {
            if (itemValueType != null) {
                int length = itemValueType.getLength();
                int i = 0;
                while (i < length) {
                    short type = itemValueType.item(i);
                    if (type != this.convertToPrimitiveKind(type)) break;
                    ++i;
                }
                if (i != length) {
                    short[] arr = new short[length];
                    int j = 0;
                    while (j < i) {
                        arr[j] = itemValueType.item(j);
                        ++j;
                    }
                    while (i < length) {
                        arr[i] = this.convertToPrimitiveKind(itemValueType.item(i));
                        ++i;
                    }
                    return new ShortListImpl(arr, arr.length);
                }
            }
            return itemValueType;
        }

        @Override
        protected void handleContent(XSTypeDefinition type, boolean nillable, Object actualValue, short valueType, ShortList itemValueType) {
            if (type == null || type.getTypeCategory() == 15 && ((XSComplexTypeDefinition)type).getContentType() != 1) {
                this.fStore.reportError("cvc-id.3", new Object[]{Field.this.fIdentityConstraint.getName(), Field.this.fIdentityConstraint.getElementName()});
            }
            this.fMatchedString = actualValue;
            this.matched(this.fMatchedString, valueType, itemValueType, nillable);
        }
    }

    public static class XPath
    extends org.apache.xerces.impl.xpath.XPath {
        public XPath(String xpath, SymbolTable symbolTable, NamespaceContext context) throws XPathException {
            super(XPath.fixupXPath(xpath), symbolTable, context);
            int i = 0;
            while (i < this.fLocationPaths.length) {
                int j = 0;
                while (j < this.fLocationPaths[i].steps.length) {
                    XPath.Axis axis = this.fLocationPaths[i].steps[j].axis;
                    if (axis.type == 2 && j < this.fLocationPaths[i].steps.length - 1) {
                        throw new XPathException("c-fields-xpaths");
                    }
                    ++j;
                }
                ++i;
            }
        }

        private static String fixupXPath(String xpath) {
            int end = xpath.length();
            int offset = 0;
            boolean whitespace = true;
            while (offset < end) {
                char c = xpath.charAt(offset);
                if (whitespace) {
                    if (!XMLChar.isSpace(c)) {
                        if (c == '.' || c == '/') {
                            whitespace = false;
                        } else if (c != '|') {
                            return XPath.fixupXPath2(xpath, offset, end);
                        }
                    }
                } else if (c == '|') {
                    whitespace = true;
                }
                ++offset;
            }
            return xpath;
        }

        private static String fixupXPath2(String xpath, int offset, int end) {
            StringBuffer buffer = new StringBuffer(end + 2);
            int i = 0;
            while (i < offset) {
                buffer.append(xpath.charAt(i));
                ++i;
            }
            buffer.append("./");
            boolean whitespace = false;
            while (offset < end) {
                char c = xpath.charAt(offset);
                if (whitespace) {
                    if (!XMLChar.isSpace(c)) {
                        if (c == '.' || c == '/') {
                            whitespace = false;
                        } else if (c != '|') {
                            buffer.append("./");
                            whitespace = false;
                        }
                    }
                } else if (c == '|') {
                    whitespace = true;
                }
                buffer.append(c);
                ++offset;
            }
            return buffer.toString();
        }
    }
}

