/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

public class Native2AsciiUtils {
    private static final int MAX_ASCII = 127;

    public static String native2ascii(String line) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c <= '\u007f') {
                sb.append(c);
            } else {
                sb.append("\\u");
                String encoded = Integer.toHexString(c);
                int i = encoded.length();
                while (i < 4) {
                    sb.append("0");
                    ++i;
                }
                sb.append(encoded);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String ascii2native(String line) {
        StringBuilder sb = new StringBuilder();
        int inputLen = line.length();
        int i = 0;
        while (i < inputLen) {
            int unescaped;
            char u;
            char c = line.charAt(i);
            if (c != '\\' || i >= inputLen - 5) {
                sb.append(c);
            } else if ((u = line.charAt(++i)) == 'u' && (unescaped = Native2AsciiUtils.tryParse(line, i + 1)) >= 0) {
                sb.append((char)unescaped);
                i += 4;
            } else {
                sb.append(c).append(u);
            }
            ++i;
        }
        return sb.toString();
    }

    private static int tryParse(String line, int startIdx) {
        try {
            return Integer.parseInt(line.substring(startIdx, startIdx + 4), 16);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }
}

