/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;

public class ContainsSelector
extends BaseExtendSelector
implements ResourceSelector {
    private String contains = null;
    private boolean casesensitive = true;
    private boolean ignorewhitespace = false;
    private String encoding = null;
    public static final String EXPRESSION_KEY = "expression";
    public static final String CONTAINS_KEY = "text";
    public static final String CASE_KEY = "casesensitive";
    public static final String WHITESPACE_KEY = "ignorewhitespace";

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("{containsselector text: ");
        buf.append('\"').append(this.contains).append('\"');
        buf.append(" casesensitive: ");
        buf.append(this.casesensitive ? "true" : "false");
        buf.append(" ignorewhitespace: ");
        buf.append(this.ignorewhitespace ? "true" : "false");
        buf.append("}");
        return buf.toString();
    }

    public void setText(String contains) {
        this.contains = contains;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setCasesensitive(boolean casesensitive) {
        this.casesensitive = casesensitive;
    }

    public void setIgnorewhitespace(boolean ignorewhitespace) {
        this.ignorewhitespace = ignorewhitespace;
    }

    @Override
    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                String paramname = parameters[i].getName();
                if (CONTAINS_KEY.equalsIgnoreCase(paramname)) {
                    this.setText(parameters[i].getValue());
                } else if (CASE_KEY.equalsIgnoreCase(paramname)) {
                    this.setCasesensitive(Project.toBoolean(parameters[i].getValue()));
                } else if (WHITESPACE_KEY.equalsIgnoreCase(paramname)) {
                    this.setIgnorewhitespace(Project.toBoolean(parameters[i].getValue()));
                } else {
                    this.setError("Invalid parameter " + paramname);
                }
                ++i;
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.contains == null) {
            this.setError("The text attribute is required");
        }
    }

    @Override
    public boolean isSelected(File basedir, String filename, File file) {
        return this.isSelected(new FileResource(file));
    }

    @Override
    public boolean isSelected(Resource r) {
        this.validate();
        if (r.isDirectory() || this.contains.length() == 0) {
            return true;
        }
        String userstr = this.contains;
        if (!this.casesensitive) {
            userstr = this.contains.toLowerCase();
        }
        if (this.ignorewhitespace) {
            userstr = SelectorUtils.removeWhitespace(userstr);
        }
        BufferedReader in = null;
        try {
            in = this.encoding != null ? new BufferedReader(new InputStreamReader(r.getInputStream(), this.encoding)) : new BufferedReader(new InputStreamReader(r.getInputStream()));
        }
        catch (Exception e) {
            throw new BuildException("Could not get InputStream from " + r.toLongString(), e);
        }
        try {
            String teststr = in.readLine();
            while (teststr != null) {
                if (!this.casesensitive) {
                    teststr = teststr.toLowerCase();
                }
                if (this.ignorewhitespace) {
                    teststr = SelectorUtils.removeWhitespace(teststr);
                }
                if (teststr.indexOf(userstr) > -1) {
                    return true;
                }
                teststr = in.readLine();
            }
            return false;
        }
        catch (IOException ioe) {
            throw new BuildException("Could not read " + r.toLongString());
        }
        finally {
            FileUtils.close(in);
        }
    }
}

