/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.ErrorHandler;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.StreamTarget;
import org.apache.log.util.DefaultErrorHandler;
import org.apache.log.util.LoggerListener;

public class Hierarchy {
    public static final String DEFAULT_FORMAT = "%7.7{priority} %23.23{time:yyyy-MM-dd' 'HH:mm:ss.SSS} [%8.8{category}] (%{context}): %{message}\n%{throwable}";
    private static final Hierarchy c_hierarchy = new Hierarchy();
    private ErrorHandler m_errorHandler = new DefaultErrorHandler();
    private Logger m_rootLogger = new Logger(new InnerErrorHandler(), new InnerLoggerListener(), "", null, null);
    private LoggerListener m_loggerListener;

    public static Hierarchy getDefaultHierarchy() {
        return c_hierarchy;
    }

    public Hierarchy() {
        PatternFormatter formatter = new PatternFormatter(DEFAULT_FORMAT);
        StreamTarget target = new StreamTarget(System.out, formatter);
        this.setDefaultLogTarget(target);
    }

    public void setDefaultLogTarget(LogTarget target) {
        if (target == null) {
            throw new IllegalArgumentException("Can not set DefaultLogTarget to null");
        }
        LogTarget[] targets = new LogTarget[]{target};
        this.getRootLogger().setLogTargets(targets);
    }

    public void setDefaultLogTargets(LogTarget[] targets) {
        if (targets == null || targets.length == 0) {
            throw new IllegalArgumentException("Can not set DefaultLogTargets to null");
        }
        int i = 0;
        while (i < targets.length) {
            if (targets[i] == null) {
                String message = "Can not set DefaultLogTarget element to null";
                throw new IllegalArgumentException("Can not set DefaultLogTarget element to null");
            }
            ++i;
        }
        this.getRootLogger().setLogTargets(targets);
    }

    public void setDefaultPriority(Priority priority) {
        if (priority == null) {
            String message = "Can not set default Hierarchy Priority to null";
            throw new IllegalArgumentException("Can not set default Hierarchy Priority to null");
        }
        this.getRootLogger().setPriority(priority);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            String message = "Can not set default Hierarchy ErrorHandler to null";
            throw new IllegalArgumentException("Can not set default Hierarchy ErrorHandler to null");
        }
        this.m_errorHandler = errorHandler;
    }

    public synchronized void addLoggerListener(LoggerListener loggerListener) {
        if (loggerListener == null) {
            throw new NullPointerException("loggerListener");
        }
        if (this.m_loggerListener != null) {
            String message = "LoggerListener already set on a unicast event notifier";
            throw new UnsupportedOperationException("LoggerListener already set on a unicast event notifier");
        }
        this.m_loggerListener = loggerListener;
    }

    public synchronized void removeLoggerListener(LoggerListener loggerListener) {
        if (loggerListener == null) {
            throw new NullPointerException("loggerListener");
        }
        if (this.m_loggerListener != null && this.m_loggerListener == loggerListener) {
            this.m_loggerListener = null;
        }
    }

    public Logger getLoggerFor(String category) {
        return this.getRootLogger().getChildLogger(category);
    }

    private synchronized void notifyLoggerCreated(String category, Logger logger) {
        if (this.m_loggerListener != null) {
            this.m_loggerListener.loggerCreated(category, logger);
        }
    }

    public final Logger getRootLogger() {
        return this.m_rootLogger;
    }

    private class InnerErrorHandler
    implements ErrorHandler {
        private InnerErrorHandler() {
        }

        @Override
        public void error(String message, Throwable throwable, LogEvent event) {
            Hierarchy.this.m_errorHandler.error(message, throwable, event);
        }
    }

    private class InnerLoggerListener
    extends LoggerListener {
        private InnerLoggerListener() {
        }

        @Override
        public void loggerCreated(String category, Logger logger) {
            Hierarchy.this.notifyLoggerCreated(category, logger);
        }
    }
}

