/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.mail;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.examples.mail.IMAPUtils;
import org.apache.commons.net.imap.IMAPClient;

public final class IMAPImportMbox {
    private static final String CRLF = "\r\n";
    private static final Pattern PATFROM = Pattern.compile(">+From ");

    private static String getDate(String msg) {
        Pattern FROM_RE = Pattern.compile("From \\S+ +\\S+ (\\S+)  ?(\\S+) (\\S+) (\\S+)");
        String date = null;
        Matcher m = FROM_RE.matcher(msg);
        if (m.lookingAt()) {
            date = String.valueOf(m.group(2)) + "-" + m.group(1) + "-" + m.group(4) + " " + m.group(3) + " +0000";
        }
        return date;
    }

    private static boolean listContains(List<String> contains, String string) {
        for (String entry : contains) {
            if (!string.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IOException {
        Object object;
        if (args.length < 2) {
            System.err.println("Usage: IMAPImportMbox imap[s]://user:password@host[:port]/folder/path <mboxfile> [selectors]");
            System.err.println("\tWhere: a selector is a list of numbers/number ranges - 1,2,3-10 - or a list of strings to match in the initial From line");
            System.exit(1);
        }
        URI uri = URI.create(args[0]);
        String file = args[1];
        File mbox = new File(file);
        if (!mbox.isFile() || !mbox.canRead()) {
            throw new IOException("Cannot read mailbox file: " + mbox);
        }
        String path = uri.getPath();
        if (path == null || path.length() < 1) {
            throw new IllegalArgumentException("Invalid folderPath: '" + path + "'");
        }
        String folder = path.substring(1);
        ArrayList<String> contains = new ArrayList<String>();
        BitSet msgNums = new BitSet();
        int i = 2;
        while (i < args.length) {
            String arg = args[i];
            if (arg.matches("\\d+(-\\d+)?(,\\d+(-\\d+)?)*")) {
                object = arg.split(",");
                int n = ((String[])object).length;
                int n2 = 0;
                while (n2 < n) {
                    String entry = object[n2];
                    String[] parts = entry.split("-");
                    if (parts.length == 2) {
                        int low = Integer.parseInt(parts[0]);
                        int high = Integer.parseInt(parts[1]);
                        int j = low;
                        while (j <= high) {
                            msgNums.set(j);
                            ++j;
                        }
                    } else {
                        msgNums.set(Integer.parseInt(entry));
                    }
                    ++n2;
                }
            } else {
                contains.add(arg);
            }
            ++i;
        }
        IMAPClient imap = IMAPUtils.imapLogin(uri, 10000, null);
        int total = 0;
        int loaded = 0;
        try {
            try {
                imap.setSoTimeout(6000);
                boolean wanted = false;
                StringBuilder sb = new StringBuilder();
                object = null;
                Object var14_20 = null;
                try (BufferedReader br = Files.newBufferedReader(Paths.get(file, new String[0]), Charset.defaultCharset());){
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (line.startsWith("From ")) {
                            if (IMAPImportMbox.process(sb, imap, folder, total)) {
                                ++loaded;
                            }
                            sb.setLength(0);
                            wanted = IMAPImportMbox.wanted(++total, line, msgNums, contains);
                        } else if (IMAPImportMbox.startsWith(line, PATFROM)) {
                            line = line.substring(1);
                        }
                        if (!wanted) continue;
                        sb.append(line);
                        sb.append(CRLF);
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
                if (wanted && IMAPImportMbox.process(sb, imap, folder, total)) {
                    ++loaded;
                }
            }
            catch (IOException e) {
                System.out.println("Error processing msg: " + total + " " + imap.getReplyString());
                e.printStackTrace();
                System.exit(10);
                imap.logout();
                imap.disconnect();
                return;
            }
        }
        finally {
            imap.logout();
            imap.disconnect();
        }
        System.out.println("Processed " + total + " messages, loaded " + loaded);
    }

    private static boolean process(StringBuilder sb, IMAPClient imap, String folder, int msgNum) throws IOException {
        boolean haveMessage;
        int length = sb.length();
        boolean bl = haveMessage = length > 2;
        if (haveMessage) {
            System.out.println("MsgNum: " + msgNum + " Length " + length);
            sb.setLength(length - 2);
            String msg = sb.toString();
            if (!imap.append(folder, null, IMAPImportMbox.getDate(msg), msg)) {
                throw new IOException("Failed to import message: " + msgNum + " " + imap.getReplyString());
            }
        }
        return haveMessage;
    }

    private static boolean startsWith(String input, Pattern pat) {
        Matcher m = pat.matcher(input);
        return m.lookingAt();
    }

    private static boolean wanted(int msgNum, String line, BitSet msgNums, List<String> contains) {
        return msgNums.isEmpty() && contains.isEmpty() || msgNums.get(msgNum) || IMAPImportMbox.listContains(contains, line);
    }
}

