/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.cidr;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.net.util.SubnetUtils;

public class SubnetUtilsExample {
    public static void main(String[] args) {
        String subnet = "192.168.0.3/31";
        SubnetUtils utils = new SubnetUtils("192.168.0.3/31");
        SubnetUtils.SubnetInfo info = utils.getInfo();
        System.out.printf("Subnet Information for %s:%n", "192.168.0.3/31");
        System.out.println("--------------------------------------");
        System.out.printf("IP Address:\t\t\t%s\t[%s]%n", info.getAddress(), Integer.toBinaryString(info.asInteger(info.getAddress())));
        System.out.printf("Netmask:\t\t\t%s\t[%s]%n", info.getNetmask(), Integer.toBinaryString(info.asInteger(info.getNetmask())));
        System.out.printf("CIDR Representation:\t\t%s%n%n", info.getCidrSignature());
        System.out.printf("Supplied IP Address:\t\t%s%n%n", info.getAddress());
        System.out.printf("Network Address:\t\t%s\t[%s]%n", info.getNetworkAddress(), Integer.toBinaryString(info.asInteger(info.getNetworkAddress())));
        System.out.printf("Broadcast Address:\t\t%s\t[%s]%n", info.getBroadcastAddress(), Integer.toBinaryString(info.asInteger(info.getBroadcastAddress())));
        System.out.printf("Low Address:\t\t\t%s\t[%s]%n", info.getLowAddress(), Integer.toBinaryString(info.asInteger(info.getLowAddress())));
        System.out.printf("High Address:\t\t\t%s\t[%s]%n", info.getHighAddress(), Integer.toBinaryString(info.asInteger(info.getHighAddress())));
        System.out.printf("Total usable addresses: \t%d%n", info.getAddressCountLong());
        System.out.printf("Address List: %s%n%n", Arrays.toString(info.getAllAddresses()));
        String prompt = "Enter an IP address (e.g. 192.168.0.10):";
        System.out.println("Enter an IP address (e.g. 192.168.0.10):");
        Throwable throwable = null;
        Object var6_7 = null;
        try (Scanner scanner = new Scanner(System.in, Charset.defaultCharset().name());){
            while (scanner.hasNextLine()) {
                String address = scanner.nextLine();
                System.out.println("The IP address [" + address + "] is " + (info.isInRange(address) ? "" : "not ") + "within the subnet [" + "192.168.0.3/31" + "]");
                System.out.println("Enter an IP address (e.g. 192.168.0.10):");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

