/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;

public class RuntimeEnvironment {
    private static Boolean containsLine(String path, String line) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]));){
                return stream.anyMatch(test -> test.contains(line));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Boolean inContainer() {
        if (!RuntimeEnvironment.inDocker().booleanValue() && !RuntimeEnvironment.inPodman().booleanValue()) {
            return false;
        }
        return true;
    }

    static Boolean inDocker() {
        return RuntimeEnvironment.containsLine("/proc/1/cgroup", "/docker");
    }

    static Boolean inPodman() {
        return RuntimeEnvironment.containsLine("/proc/1/environ", "container=podman");
    }

    static Boolean inWsl() {
        return RuntimeEnvironment.containsLine("/proc/1/environ", "container=wslcontainer_host_id");
    }

    @Deprecated
    public RuntimeEnvironment() {
    }
}

