/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.util.ByteSequence;

public abstract class BranchInstruction
extends Instruction
implements InstructionTargeter {
    @Deprecated
    protected int index;
    @Deprecated
    protected InstructionHandle target;
    @Deprecated
    protected int position;

    BranchInstruction() {
    }

    protected BranchInstruction(short opcode, InstructionHandle target) {
        super(opcode, (short)3);
        this.setTarget(target);
    }

    @Override
    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(super.getOpcode());
        this.index = this.getTargetOffset();
        if (!BranchInstruction.isValidShort(this.index)) {
            throw new ClassGenException("Branch target offset too large for short: " + this.index);
        }
        out.writeShort(this.index);
    }

    protected int getTargetOffset(InstructionHandle _target) {
        if (_target == null) {
            throw new ClassGenException("Target of " + super.toString(true) + " is invalid null handle");
        }
        int t = _target.getPosition();
        if (t < 0) {
            throw new ClassGenException("Invalid branch target position offset for " + super.toString(true) + ":" + t + ":" + _target);
        }
        return t - this.position;
    }

    protected int getTargetOffset() {
        return this.getTargetOffset(this.target);
    }

    protected int updatePosition(int offset, int max_offset) {
        this.position += offset;
        return 0;
    }

    @Override
    public String toString(boolean verbose) {
        String s = super.toString(verbose);
        String t = "null";
        if (verbose) {
            if (this.target != null) {
                t = this.target.getInstruction() == this ? "<points to itself>" : (this.target.getInstruction() == null ? "<null instruction!!!?>" : "" + this.target.getPosition());
            }
        } else if (this.target != null) {
            this.index = this.target.getPosition();
            t = "" + this.index;
        }
        return String.valueOf(s) + " -> " + t;
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.setLength(3);
        this.index = bytes.readShort();
    }

    public final int getIndex() {
        return this.index;
    }

    public InstructionHandle getTarget() {
        return this.target;
    }

    public void setTarget(InstructionHandle target) {
        BranchInstruction.notifyTarget(this.target, target, this);
        this.target = target;
    }

    static void notifyTarget(InstructionHandle old_ih, InstructionHandle new_ih, InstructionTargeter t) {
        if (old_ih != null) {
            old_ih.removeTargeter(t);
        }
        if (new_ih != null) {
            new_ih.addTargeter(t);
        }
    }

    @Override
    public void updateTarget(InstructionHandle old_ih, InstructionHandle new_ih) {
        if (this.target != old_ih) {
            throw new ClassGenException("Not targeting " + old_ih + ", but " + this.target);
        }
        this.setTarget(new_ih);
    }

    @Override
    public boolean containsTarget(InstructionHandle ih) {
        return this.target == ih;
    }

    @Override
    void dispose() {
        this.setTarget(null);
        this.index = -1;
        this.position = -1;
    }

    protected int getPosition() {
        return this.position;
    }

    protected void setPosition(int position) {
        this.position = position;
    }

    protected void setIndex(int index) {
        this.index = index;
    }
}

