/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.web.upload;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcSIUnitUtil;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.script.SrpClosureCompiler;
import jp.co.extreme.web.javascript.WbfNewJsUtil;

public final class WebFileCheckUtil {
    static Map<String, String> scriptMap = new HashMap<String, String>();
    public static long maxSize = 0xA00000L;

    private WebFileCheckUtil() {
    }

    public static String getScript(long maxSize, String maxSizeOverMsg, Collection<String> mimeAllowCollection) throws Exception {
        String fileName = "fileCheck.js";
        String script = scriptMap.get(fileName);
        if (script == null) {
            script = WbfNewJsUtil.getScript(WebFileCheckUtil.class.getResourceAsStream(fileName));
            scriptMap.put(fileName, script);
        }
        String scriptWk = script;
        scriptWk = scriptWk.replace(PlaceHolder.maxSize.value, Long.toString(maxSize));
        scriptWk = scriptWk.replace(PlaceHolder.maxSizeOverMsg.value, maxSizeOverMsg);
        StringBuilder sb = new StringBuilder();
        if (!BcCollectionUtil.isEmpty(mimeAllowCollection)) {
            for (String mime : mimeAllowCollection) {
                if (sb.length() > 0) {
                    sb.append(BcUnicode.comma.char_);
                }
                sb.append(BcStringUtil.singleQuotation(mime));
            }
        }
        scriptWk = scriptWk.replace(PlaceHolder.mimeAllowCollection.value, sb.toString());
        scriptWk = SrpClosureCompiler.getInstance().compile(scriptWk);
        return WbfNewJsUtil.addTag(scriptWk);
    }

    public static String getScript(long maxSize, String maxSizeOverMsg, String ... mimeAllows) throws Exception {
        return WebFileCheckUtil.getScript(maxSize, maxSizeOverMsg, Arrays.asList(mimeAllows));
    }

    public static String checkFile(String inputFileId, String canvasId, String canvasParentId) {
        String str = "checkFile(" + BcStringUtil.singleQuotation(inputFileId) + "," + BcStringUtil.singleQuotation(canvasId) + "," + BcStringUtil.singleQuotation(canvasParentId) + ")";
        return str;
    }

    public static String getMaxMsg(long maxSize) throws Exception {
        return String.format("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u306f\u6700\u5927%S\u3067\u3059\u3002", BcSIUnitUtil.toByteString(maxSize));
    }

    public static enum PlaceHolder {
        maxSize(null),
        maxSizeOverMsg(null),
        mimeAllowCollection(null);

        public final String value;

        private PlaceHolder(String value) {
            this.value = BcStringUtil.isEmpty(value) ? WbfwUtil.toPlaceHolder(this) : value;
        }
    }
}

