/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.web.jquery.progress;

import java.util.HashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.script.SrpClosureCompiler;
import jp.co.extreme.web.javascript.WbfNewJsUtil;

public class JqProgressUtil {
    Map<String, String> scriptMap = new HashMap<String, String>();
    public String progressLabelId = "progressLabel";
    public String progressTagId = "progressTag";
    public String progressMessageId = "progressMessage";
    public String resultDivId = "resultDiv";

    public static JqProgressUtil getInstance() {
        return SingletonHolder.instance;
    }

    public String getScript(String baseUrl) throws Exception {
        String fileName = "jqProgress.js";
        String script = this.scriptMap.get(fileName);
        if (script == null) {
            script = WbfNewJsUtil.getScript(this.getClass().getResourceAsStream(fileName));
            this.scriptMap.put(fileName, script);
        }
        String scriptWk = script;
        scriptWk = scriptWk.replace("${baseUrl}", baseUrl);
        scriptWk = scriptWk.replace("${interval}", "2000");
        scriptWk = scriptWk.replace("${progressMessage}", this.progressMessageId);
        scriptWk = SrpClosureCompiler.getInstance().compile(scriptWk);
        return WbfNewJsUtil.addTag(scriptWk);
    }

    public String createProgressTags(HtmlBuilder htmlBuilder) throws Exception {
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = this.progressLabelId;
        sb.append(htmlBuilder.label_start(globalAttribute, this.progressTagId));
        sb.append(htmlBuilder.label_end());
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = this.progressTagId;
        globalAttribute.style = "width: 100%";
        sb.append(htmlBuilder.progress(globalAttribute, 100.0, 0.0));
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = this.progressMessageId;
        sb.append(htmlBuilder.p(globalAttribute, null, true, true));
        return sb.toString();
    }

    public String createResultDiv(HtmlBuilder htmlBuilder, String content) throws Exception {
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.id = this.resultDivId;
        sb.append(htmlBuilder.div_start(globalAttribute));
        BcStringUtil.append(sb, content);
        sb.append(htmlBuilder.div_end());
        return sb.toString();
    }

    private static final class SingletonHolder {
        private static final JqProgressUtil instance = new JqProgressUtil();

        private SingletonHolder() {
        }
    }
}

