/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.swing.SwgMenuItem;

public class SwgTreeView
extends JTree
implements Serializable {
    private static final long serialVersionUID = 1286293505320985942L;
    protected int mouseX;
    protected int mouseY;
    protected ActionListener2 actionListener = new ActionListener2();
    protected JPopupMenu popupMenu = new JPopupMenu();
    protected SwgMenuItem addMenu;
    protected SwgMenuItem deleteMenu;

    public SwgTreeView() throws Exception {
        this.init();
    }

    public SwgTreeView(Hashtable hashtable) throws Exception {
        super(hashtable);
        this.init();
    }

    public SwgTreeView(Object[] objects) throws Exception {
        super(objects);
        this.init();
    }

    public SwgTreeView(TreeModel treeModel) throws Exception {
        super(treeModel);
        this.init();
    }

    public SwgTreeView(TreeNode rootTreeNode) throws Exception {
        super(rootTreeNode);
        this.init();
    }

    public SwgTreeView(TreeNode rootTreeNode, boolean asksAllowsChildren) throws Exception {
        super(rootTreeNode, asksAllowsChildren);
        this.init();
    }

    public SwgTreeView(Vector vector) throws Exception {
        super(vector);
        this.init();
    }

    protected void init() throws Exception {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent ev) {
            }

            @Override
            public void mouseExited(MouseEvent ev) {
                SwgTreeView.this.mouseEvent(ev);
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                SwgTreeView.this.mouseEvent(ev);
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                SwgTreeView.this.mouseEvent(ev);
            }

            @Override
            public void mouseClicked(MouseEvent ev) {
                SwgTreeView.this.mouseEvent(ev);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent ev) {
                SwgTreeView.this.mouseX = ev.getX();
                SwgTreeView.this.mouseY = ev.getY();
            }
        });
        this.addMenu = new SwgMenuItem(BcWords.getInstance().add, new ImageIcon(AwtImageHelper.getImageAsIcon("add_64x64.png")));
        this.addMenu.addActionListener(this.actionListener);
        this.deleteMenu = new SwgMenuItem(BcWords.getInstance().delete, new ImageIcon(AwtImageHelper.getImageAsIcon("cancel_64x64.png")));
        this.deleteMenu.addActionListener(this.actionListener);
    }

    protected void actionPerformedEvent(ActionEvent ev) {
        if (ev.getSource() != this.addMenu) {
            ev.getSource();
        }
    }

    protected void mouseEvent(MouseEvent ev) {
        if (ev.isPopupTrigger()) {
            this.setPopupMenuAttribute();
            this.popupMenu.show(this, ev.getX(), ev.getY());
            return;
        }
        switch (ev.getID()) {
            case 504: {
                break;
            }
            case 505: {
                break;
            }
            case 503: {
                break;
            }
            case 501: {
                break;
            }
            case 506: {
                break;
            }
            case 502: {
                break;
            }
        }
    }

    protected void setPopupMenuAttribute() {
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TreeCellRenderer cellRenderer = this.getCellRenderer();
        if (cellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)cellRenderer;
            defaultTreeCellRenderer.setBackgroundNonSelectionColor(this.getBackground());
            defaultTreeCellRenderer.setTextNonSelectionColor(this.getForeground());
        }
    }

    public int getPathCountMax() {
        int resvalue = 0;
        int i = 0;
        while (i < this.getRowCount()) {
            TreePath treePath = this.getPathForRow(i);
            if (treePath.getPathCount() > resvalue) {
                resvalue = treePath.getPathCount();
            }
            ++i;
        }
        return resvalue;
    }

    public void expandChilds(TreeNode treeNode, boolean isExpand) {
        TreePath treePath = new TreePath(((DefaultTreeModel)this.getModel()).getPathToRoot(treeNode));
        if (isExpand) {
            this.expandPath(treePath);
            int i = 0;
            while (i < treeNode.getChildCount()) {
                TreeNode treeNode2 = treeNode.getChildAt(i);
                this.expandChilds(treeNode2, isExpand);
                ++i;
            }
        } else {
            this.collapsePath(treePath);
        }
    }

    protected class ActionListener2
    implements ActionListener,
    Serializable {
        protected ActionListener2() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            SwgTreeView.this.actionPerformedEvent(ev);
        }
    }
}

