/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.Calendar;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.swing.SwgMenuItem;
import jp.co.extreme.swing.SwgTextField;
import jp.co.extreme.swing.SwgUtil;

public class SwgTimeField
extends SwgTextField {
    private static final long serialVersionUID = -1907125512797690964L;
    protected String format;
    protected boolean nullable;
    protected Calendar calendar;
    protected SwgMenuItem menu_setNow;
    protected String toolTip;

    public SwgTimeField(String format, boolean nullable) throws Exception {
        this.init();
        this.setFormat(format);
        this.nullable = nullable;
    }

    public SwgTimeField() throws Exception {
        this.setFormat("HH:mm:ss");
        this.nullable = true;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.menu_setNow = new SwgMenuItem();
        this.toolTip = "HH:mm:ss, HHmmss \u306e\u3044\u305a\u308c\u304b\u306e\u5f62\u5f0f\u3067\u5165\u529b\u3057\u3066\u4e0b\u3055\u3044\u3002";
        this.popupMenu.addSeparator();
        this.menu_setNow.addActionListener(this.actionListener);
        this.popupMenu.add(this.menu_setNow);
        this.setToolTipText(this.toolTip);
        this.setImeMode(1);
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) throws Exception {
        this.format = format;
        if (this.calendar != null) {
            this.setCalendar(this.calendar);
        }
        this.setFont(this.getFont());
    }

    @Override
    public void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.menu_setNow) {
            this.setText(BcTimeUtil.toString(BcTimeUtil.createCalendar(), this.getFormat()));
        }
    }

    @Override
    public void setText(String text) {
        if (BcStringUtil.isEmpty(text)) {
            if (this.nullable) {
                this.calendar = null;
                super.setText(null);
            } else {
                if (this.calendar == null) {
                    this.calendar = BcTimeUtil.createCalendar();
                }
                BcTimeUtil.initTimeField(this.calendar);
                BcTimeUtil.setEpochDate(this.calendar);
                super.setText(BcTimeUtil.toString(this.calendar, this.getFormat()));
            }
        } else {
            try {
                this.calendar = BcTimeUtil.toCalendar(text, this.getFormat());
                BcTimeUtil.setEpochDate(this.calendar);
                super.setText(BcTimeUtil.toString(this.calendar, this.getFormat()));
            }
            catch (Exception ex) {
                super.setText("");
            }
        }
    }

    @Override
    public void focusEvent(FocusEvent ev) {
        super.focusEvent(ev);
        switch (ev.getID()) {
            case 1005: {
                if (this.popupFlag) break;
                this.setText(this.getText());
            }
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (!BcStringUtil.isEmpty(this.getFormat())) {
            Dimension dim = SwgUtil.getTextFieldSize(this.getFont(), String.valueOf(this.getFormat()) + "A");
            this.setPreferredSize(dim);
        }
    }

    @Override
    public void setPopupMenuAttribute() {
        this.menu_setNow.setEnabled(this.isEnabled() && this.isEditable());
        super.setPopupMenuAttribute();
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) throws Exception {
        this.setText(BcTimeUtil.toString(calendar, this.getFormat()));
    }

    public void setHHmmss(int HHmmss) throws Exception {
        Calendar calendar = BcTimeUtil.createCalendar();
        BcTimeUtil.setTimeField(calendar, HHmmss);
        this.setCalendar(calendar);
    }
}

