/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import jp.co.extreme.swing.SwgUtil;

public class SwgPanel
extends JPanel
implements ComponentListener,
AutoCloseable {
    private static final long serialVersionUID = 8122782208679637777L;
    protected ActionListener actionListener;
    protected EtchedBorder etchedBorder;
    protected TitledBorder titledBorder;
    protected int shownCount;
    private Object userObject;

    public SwgPanel() {
        this.addComponentListener(this);
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                try {
                    SwgPanel.this.actionPerformed2(ev);
                }
                catch (Exception ex) {
                    SwgPanel.this.handleException(ex);
                }
            }
        };
    }

    @Override
    public void componentResized(ComponentEvent ev) {
    }

    @Override
    public void componentMoved(ComponentEvent ev) {
    }

    @Override
    public void componentShown(ComponentEvent ev) {
        ++this.shownCount;
        if (this.shownCount == 1 && this.getParent() != null) {
            try {
                this.componentShownFirst(ev);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }
    }

    protected void componentShownFirst(ComponentEvent ev) throws Exception {
    }

    @Override
    public final void componentHidden(ComponentEvent ev) {
        try {
            this.componentHidden2(ev);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    public void componentHidden2(ComponentEvent ev) {
    }

    public void setBorderTitle(String title, Font font, Color color) throws Exception {
        if (this.etchedBorder == null) {
            this.etchedBorder = new EtchedBorder();
            this.titledBorder = new TitledBorder(this.etchedBorder);
        }
        if (font != null) {
            this.titledBorder.setTitleFont(font);
        }
        if (color != null) {
            this.titledBorder.setTitleColor(color);
        }
        this.titledBorder.setTitle(title);
        this.setBorder(this.titledBorder);
    }

    public void setBorderTitle(String title, int fontSize) throws Exception {
        Font font = null;
        font = fontSize > 0 ? new Font("Dialog", 0, fontSize) : new Font("Dialog", 0, 10);
        this.setBorderTitle(title, font, null);
    }

    public void setBorderTitle(String title) throws Exception {
        this.setBorderTitle(title, 10);
    }

    protected final void actionPerformed1(ActionEvent ev) {
        try {
            this.actionPerformed2(ev);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    protected void actionPerformed2(ActionEvent ev) throws Exception {
    }

    @Override
    public void close() throws Exception {
        this.shownCount = -1;
        this.actionListener = null;
        this.etchedBorder = null;
        this.titledBorder = null;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }
}

