/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.swing.SwgBorderPanel;
import jp.co.extreme.swing.SwgButton;
import jp.co.extreme.swing.SwgLinePanel;
import jp.co.extreme.swing.SwgScrollPane;
import jp.co.extreme.swing.SwgTextArea;
import jp.co.extreme.swing.SwgUtil;

public class SwgDecoratePanel
extends SwgBorderPanel {
    private static final long serialVersionUID = -2467967100607623766L;
    public SwgTextArea descriptionTextArea;
    JEditorPane editorPane;
    protected SwgScrollPane descriptionScrollPane;
    protected SwgLinePanel linePanel;
    public SwgButton okButton;
    public SwgButton cancelButton;
    public SwgButton previousButton;
    public SwgButton nextButton;
    public static final String text_plain = "text/plain";
    public static final String text_html = "text/html";
    public static final String text_rtf = "text/rtf";

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.okButton) {
            this.okButtonAction();
        }
        if (ev.getSource() == this.cancelButton) {
            this.cancelButtonAction();
        }
        if (ev.getSource() == this.previousButton) {
            this.previousButtonAction();
        }
        if (ev.getSource() == this.nextButton) {
            this.nextButtonAction();
        }
    }

    public void setOkButton(String label) throws Exception {
        this.okButton = SwgUtil.createOkButton(label, null);
        this.okButton.addActionListener(this.actionListener);
        this.southPanel.add(this.okButton);
    }

    protected void okButtonAction() throws Exception {
    }

    public void setCancelButton(String label) throws Exception {
        this.cancelButton = SwgUtil.createCancelButton(label, null);
        this.cancelButton.addActionListener(this.actionListener);
        this.southPanel.add(this.cancelButton);
    }

    protected void cancelButtonAction() throws Exception {
    }

    public void setPreviousButton(String label) throws Exception {
        if (this.previousButton == null) {
            this.previousButton = new SwgButton();
            this.previousButton.addActionListener(this.actionListener);
            this.southPanel.add(this.previousButton);
        }
        if (label != null) {
            this.previousButton.setText(label);
        } else {
            this.previousButton.setText(BcWords.getInstance().previous_arrow);
        }
    }

    protected void previousButtonAction() throws Exception {
    }

    public void setNextButton(String label) throws Exception {
        if (this.nextButton == null) {
            this.nextButton = new SwgButton();
            this.nextButton.addActionListener(this.actionListener);
            this.southPanel.add(this.nextButton);
        }
        if (label != null) {
            this.nextButton.setText(label);
        } else {
            this.nextButton.setText(BcWords.getInstance().next_arrow);
        }
    }

    protected void nextButtonAction() throws Exception {
    }

    public void setDescription(String type, String description, int height) throws Exception {
        this.editorPane = new JEditorPane(type, description);
        this.editorPane.setEditable(false);
        this.descriptionScrollPane = new SwgScrollPane();
        this.descriptionScrollPane.setBorder(new EmptyBorder(new Insets(4, 4, 4, 4)));
        this.descriptionScrollPane.getViewport().add(this.editorPane);
        this.northPanel.removeAll();
        BorderLayout borderLayout = new BorderLayout();
        this.northPanel.setLayout(borderLayout);
        this.northPanel.add((Component)this.descriptionScrollPane, "Center");
        if (height <= 0) {
            height = 64;
        }
        this.northPanel.setPreferredSize(new Dimension(0, height));
        this.northPanel.validate();
    }

    public void setDescription(String msg, int height) throws Exception {
        this.setDescription(text_plain, msg, height);
    }

    public void setDescription(String msg) throws Exception {
        this.setDescription(msg, -1);
    }

    public void setLine() {
        this.linePanel = new SwgLinePanel();
        JPanel centerBasePanel = new JPanel();
        this.add((Component)centerBasePanel, "Center");
        BorderLayout borderLayout2 = new BorderLayout();
        centerBasePanel.setLayout(borderLayout2);
        this.linePanel.setPreferredSize(new Dimension(0, 4));
        centerBasePanel.add((Component)this.linePanel, "South");
        centerBasePanel.add((Component)this.centerPanel, "Center");
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.descriptionTextArea = null;
        this.descriptionScrollPane = null;
    }
}

