/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.sql.SqlConnection;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.context.SqlContext;

public class SqlStatement
extends BcLoggableObject
implements Statement {
    private SqlConnection sqlConn;
    private Statement stmt;
    private SqlContext sqlContext;
    private Long createTime;
    private Long closeTime;
    private Long queryStartTime;
    private String queryOrign;
    private String queryNew;
    private SqlResultSet resultSet;
    private int queryTimeout;
    private long longQueryTime;

    public SqlStatement(SqlConnection sqlConn, Statement stmt, SqlContext sqlContext) {
        this.sqlConn = sqlConn;
        this.stmt = stmt;
        this.sqlContext = sqlContext;
        this.createTime = System.currentTimeMillis();
    }

    @Override
    public void close() throws SQLException {
        this.stmt.close();
        this.closeTime = System.currentTimeMillis();
        this.sqlConn.removeStatement(this);
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.stmt.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.stmt.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stmt.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (this.sqlContext.isSupported(SqlContext.Function.queryTimeout)) {
            return this.stmt.getQueryTimeout();
        }
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int queryTimeout) throws SQLException {
        if (this.sqlContext.isSupported(SqlContext.Function.queryTimeout)) {
            this.stmt.setQueryTimeout(queryTimeout);
        } else {
            this.queryTimeout = queryTimeout;
        }
    }

    @Override
    public void cancel() throws SQLException {
        this.stmt.cancel();
        this.afterProcess();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.stmt.setCursorName(name);
    }

    @Override
    public boolean execute(String sqlOrign) throws SQLException {
        String sqlNew = this.beforeProcess(sqlOrign);
        boolean isResultSet = false;
        try {
            long startTimeMillis = System.currentTimeMillis();
            isResultSet = this.stmt.execute(sqlNew);
            if (isResultSet) {
                ResultSet rs1 = this.stmt.getResultSet();
                SqlResultSet rs2 = this.setResultSet(rs1, this.queryStartTime);
                this.elapsedTimeLog(rs2);
            }
        }
        finally {
            this.afterProcess();
        }
        return isResultSet;
    }

    public boolean execute(CharSequence sqlOrign) throws SQLException {
        return this.execute(sqlOrign.toString());
    }

    @Override
    public SqlResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.stmt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.stmt.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.stmt.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.stmt.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    @Override
    public void addBatch(String query) throws SQLException {
        this.stmt.addBatch(this.convertQuery(query));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.stmt.executeBatch();
    }

    @Override
    public SqlConnection getConnection() throws SQLException {
        return this.sqlConn;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.stmt.getMoreResults(current);
    }

    @Override
    public SqlResultSet getGeneratedKeys() throws SQLException {
        SqlResultSet rs = this.sqlContext.convToSqlResultSet(this.stmt.getGeneratedKeys(), this);
        return rs;
    }

    @Override
    public int executeUpdate(String query, int autoGeneratedKeys) throws SQLException {
        this.beforeProcess(query);
        return this.stmt.executeUpdate(query, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String query, int[] columnIndexes) throws SQLException {
        this.beforeProcess(query);
        return this.stmt.executeUpdate(query, columnIndexes);
    }

    @Override
    public int executeUpdate(String query, String[] columnNames) throws SQLException {
        this.beforeProcess(query);
        return this.stmt.executeUpdate(query, columnNames);
    }

    @Override
    public boolean execute(String query, int autoGeneratedKeys) throws SQLException {
        this.beforeProcess(query);
        return this.stmt.execute(query, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String query, int[] columnIndexes) throws SQLException {
        this.beforeProcess(query);
        return this.stmt.execute(query, columnIndexes);
    }

    @Override
    public boolean execute(String query, String[] columnNames) throws SQLException {
        this.beforeProcess(query);
        return this.stmt.execute(query, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.stmt.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.sqlContext.isSupported(SqlContext.Function.statementIsClosed)) {
            return this.stmt.isClosed();
        }
        return false;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.stmt.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.stmt.setPoolable(poolable);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.stmt.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.stmt.unwrap(iface);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.stmt.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.stmt.isCloseOnCompletion();
    }

    public SqlContext getSqlContext() {
        return this.sqlContext;
    }

    public Statement getStatement() {
        return this.stmt;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getCloseTime() {
        return this.closeTime;
    }

    public Long getQueryStartTime() {
        return this.queryStartTime;
    }

    public void setQueryStartTime(Long queryStartTime) {
        this.queryStartTime = queryStartTime;
    }

    public String getQuery() {
        return this.queryNew;
    }

    public long getLongQueryTime() {
        return this.longQueryTime;
    }

    public void setLongQueryTime(long longQueryTime) {
        this.longQueryTime = longQueryTime;
    }

    protected String beforeProcess(String queryOrign) throws SQLException {
        if (this.queryStartTime != null) {
            throw new SQLException("Statement is processing.");
        }
        this.queryStartTime = System.currentTimeMillis();
        this.queryOrign = queryOrign;
        this.queryNew = this.convertQuery(queryOrign);
        return this.queryNew;
    }

    protected void afterProcess() throws SQLException {
        this.queryStartTime = null;
    }

    @Override
    public SqlResultSet executeQuery(String query) throws SQLException {
        this.beforeProcess(query);
        try {
            long startTimeMillis = System.currentTimeMillis();
            ResultSet rs1 = this.stmt.executeQuery(query);
            SqlResultSet rs2 = this.setResultSet(rs1, startTimeMillis);
            this.elapsedTimeLog(rs2);
            SqlResultSet sqlResultSet = rs2;
            return sqlResultSet;
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            this.afterProcess();
        }
    }

    @Override
    public int executeUpdate(String query) throws SQLException {
        this.beforeProcess(query);
        try {
            int n = this.stmt.executeUpdate(query);
            return n;
        }
        catch (SQLException ex) {
            throw ex;
        }
        finally {
            this.afterProcess();
        }
    }

    private SqlResultSet setResultSet(ResultSet rs1, Long sqlStartTime) throws SQLException {
        SqlResultSet rs2 = this.sqlContext.convToSqlResultSet(rs1, this);
        rs2.startTime = sqlStartTime;
        rs2.endTime = System.currentTimeMillis();
        this.resultSet = rs2;
        return rs2;
    }

    private void elapsedTimeLog(SqlResultSet rs) throws SQLException {
        if (this.longQueryTime <= 0L) {
            return;
        }
        long elapsedTime = rs.endTime - rs.startTime;
        if (elapsedTime >= this.longQueryTime) {
            this.getLogger().info("longQuery:" + BcTimeUtil.toDurationString(elapsedTime) + " query=\n" + this.queryNew);
        }
    }

    protected String convertQuery(String query) throws SQLException {
        return query;
    }
}

