/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf5.server;

import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactory;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.scf.datasource.ScfDatasourceModule;
import jp.co.extreme.scf.server.ScfAbstractServerModule;
import jp.co.extreme.scf5.dao.ScfSchemaVersionDAO;
import jp.co.extreme.scf5.model.ScfSchemaVersion;

public class Scf5ServerModule
extends ScfAbstractServerModule {
    @Override
    public void init() throws Exception {
    }

    @Override
    public void start() throws Exception {
        this.checkSchemaVersion();
    }

    public void checkSchemaVersion() throws Exception {
        this.getLogger().debug("ScfDatasourceModule.schemaVersionOfBoot=" + ScfDatasourceModule.schemaVersionOfBoot);
        if (ScfDatasourceModule.schemaVersionOfBoot <= 0) {
            return;
        }
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactoryMain();
        DtsSession dtsSession = dtsSessionFactory.createSession(this);
        try {
            ScfSchemaVersion schemaVersion;
            int schemaVersionIdOfDB = -1;
            if (ScfDatasourceModule.schemaVersionOfBoot > 0 && (schemaVersion = ScfSchemaVersionDAO.getInstance().getLatest(dtsSession)) != null) {
                schemaVersionIdOfDB = schemaVersion.versionId;
            }
            this.getLogger().debug("schemaVersionIdOfDB=" + schemaVersionIdOfDB);
            if (ScfDatasourceModule.schemaVersionOfBoot != schemaVersionIdOfDB) {
                String msg = "\u30b9\u30ad\u30fc\u30de\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093\u3002 BOOT=" + ScfDatasourceModule.schemaVersionOfBoot + " DB=" + schemaVersionIdOfDB;
                throw new Exception(msg);
            }
        }
        finally {
            if (dtsSession != null) {
                dtsSession.desturuct();
            }
        }
    }
}

