/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.swg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.swing.SwgBorderPanel;
import jp.co.extreme.swing.SwgFrame;
import jp.co.extreme.swing.SwgImagePanel;
import jp.co.extreme.swing.SwgMenu;
import jp.co.extreme.swing.SwgMenuBar;
import jp.co.extreme.swing.SwgMenuItem;
import jp.co.extreme.swing.SwgUtil;

public class HswgImageViewerPanel
extends SwgBorderPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -2414026217643928152L;
    SwgMenuBar menuBar = new SwgMenuBar();
    SwgMenu fileMenu = new SwgMenu("\u30d5\u30a1\u30a4\u30eb(F)");
    SwgMenuItem exitMenuItem = new SwgMenuItem("\u7d42\u4e86");
    SwgMenu viewMenu = new SwgMenu("\u8868\u793a");
    SwgMenuItem fullScreenMenuItem = new SwgMenuItem("Full Screen");
    SwgMenu lookAndFeelMenu;
    SwgMenu helpMenu = new SwgMenu("\u30d8\u30eb\u30d7(H)");
    SwgMenuItem aboutAppMenuItem;
    SwgMenuItem jvmInfoMenuItem;
    protected JScrollPane tableScrollPane;
    protected SwgImagePanel imagePanel;
    protected Window window;

    public HswgImageViewerPanel() throws Exception {
        this.aboutAppMenuItem = new SwgMenuItem(BcWords.getInstance().aboutThisSoftware, new ImageIcon(AwtImageHelper.getImageAsIcon("about_64x64.png")));
        this.jvmInfoMenuItem = new SwgMenuItem(BcWords.getInstance().javaRuntimeEnvironment, new ImageIcon(AwtImageHelper.getImageAsIcon("java_64x64_01.jpg")));
        this.tableScrollPane = new JScrollPane();
        this.imagePanel = new SwgImagePanel();
        this.northPanel.setLayout(new GridLayout(1, 2));
        this.createMenuBar();
        this.northPanel.add(this.menuBar);
        this.tableScrollPane.getViewport().add(this.imagePanel);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.tableScrollPane, "Center");
        this.imagePanel.fitToImage = true;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    protected void createMenuBar() throws Exception {
        this.menuBar.setPreferredSize(new Dimension(10, 24));
        this.menuBar.add(this.fileMenu);
        this.exitMenuItem.addActionListener(this.actionListener);
        this.fileMenu.add(this.exitMenuItem);
    }

    public SwgImagePanel getImagePanel() {
        return this.imagePanel;
    }

    @Override
    protected void actionPerformed2(ActionEvent ev) throws Exception {
        super.actionPerformed2(ev);
        if (ev.getSource() == this.exitMenuItem) {
            this.close();
        }
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.window.dispose();
    }

    public void showAsFrame(Component ownerCompo) throws Exception {
        SwgFrame frame = new SwgFrame();
        this.window = frame;
        frame.getContentPane().add((Component)this, "Center");
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    HswgImageViewerPanel.this.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        frame.setTitle("Image Viewer");
        frame.setIconImage(AwtImageHelper.getWindowIconImage());
        SwgUtil.setCenter(frame, 0.0);
        ((Window)frame).setVisible(true);
    }
}

