/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.swg;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.scf4.swg.HswgExportConditionPanel;
import jp.co.extreme.scf4.swg.HswgExportWizerd;
import jp.co.extreme.swing.SwgDecoratePanel;
import jp.co.extreme.swing.SwgDialog;
import jp.co.extreme.swing.SwgFrame;
import jp.co.extreme.swing.SwgUtil;

public class HswgExportDialog
extends SwgDecoratePanel {
    private static final long serialVersionUID = -3785696547402000062L;
    protected HswgExportWizerd exportWizerd;
    protected HswgExportConditionPanel exportConditionPanel = new HswgExportConditionPanel();
    protected String title;
    protected Window window;

    public HswgExportDialog(HswgExportWizerd exportWizerd) throws Exception {
        this.exportWizerd = exportWizerd;
        this.exportConditionPanel.setExportCondition(exportWizerd.getExportCondition());
        this.exportConditionPanel.filePathField.setText(exportWizerd.destFilePath);
        this.setBorderSize(10, 40, 8, 8);
        this.setLine();
        this.setOkButton(BcWords.getInstance().completion);
        this.setCancelButton(BcWords.getInstance().cancel);
        String explanation = "\u5404\u7a2e\u9805\u76ee\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002\u300c\u5b8c\u4e86\u300d\u30dc\u30bf\u30f3\u62bc\u4e0b\u306b\u3088\u308a\u51fa\u529b\u3092\u958b\u59cb\u3057\u307e\u3059\u3002";
        this.setDescription(explanation, -1);
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.exportConditionPanel, "Center");
        this.setTitle(BcWords.getInstance().export);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    protected void okButtonAction() throws Exception {
        this.exportWizerd.setExportCondition(this.exportConditionPanel.getExportCondition());
        this.exportWizerd.destFilePath = this.exportConditionPanel.filePathField.getText();
        this.close();
        this.exportWizerd.doExport1();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        super.cancelButtonAction();
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public void showAsDialog(Component ownerCompo) throws Exception {
        SwgDialog dialog = SwgUtil.createDialog(ownerCompo);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    HswgExportDialog.this.cancelButtonAction();
                }
                catch (Exception ex) {
                    HswgExportDialog.this.handleException(ex);
                }
            }
        });
        dialog.setTitle(this.title);
        dialog.setIconImage(AwtImageHelper.getImageAsIcon("export_64x64.png"));
        this.window = dialog;
        SwgUtil.setCenter(this.window, 980.0, 460.0);
        this.window.setVisible(true);
    }

    public void showAsFrame() throws Exception {
        SwgFrame frame = new SwgFrame();
        frame.getContentPane().add((Component)this, "Center");
        frame.setResizable(false);
        frame.setDefaultCloseOperation(0);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                HswgExportDialog.this.actionPerformed1(new ActionEvent(HswgExportDialog.this.cancelButton, 1001, null));
            }
        });
        frame.setTitle(this.title);
        frame.setIconImage(AwtImageHelper.getImageAsIcon("export_64x64.png"));
        this.window = frame;
        SwgUtil.setCenter(this.window, 920.0, 460.0);
        this.window.setVisible(true);
        this.window.toFront();
    }
}

