/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.dao;

import java.util.List;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.orm.dao.OrmAbstractDAO;
import jp.co.extreme.scf4.model.ScfEvent;
import jp.co.extreme.sql.SqlUtil;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.sql.model.SqlSelectQuery;
import jp.co.extreme.sql.model.SqlWhereElement;

public class ScfEventDAO
extends OrmAbstractDAO<ScfEvent> {
    public static final int MODE_default = 1;

    private ScfEventDAO() {
        super(new ScfEvent[0]);
        this.setTableName("fwk1_event");
    }

    public static ScfEventDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectQuery createSelectQuery(SqlContext sqlContext, int mode, String alias, long eventId) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectQuery selectQuery = new SqlSelectQuery();
        if (eventId > 0L) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id = " + eventId);
            selectQuery.addWhereElement(whereElement);
        }
        if (mode == 1) {
            selectQuery.setFromClause(SqlUtil.createTableName(this.getTableName(), alias));
            selectQuery.getOrderByList().add(String.valueOf(aliasWk) + "id");
        }
        return selectQuery;
    }

    public List<ScfEvent> getList(DtsSession dtsSession, int mode, long eventId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "ev";
        SqlSelectQuery selectQuery = this.createSelectQuery(sqlContext, mode, alias, eventId);
        selectQuery.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String sql = sqlContext.buildSelectQuery(selectQuery);
        return this.getEntityList(dtsSession, sql);
    }

    public ScfEvent getById(DtsSession dtsSession, long eventId) throws Exception {
        List<ScfEvent> entityList = this.getList(dtsSession, 1, eventId);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ ScfEventDAO(ScfEventDAO scfEventDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final ScfEventDAO instance = new ScfEventDAO(null);

        private SingletonHolder() {
        }
    }
}

