/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf4.client;

import java.util.List;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.rmi.model.RmiRespons;
import jp.co.extreme.scf.stub.ScfHandleStub;
import jp.co.extreme.scf3.client.ScfTableLoadTask;
import jp.co.extreme.scf3.stub.ScfDatabaseStub;
import jp.co.extreme.scf4.client.ScfOnlineTableModel;

public class ScfTableLoadOnlineTask
extends ScfTableLoadTask {
    private ScfOnlineTableModel onlineTableModel;
    private List<Integer> rowNumberList;

    public ScfOnlineTableModel getOnlineTableModel() {
        return this.onlineTableModel;
    }

    public void setOnlineTableModel(ScfOnlineTableModel onlineTableModel) {
        this.onlineTableModel = onlineTableModel;
    }

    public List<Integer> getRowNumberList() {
        return this.rowNumberList;
    }

    @Override
    public Object taskProcess() throws Exception {
        this.statusId = ScfTableLoadTask.Status.running.id;
        if (this.handleRes == null) {
            this.tableLoadStarted(this);
            RmiRespons rmiRes = this.getLocalAgent().invoke(this.rmiReq1);
            this.setHandleRespons1(rmiRes);
        }
        try {
            while (!this.eod) {
                if (this.statusId != ScfTableLoadTask.Status.running.id) {
                    break;
                }
                this.loadRows();
            }
        }
        finally {
            try {
                ScfHandleStub.getInstance().removeHandle(this.getLocalAgent(), this.handleId);
            }
            finally {
                this.statusId = ScfTableLoadTask.Status.idling.id;
            }
        }
        this.tableLoadFinished(this, this.eod);
        return this.loadedRowSize;
    }

    @Override
    protected void loadRows() throws Exception {
        this.rowNumberList = this.onlineTableModel.getEmptyRowNumberList(this.requireRowCount);
        if (BcCollectionUtil.isEmpty(this.rowNumberList)) {
            this.eod = true;
            return;
        }
        String rowNumbers = BcStringUtil.toCsv(this.rowNumberList).toString();
        List<List> rowList = ScfDatabaseStub.getInstance().getRowByRowNumbers(this.getLocalAgent(), this.handleId, rowNumbers);
        this.rowListReceived(this, rowList);
    }
}

