/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.scf2.rmo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcObjectNotFoundException;
import jp.co.extreme.base.util.BcWarningException;
import jp.co.extreme.rmi.model.RmiRmoArgument;
import jp.co.extreme.rmi.rmo.RmiAbstractRMO;
import jp.co.extreme.scf.server.ScfServerContainer;
import jp.co.extreme.scf2.server.ScfFileHandle;

public class ScfFileRMO
extends RmiAbstractRMO {
    public static final String METHOD_getDownloadHandle = "getDownloadHandle";
    public static final String METHOD_getDownloadHandle2 = "getDownloadHandle2";
    public static final String METHOD_getBinary = "getBinary";
    public static final String METHOD_getUploadHandle = "getUploadHandle";
    public static final String METHOD_uploadBinary = "uploadBinary";
    public static final String METHOD_getTemporaryDirPath = "getTemporaryDirPath";
    public static final String METHOD_saveFile = "saveFile";

    public ScfFileRMO() {
        this.objectPoolEnabled = true;
    }

    public void getDownloadHandle(RmiRmoArgument rmoArg) throws Exception {
        String svFilePath = rmoArg.getRequest().getDataAsString();
        BcLogUtil.info("svFilePath=" + svFilePath);
        long chunkSize = rmoArg.getRequest().getDataAsNumber().longValue();
        BcLogUtil.info("chunkSize=" + chunkSize);
        ScfFileHandle fileHandle = new ScfFileHandle(rmoArg.getAgent().getContext());
        String filePath = AfbApplication.getInstance().toReal(svFilePath);
        fileHandle.file = new File(filePath);
        fileHandle.chunkSize = chunkSize;
        if (!fileHandle.file.exists()) {
            throw new BcObjectNotFoundException();
        }
        fileHandle.is = new BufferedInputStream(new FileInputStream(fileHandle.file));
        try {
            fileHandle.size = fileHandle.file.length();
            ScfServerContainer.getInstance().getHandleManager().addHandle(fileHandle);
            rmoArg.getRespons().addData(fileHandle.getHandleId());
            rmoArg.getRespons().addData(fileHandle.size);
        }
        catch (Exception ex) {
            fileHandle.is.close();
            throw ex;
        }
    }

    public void getDownloadHandle2(RmiRmoArgument rmoArg) throws Exception {
        ScfFileHandle fileHandle = new ScfFileHandle(rmoArg.getAgent().getContext());
        String svFilePath = rmoArg.getRequest().getDataAsString();
        fileHandle.offset = rmoArg.getRequest().getDataAsNumber().longValue();
        String filePath = AfbApplication.getInstance().toReal(svFilePath);
        filePath = BcStringUtil.replace((CharSequence)filePath, "\\", "/").toString();
        BcLogUtil.info("ScfFileRMO.getDownloadHandle2:filePath=" + filePath);
        fileHandle.file = new File(filePath);
        if (!fileHandle.file.exists()) {
            throw new BcObjectNotFoundException();
        }
        fileHandle.is = new BufferedInputStream(new FileInputStream(fileHandle.file));
        if (fileHandle.offset > 0L) {
            BcStreamUtil.skip(fileHandle.is, fileHandle.offset);
        }
        try {
            fileHandle.size = fileHandle.file.length();
            ScfServerContainer.getInstance().getHandleManager().addHandle(fileHandle);
            rmoArg.getRespons().addData(fileHandle.getHandleId());
            rmoArg.getRespons().addData(fileHandle.size);
        }
        catch (Exception ex) {
            fileHandle.is.close();
            throw ex;
        }
    }

    public void getBinary(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        long size = rmoArg.getRequest().getDataAsNumber().longValue();
        ScfFileHandle fileHandle = (ScfFileHandle)ScfServerContainer.getInstance().getHandleManager().getHandle(handleId);
        if (fileHandle.eod) {
            rmoArg.getRespons().addData(null);
            return;
        }
        byte[] bytes = null;
        bytes = size > 0L ? new byte[(int)size] : new byte[32768];
        long readCnt = BcStreamUtil.read(fileHandle.is, bytes);
        if (readCnt > 0L) {
            fileHandle.count = (int)((long)fileHandle.count + readCnt);
            rmoArg.getRespons().addData(readCnt);
            rmoArg.getRespons().addData(bytes);
        } else {
            try {
                fileHandle.is.close();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            fileHandle.eod = true;
            ScfServerContainer.getInstance().getHandleManager().removeHandle(handleId);
            rmoArg.getRespons().addData(-1L);
            rmoArg.getRespons().addData(null);
        }
    }

    public void getUploadHandle(RmiRmoArgument rmoArg) throws Exception {
        String dirPath = rmoArg.getRequest().getDataAsString();
        String fileName = rmoArg.getRequest().getDataAsString();
        long lastModified = (Long)rmoArg.getRequest().getData();
        long length = (Long)rmoArg.getRequest().getData();
        BcLogUtil.debug("fileName=" + fileName);
        dirPath = AfbApplication.getInstance().toReal(dirPath);
        File dir = new File(dirPath);
        if (dir.exists()) {
            if (dir.isFile()) {
                throw new BcWarningException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea " + dirPath + " \u306f\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u5b58\u5728\u3057\u307e\u3059\u3002");
            }
        } else {
            dir.mkdirs();
        }
        ScfFileHandle fileHandle = new ScfFileHandle(rmoArg.getAgent().getContext());
        fileHandle.file = new File(String.valueOf(dir.getPath()) + "/" + fileName);
        BcLogUtil.debug("fileHandle.file=" + fileHandle.file.getPath());
        fileHandle.lastModified = lastModified;
        fileHandle.os = new BufferedOutputStream(new FileOutputStream(fileHandle.file));
        try {
            ScfServerContainer.getInstance().getHandleManager().addHandle(fileHandle);
            rmoArg.getRespons().putData((Object)"hId", fileHandle.getHandleId());
        }
        catch (Exception ex) {
            fileHandle.os.close();
            throw ex;
        }
    }

    public void uploadBinary(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        ScfFileHandle handle = (ScfFileHandle)ScfServerContainer.getInstance().getHandleManager().getHandle(handleId);
        byte[] bytes = rmoArg.getRequest().getDataAsByteArray();
        handle.os.write(bytes);
    }

    public void getTemporaryDirPath(RmiRmoArgument rmoArg) throws Exception {
        File tmpDir = AfbApplication.getInstance().getTempDir();
        rmoArg.getRespons().addData(tmpDir.getPath());
    }

    public void saveFile(RmiRmoArgument rmoArg) throws Exception {
        String filePath = AfbApplication.getInstance().toReal(rmoArg.getRequest().getDataAsString());
        File file = new File(filePath);
        byte[] bytes = (byte[])rmoArg.getRequest().getData();
        try (FileOutputStream os = new FileOutputStream(file);){
            os.write(bytes);
        }
    }
}

