/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.person.common;

import java.io.Serializable;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.util.BcISO;
import jp.co.extreme.base.util.BcLocaleUtil;
import jp.co.extreme.etc.util.EtcWordPack;
import jp.co.extreme.person.common.PsnPersonConstants;

public final class PsnPersonWords
implements Serializable {
    private static final long serialVersionUID = 6103426069307341645L;
    private static final PsnPersonWords en = new PsnPersonWords();
    private static PsnPersonWords ja;
    public EtcWordPack age = new EtcWordPack("Age");
    public EtcWordPack birthday = new EtcWordPack("Birthday");
    public String female = "Female";
    public EtcWordPack fullName = new EtcWordPack("Full", "Name");
    public EtcWordPack fullNameKana = new EtcWordPack("Full Name", "Kana");
    public EtcWordPack fullNameRoman = new EtcWordPack("Full Name", "Roman");
    public String maidenName = "Maiden Name";
    public String male = "Male";
    public EtcWordPack sex = new EtcWordPack("Sex");

    private PsnPersonWords() {
    }

    public static PsnPersonWords getInstance(String langageCode) {
        PsnPersonWords words = en;
        if (BcISO.ISO_639.Japanese.code.equalsIgnoreCase(langageCode)) {
            if (ja == null) {
                ja = new PsnPersonWords();
                ja.setJapanese();
            }
            words = ja;
        }
        return words;
    }

    public static PsnPersonWords getInstance() {
        return PsnPersonWords.getInstance(BcLocaleUtil.getIso639().code);
    }

    public void setJapanese() {
        this.age.setData("\u5e74\u9f62");
        this.birthday.setData("\u751f\u5e74\u6708\u65e5");
        this.female = "\u5973";
        this.fullName.setData("\u6c0f\u540d");
        this.fullNameKana.setData("\u6c0f\u540d\u30ab\u30ca");
        this.fullNameRoman.setData("\u6c0f\u540d", "\u30ed\u30fc\u30de\u8aad");
        this.maidenName = "\u65e7\u59d3";
        this.male = "\u7537";
        this.sex.setData("\u6027", "\u5225");
    }

    public String toSexNameByCode(String sexCode) {
        if (BcStringUtil.equals(sexCode, PsnPersonConstants.Sex.male.code)) {
            return PsnPersonWords.getInstance().male;
        }
        if (BcStringUtil.equals(sexCode, PsnPersonConstants.Sex.female.code)) {
            return this.female;
        }
        if (BcStringUtil.isEmpty(sexCode)) {
            return "";
        }
        return "?";
    }
}

