/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.runtime.BcRuntimeUtil;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.nlp.NlpElement;
import jp.co.extreme.nlp.NlpNoun;
import jp.co.extreme.nlp.NlpToken;
import jp.co.extreme.nlp.NlpTokenWrap;
import jp.co.extreme.nlp.NlpWord;

public final class NlpUtil {
    private NlpUtil() {
    }

    public static List<NlpToken> toTokenList(List<NlpTokenWrap> tokenWrapList, boolean spaseExclusion) throws Exception {
        ArrayList<NlpToken> tokenList = new ArrayList<NlpToken>();
        int i = 0;
        while (i < tokenWrapList.size()) {
            NlpTokenWrap tokenWrap = tokenWrapList.get(i);
            if (spaseExclusion) {
                if (!tokenWrap.token.surface.equals(" ")) {
                    tokenList.add(tokenWrap.token);
                }
            } else {
                tokenList.add(tokenWrap.token);
            }
            ++i;
        }
        return tokenList;
    }

    public static String toString(List<NlpToken> tokenList, boolean spase) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tokenList.size()) {
            NlpToken token = tokenList.get(i);
            if (i > 0 && spase) {
                sb.append(BcUnicode.space.char_);
            }
            sb.append(token.surface);
            ++i;
        }
        return sb.toString();
    }

    public static String toStringForJA(List<NlpTokenWrap> tokenWrapList) throws Exception {
        List<NlpToken> tokenList = NlpUtil.toTokenList(tokenWrapList, false);
        return NlpUtil.toString(tokenList, false);
    }

    public static String toStringForEN(List<NlpTokenWrap> tokenWrapList) throws Exception {
        List<NlpToken> tokenList = NlpUtil.toTokenList(tokenWrapList, true);
        String str = NlpUtil.toString(tokenList, true);
        str = str.replace(".", "");
        return str.toLowerCase();
    }

    public static NlpElement createElement(NlpWord word, List<NlpTokenWrap> tokenWrapList) throws Exception {
        NlpElement mlpElement = new NlpElement();
        mlpElement.word = word;
        mlpElement.tokenWrapList = tokenWrapList;
        return mlpElement;
    }

    public static List<NlpElement> organize(List<NlpElement> elementList1) throws Exception {
        LinkedHashMap<Integer, NlpElement> indexMap = new LinkedHashMap<Integer, NlpElement>();
        int i = 0;
        while (i < elementList1.size()) {
            NlpElement nlpElement1 = elementList1.get(i);
            NlpTokenWrap tokenWrap = nlpElement1.tokenWrapList.get(0);
            NlpElement nlpElement2 = (NlpElement)indexMap.get(tokenWrap.token.beginIndex);
            if (nlpElement2 == null) {
                indexMap.put(tokenWrap.token.beginIndex, nlpElement1);
            }
            ++i;
        }
        ArrayList<NlpElement> elementList2 = new ArrayList<NlpElement>();
        for (Map.Entry mapEntry : indexMap.entrySet()) {
            elementList2.add((NlpElement)mapEntry.getValue());
        }
        return elementList2;
    }

    public static NlpElement compare(NlpElement nlpElement1, NlpElement nlpElement2) throws Exception {
        if (NlpUtil.score(nlpElement1.word) >= NlpUtil.score(nlpElement2.word)) {
            return nlpElement1;
        }
        return nlpElement2;
    }

    public static int score(NlpWord word) throws Exception {
        int score = 0;
        if (!BcStringUtil.isEmpty(word.text)) {
            ++score;
        }
        if (!BcStringUtil.isEmpty(word.reading)) {
            ++score;
        }
        return score += word.score;
    }

    public static NlpNoun toNown(NlpElement element, boolean isEN) throws Exception {
        NlpNoun noun = new NlpNoun();
        noun.text = isEN ? NlpUtil.toCamelCase(element.word.key) : element.word.key;
        noun.reading = element.word.reading;
        noun.tokenList = NlpUtil.toTokenList(element.tokenWrapList, false);
        NlpToken token1 = BcCollectionUtil.getFirst(noun.tokenList);
        NlpToken token2 = BcCollectionUtil.getLast(noun.tokenList);
        noun.beginIndex = token1.beginIndex;
        noun.endIndex = token2.beginIndex + token2.surface.length();
        return noun;
    }

    public static List<NlpNoun> toNownList(List<NlpElement> elementList, boolean isEN) throws Exception {
        ArrayList<NlpNoun> nounList = new ArrayList<NlpNoun>();
        for (NlpElement element : elementList) {
            NlpNoun noun = NlpUtil.toNown(element, isEN);
            nounList.add(noun);
        }
        return nounList;
    }

    public static String toCamelCase(String src) {
        StringBuilder sb = new StringBuilder(src.length());
        int pos = -1;
        char preChar = '\u0000';
        while (++pos < src.length()) {
            char aChar = src.charAt(pos);
            if (!BcStringUtil.isAlphabet(preChar)) {
                sb.append(Character.toUpperCase(aChar));
            } else {
                sb.append(Character.toLowerCase(aChar));
            }
            preChar = aChar;
        }
        return sb.toString();
    }

    public static String createInfo(NlpToken token) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("beginIndex=" + token.beginIndex);
        sb.append(" surface=" + token.surface);
        sb.append(" reading:=" + token.reading);
        sb.append(" partOfSpeechLevel=" + token.posLevel1 + "-" + token.posLevel2 + "-" + token.posLevel3 + "-" + token.posLevel4);
        sb.append(" isKnown=" + token.isKnown);
        sb.append(" user=" + token.isUser);
        return sb.toString();
    }

    public static String createInfo(List<NlpToken> tokenList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tokenList.size()) {
            NlpToken token = tokenList.get(i);
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(NlpUtil.createInfo(token));
            ++i;
        }
        return sb.toString();
    }

    public static String createInfo2(List<NlpTokenWrap> tokenWrapList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tokenWrapList.size()) {
            NlpTokenWrap tokenWrap = tokenWrapList.get(i);
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(NlpUtil.createInfo(tokenWrap.token));
            ++i;
        }
        return sb.toString();
    }

    public static void dispResult(Collection<NlpNoun> nounCollection, String src) {
        BcLogger logger = BcLogUtil.getDefaultLogger();
        logger.debug("nounCollection.size()=" + nounCollection.size());
        for (NlpNoun noun : nounCollection) {
            logger.info(NlpUtil.dispResult(noun, src));
        }
    }

    public static String dispResult(NlpNoun noun, String src) {
        String substring = src.substring(noun.beginIndex, noun.endIndex);
        return "name=" + noun.text + " reading=" + noun.reading + " index=" + noun.beginIndex + "-" + noun.endIndex;
    }

    public static String dispTokenWrapList(List<NlpTokenWrap> tokenWrapList) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < tokenWrapList.size()) {
            NlpTokenWrap nlpTokenWrap = tokenWrapList.get(i);
            NlpToken nlpToken = nlpTokenWrap.token;
            if (i > 0) {
                sb.append(BcRuntimeUtil.lineSeparator);
            }
            sb.append(nlpToken.surface);
            sb.append(" : ");
            sb.append(nlpToken.posLevel1);
            ++i;
        }
        return sb.toString();
    }

    public static StringBuilder temp(Collection<File> fileCollection) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (File file : fileCollection) {
            FileInputStream fis = new FileInputStream(file);
            String str = BcStreamUtil.readAsString((InputStream)fis, BcConstants.charset);
            sb.append(str);
        }
        return sb;
    }

    public static String removeSpace(String src) {
        return src.replaceAll("\\s", "");
    }

    public static enum EnglishPartOfSpeech {
        NN,
        NNS,
        NNP,
        VBZ,
        VBG;

    }
}

