/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.base.table.BcCsvToTable;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.nlp.NlpWord;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.Span;

public class NlpLocationFinderEN
extends BcLoggableObject {
    protected TokenizerModel tokenizerModel;
    protected Tokenizer tokenizer;
    protected TokenNameFinderModel tokenNameFinderModel;
    protected NameFinderME nameFinder;
    protected Map<String, NlpWord> nounMap;

    public void init() throws Exception {
        InputStream is = this.getClass().getResourceAsStream("en-token-1.5.bin");
        this.tokenizerModel = new TokenizerModel(is);
        this.tokenizer = new TokenizerME(this.tokenizerModel);
        is = this.getClass().getResourceAsStream("en-ner-location.bin");
        this.tokenNameFinderModel = new TokenNameFinderModel(is);
        this.nameFinder = new NameFinderME(this.tokenNameFinderModel);
    }

    protected void init(InputStream is) throws Exception {
        InputStreamReader inputStreamReader = new InputStreamReader(is, BcConstants.charset);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        BcTableModel tableModel = BcCsvToTable.getInstance().csvToTable(inputStreamReader, -1);
        this.nounMap = new LinkedHashMap<String, NlpWord>();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            NlpWord noun = new NlpWord();
            noun.key = (String)tableModel.getValueAt(i, 0);
            noun.text = (String)tableModel.getValueAt(i, 1);
            noun.reading = (String)tableModel.getValueAt(i, 2);
            noun.score = 2;
            this.nounMap.put(noun.key, noun);
            ++i;
        }
        this.getLogger().debug("NlpPersonNameFinderEN:nounMap.size()=" + this.nounMap.size());
    }

    public void find(String src) throws Exception {
        String[] tokens = this.tokenizer.tokenize(src);
        Span[] nameSpans = this.nameFinder.find(tokens);
        int i = 0;
        while (i < nameSpans.length) {
            String name = tokens[i];
            this.getLogger().debug("personName.getName()=" + name);
            ++i;
        }
    }
}

