/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.nlp;

import com.atilika.kuromoji.TokenizerBase;
import com.atilika.kuromoji.ipadic.Tokenizer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.nlp.NlpNounFinderEN;
import jp.co.extreme.nlp.NlpNounFinderJA;
import jp.co.extreme.nlp.NlpPersonNameFinder1;
import jp.co.extreme.nlp.NlpPersonNameFinder2;
import jp.co.extreme.nlp.NlpPersonNameFinderEN1;
import jp.co.extreme.nlp.NlpPersonNameFinderEN2;
import jp.co.extreme.nlp.NlpPersonNameUtil;
import jp.co.extreme.nlp.NlpPrefectureFinder;
import jp.co.extreme.nlp.NlpWord;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;

public class NlpFinderBuilder {
    private static Map<String, NlpWord> famousPersonNounMap;

    private NlpFinderBuilder() {
    }

    public static NlpNounFinderJA build_jp(InputStream userDicIs) throws Exception {
        InputStream is = NlpFinderBuilder.class.getResourceAsStream(NlpPersonNameUtil.person_name_ja_dat);
        ByteArrayInputStream bais = NlpPersonNameUtil.decode(is);
        StringBuilder sb = new StringBuilder();
        sb.append(BcStreamUtil.readAsString((InputStream)bais, BcConstants.charset));
        if (userDicIs != null) {
            String str = BcStreamUtil.readAsString(userDicIs, BcConstants.charset);
            sb.append(str);
        }
        ByteArrayInputStream bais2 = new ByteArrayInputStream(sb.toString().getBytes(BcConstants.charset));
        Tokenizer.Builder tokenizerBuilder = new Tokenizer.Builder().mode(TokenizerBase.Mode.NORMAL);
        tokenizerBuilder.userDictionary((InputStream)bais2);
        Tokenizer tokenizer = tokenizerBuilder.build();
        NlpNounFinderJA nounFinder = new NlpNounFinderJA();
        nounFinder.setTokenizer(tokenizer);
        NlpPersonNameFinder1 personNameFinder1 = NlpFinderBuilder.createPersonNameFinder1();
        if (userDicIs != null) {
            Map<String, NlpWord> wordMap = NlpPersonNameUtil.createNounMap(userDicIs, false);
            BcLogUtil.debug("User dictionary(JA):wordMap.size()=" + wordMap.size());
            personNameFinder1.addWordMap(wordMap);
        }
        nounFinder.addModule(personNameFinder1);
        NlpPersonNameFinder2 personNameFinder2 = new NlpPersonNameFinder2();
        personNameFinder2.famousPersonNounMap = famousPersonNounMap;
        nounFinder.addModule(personNameFinder2);
        nounFinder.addModule(new NlpPrefectureFinder());
        is = NlpFinderBuilder.class.getResourceAsStream("rondhuit-ja-ner-1.0.0.bin");
        TokenNameFinderModel tokenNameFinderModel = new TokenNameFinderModel(is);
        nounFinder.tokenNameFinderList.add((TokenNameFinder)new NameFinderME(tokenNameFinderModel));
        return nounFinder;
    }

    protected static NlpPersonNameFinder1 createPersonNameFinder1() throws Exception {
        NlpPersonNameFinder1 personNameFinder1 = new NlpPersonNameFinder1();
        Throwable throwable = null;
        Object var2_4 = null;
        try (InputStream is = NlpFinderBuilder.class.getResourceAsStream(NlpPersonNameUtil.person_name_ja_dat);){
            ByteArrayInputStream bais = NlpPersonNameUtil.decode(is);
            famousPersonNounMap = NlpPersonNameUtil.createNounMap(bais, false);
            BcLogUtil.debug("famousPersonNounMap.size()=" + famousPersonNounMap.size());
            personNameFinder1.addWordMap(famousPersonNounMap);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return personNameFinder1;
    }

    public static NlpNounFinderEN build_en(InputStream userDicIs) throws Exception {
        NlpPersonNameFinderEN1 personNameFinderEN1;
        NlpNounFinderEN nounFinder = new NlpNounFinderEN();
        InputStream is = NlpFinderBuilder.class.getResourceAsStream("en-token-1.5.bin");
        TokenizerModel tokenizerModel = new TokenizerModel(is);
        TokenizerME tokenizer = new TokenizerME(tokenizerModel);
        nounFinder.setTokenizer(tokenizer);
        nounFinder.personNameFinderEN1 = personNameFinderEN1 = new NlpPersonNameFinderEN1();
        is = NlpFinderBuilder.class.getResourceAsStream(NlpPersonNameUtil.person_name_en_dat);
        ByteArrayInputStream bais = NlpPersonNameUtil.decode(is);
        Map<String, NlpWord> wordMap = NlpPersonNameUtil.createNounMap(bais, true);
        NlpPersonNameFinderEN2 personNameFinderEN2 = new NlpPersonNameFinderEN2();
        personNameFinderEN2.addWordMap(wordMap);
        if (userDicIs != null) {
            wordMap = NlpPersonNameUtil.createNounMap(userDicIs, false);
            BcLogUtil.debug("User dictionary(EN):wordMap.size()=" + wordMap.size());
            personNameFinderEN2.addWordMap(wordMap);
        }
        nounFinder.personNameFinderEN2 = personNameFinderEN2;
        return nounFinder;
    }
}

