/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.base.core.BcConstants;
import jp.co.extreme.base.core.BcLangUtil;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.io.BcStreamUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.log.BcLogger;
import jp.co.extreme.base.mmd.MmdField;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.util.BcCollectionUtil;
import jp.co.extreme.base.util.BcRandamUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.css.common.CssBuiler;
import jp.co.extreme.datasource.DtsSession;
import jp.co.extreme.datasource.DtsSessionFactoryManegaer;
import jp.co.extreme.datasource.util.DtsWordManager;
import jp.co.extreme.datasource.util.EtcRsmdSupplement;
import jp.co.extreme.datasource.util.ScfMmdServerUtil;
import jp.co.extreme.etc.util.EtcEnumStrUtil;
import jp.co.extreme.etc.util.EtcPagination;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.html.common.HtmlConstants;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.html.util.HtmlUtil;
import jp.co.extreme.http.HttpConstants;
import jp.co.extreme.http.HttpUtil;
import jp.co.extreme.lib.editorjs.JsonNodeVisitorForEditorJs;
import jp.co.extreme.lib.html.mdc.MdcConstants;
import jp.co.extreme.lib.html.mdl.MdlConstants;
import jp.co.extreme.lib.html.mdl.MdlCreator;
import jp.co.extreme.mail.BcMailUtil;
import jp.co.extreme.module.cmsv.model.CmsvMessage;
import jp.co.extreme.module.mmdx.common.MmdxUtil;
import jp.co.extreme.module.wbfw.common.WbSessionTimeoutException;
import jp.co.extreme.module.wbfw.common.WbfSiteContext;
import jp.co.extreme.module.wbfw.common.WbfwConstants;
import jp.co.extreme.module.wbfw.common.WbfwUploadContext;
import jp.co.extreme.module.wbfw.common.WbfwUrlParameterMap;
import jp.co.extreme.module.wbfw.common.WbfwUtil;
import jp.co.extreme.module.wbfw.container.WbfwRequestParameter;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.wbfw.session.WbfwHttpSession;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.dao.Wbs1FileResourceDAO;
import jp.co.extreme.module.wbs1.model.Wbs1Access;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.Wbs1FileResource;
import jp.co.extreme.module.wbs1.model.Wbs1PersonBasic;
import jp.co.extreme.module.wbs1.server.PersonManager;
import jp.co.extreme.module.wbs1.server.Wbs1ServerUtil;
import jp.co.extreme.module.wbs1.wcb.Wbs1AdministrationWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1ImageWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1LoginWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1MailAdrrssChange1WCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1MyPageWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1PasswordChangeWCB;
import jp.co.extreme.module.wbs1.wcb.Wbs1TestWCB;
import jp.co.extreme.module.wbs1.wcb.WbsHtmlTableCreator;
import jp.co.extreme.module.xdts.common.XdtsSqlParser;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xsys.common.XsysWords;
import jp.co.extreme.module.xsys.validation.XsysValidationElement;
import jp.co.extreme.module.xsys.validation.XsysValidationResult;
import jp.co.extreme.module.xweb.common.ExtwCssUtil;
import jp.co.extreme.module.xweb.common.HtmlTableModelForResultSet;
import jp.co.extreme.module.xweb.common.WbxConstants;
import jp.co.extreme.module.xweb.common.WbxPath;
import jp.co.extreme.module.xweb.common.WbxTokenContext;
import jp.co.extreme.module.xweb.common.XwebFileContext;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;
import jp.co.extreme.module.xweb.common.XwebMailContentHelper;
import jp.co.extreme.module.xweb.common.XwebSessionData;
import jp.co.extreme.person.common.PsnPersonConstants;
import jp.co.extreme.person.common.PsnPersonWords;
import jp.co.extreme.rmi.common.RmiMethodContext;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.SqlStatement;
import jp.co.extreme.web.javascript.WbfJslUtil;
import nlc.module.apcm.model.ApcmFieldAnnotation;

public final class XwebUtil {
    private static StringBuilder requiredBox = null;

    private XwebUtil() {
    }

    public static String createPath(Enum aEnum, String src) {
        if (src != null) {
            return src;
        }
        return BcStringUtil.toKebabCase(aEnum.name());
    }

    public static String enumName(Enum aEnum, String src) {
        if (src != null) {
            return src;
        }
        return aEnum.name();
    }

    public static void forward(WbfwWcbArgument wcbArg, String path) throws Exception {
        RequestDispatcher requestDispatcher = wcbArg.getRequest().getRequestDispatcher(path);
        BcLogUtil.debug("forward:path=" + path + " requestDispatcher=" + requestDispatcher);
        requestDispatcher.forward((ServletRequest)wcbArg.getRequest(), (ServletResponse)wcbArg.getResponse());
    }

    public static void forward(WbfwWcbArgument wcbArg, WbxPath xwebPath) throws Exception {
        XwebUtil.forward(wcbArg, xwebPath.getPath());
    }

    public static StringBuilder createSexSelection(String name, Map<String, String> dataMap, boolean notSpecified, String notSpecifiedValue, String notSpecifiedLabel, String defaultValue, String script) throws Exception {
        StringBuilder sb = new StringBuilder();
        int cnt = 0;
        if (notSpecified) {
            Object globalAttribute = null;
            boolean disabled = false;
            boolean checked = BcStringUtil.equals(notSpecifiedValue, defaultValue);
            sb.append((CharSequence)MdlCreator.getInstance().radioButton(name, notSpecifiedValue, checked, notSpecifiedValue, notSpecifiedLabel));
            ++cnt;
        }
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            if (cnt > 0) {
                sb.append(HtmlConstants.HtmlSpecialCharacter.space.value);
                sb.append(HtmlConstants.HtmlSpecialCharacter.space.value);
            }
            Object globalAttribute = null;
            boolean disabled = false;
            boolean checked = BcStringUtil.equals(entry.getKey(), defaultValue);
            sb.append((CharSequence)MdlCreator.getInstance().radioButton(name, entry.getKey(), checked, entry.getKey(), entry.getValue()));
            ++cnt;
        }
        return sb;
    }

    public static StringBuilder createSexSelection(String name, String defaultValue, boolean notSpecified) throws Exception {
        LinkedHashMap<String, String> dataMap = new LinkedHashMap<String, String>();
        String defaultValue2 = null;
        PsnPersonConstants.Sex[] sexArray = PsnPersonConstants.Sex.values();
        int n = sexArray.length;
        int n2 = 0;
        while (n2 < n) {
            PsnPersonConstants.Sex sex = sexArray[n2];
            dataMap.put(sex.code, PsnPersonWords.getInstance().toSexNameByCode(sex.code));
            if (sex.code.equals(defaultValue)) {
                defaultValue2 = sex.code;
            }
            ++n2;
        }
        String notSpecifiedValue = null;
        String notSpecifiedLabel = BcWords.getInstance().notSpecified;
        String script = null;
        return XwebUtil.createSexSelection(name, dataMap, notSpecified, notSpecifiedValue, notSpecifiedLabel, defaultValue2, script);
    }

    public static void putToMap(Class wcbClass, Class enumClass, Map<String, RmiMethodContext> map) throws Exception {
        List<Enum> enumList = BcLangUtil.toEnumList(enumClass);
        for (Enum aEnum : enumList) {
            String msg;
            String path = null;
            String methodName = null;
            if (aEnum instanceof WbxPath) {
                WbxPath xwebPath = (WbxPath)((Object)aEnum);
                path = xwebPath.getPath();
                methodName = xwebPath.getMethodName();
            } else {
                methodName = path = aEnum.name();
            }
            if (BcStringUtil.isEmpty(path)) {
                msg = "\u30d1\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 wcbClass=" + wcbClass.getName();
                throw new Exception(msg);
            }
            if (BcStringUtil.isEmpty(methodName)) {
                msg = "\u30e1\u30bd\u30c3\u30c9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002 wcbClass=" + wcbClass.getName();
                throw new Exception(msg);
            }
            if (map.containsKey(path)) {
                msg = "\u30d1\u30b9 " + path + "\u306f\u65e2\u306b\u767b\u9332\u6e08\u3067\u3059\u3002wcbClass=" + wcbClass.getName();
                throw new Exception(msg);
            }
            RmiMethodContext methodContext = new RmiMethodContext();
            methodContext.className = wcbClass.getName();
            methodContext.methodName = methodName;
            map.put(path, methodContext);
        }
    }

    public static void setup1(SqlResultSet rs, Map<String, Map<String, MmdField>> mmdFieldMap, DtsWordManager wordManager, EtcRsmdSupplement rsmdSupplement, HtmlTableModelForResultSet tableModelForResultSet, List<String> columnNameList) throws Exception {
        List<MmdField> mmdFieldList = ScfMmdServerUtil.createMmdFieldList(rs.getMetaData(), mmdFieldMap, wordManager, rsmdSupplement, Locale.getDefault(), columnNameList);
        tableModelForResultSet.setMmdFieldList(mmdFieldList);
        tableModelForResultSet.setResultSet(rs);
    }

    public static String setup2(DtsSession dtsSession, String query, DtsWordManager wordManager, WbsHtmlTableCreator htmlTableCreator, List<String> columnNameList) throws Exception {
        XdtsSqlParser sqlParser = new XdtsSqlParser();
        XdtsExtractionCondition extractionCondition = sqlParser.createExtractionCondition(query);
        Throwable throwable = null;
        Object var8_10 = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            HtmlTableModelForResultSet tableModelForResultSet = new HtmlTableModelForResultSet();
            XwebUtil.setup1(rs, dtsSession.getSessionFactory().mmdFieldMap, wordManager, sqlParser.rsmdSupplement, tableModelForResultSet, columnNameList);
            htmlTableCreator.setTableModel(tableModelForResultSet);
            String html = htmlTableCreator.create(null);
            rs.close();
            return html;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static HtmlTableModelForResultSet setup3(DtsSession dtsSession, String query, DtsWordManager wordManager, List<String> columnNameList) throws Exception {
        XdtsSqlParser sqlParser = new XdtsSqlParser();
        XdtsExtractionCondition extractionCondition = sqlParser.createExtractionCondition(query);
        Throwable throwable = null;
        Object var7_9 = null;
        try (SqlStatement stmt = dtsSession.getConnection().createStatement();){
            SqlResultSet rs = stmt.executeQuery(query);
            HtmlTableModelForResultSet tableModelForResultSet = new HtmlTableModelForResultSet();
            XwebUtil.setup1(rs, dtsSession.getSessionFactory().mmdFieldMap, wordManager, sqlParser.rsmdSupplement, tableModelForResultSet, columnNameList);
            return tableModelForResultSet;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void setAttribute(HttpSession httpSession, Object entity) throws Exception {
        httpSession.setAttribute(entity.getClass().getName(), entity);
    }

    public static void setAttribute(WbfwWcbArgument wcbArg, Object entity) throws Exception {
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, true);
        XwebUtil.setAttribute(httpSession, entity);
    }

    public static Object removeAttribute(WbfwWcbArgument wcbArg, Object entity) throws Exception {
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, true);
        Object attribute = httpSession.getAttribute(entity.getClass().getName());
        httpSession.removeAttribute(entity.getClass().getName());
        return attribute;
    }

    public static Object getAttribute1(WbfwWcbArgument wcbArg, boolean doThrow, String attributeName) throws Exception {
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, doThrow);
        if (httpSession != null) {
            return httpSession.getAttribute(attributeName);
        }
        return null;
    }

    public static Object getAttribute1(HttpSession httpSession, Enum attributeName) throws Exception {
        return httpSession.getAttribute(attributeName.name());
    }

    public static <T> T getAttribute1(HttpSession httpSession, Class<T> clazz) throws Exception {
        return (T)httpSession.getAttribute(clazz.getName());
    }

    public static Object getAttribute1(WbfwWcbArgument wcbArg, boolean doThrow, Enum attributeName) throws Exception {
        return XwebUtil.getAttribute1(wcbArg, doThrow, attributeName.name());
    }

    public static <T> T getAttribute1(WbfwWcbArgument wcbArg, boolean doThrow, Class<T> clazz) throws Exception {
        return (T)XwebUtil.getAttribute1(wcbArg, doThrow, clazz.getName());
    }

    public static String createDebugInfo(WbfwWcbArgument wcbArg) throws Exception {
        WbfwHttpSession httpSession;
        HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append(htmlBuilder.table_start());
        sb.append((CharSequence)XwebUtil.debugInfoRow("Current Time", BcTimeUtil.toString(System.currentTimeMillis(), "yyyy/MM/dd HH:mm:ss.SSS")));
        sb.append((CharSequence)XwebUtil.debugInfoRow("RequestURL", wcbArg.getRequest().getRequestURL()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("RequestURI", wcbArg.getRequest().getRequestURI()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("userAgent", wcbArg.getRequest().getHeader(HttpConstants.RequestHeader.User_Agent.value)));
        Cookie[] cookies = wcbArg.getRequest().getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                Cookie cookie = cookies[i];
                sb.append((CharSequence)XwebUtil.debugInfoRow("cookie[" + i + "]", "name=" + cookie.getName() + " value=" + cookie.getValue() + " maxAge=" + cookie.getMaxAge() + " domain=" + cookie.getDomain()));
                ++i;
            }
        }
        if ((httpSession = (WbfwHttpSession)wcbArg.getRequest().getSession(false)) == null) {
            sb.append((CharSequence)XwebUtil.debugInfoRow("HTTP Session", "null"));
        } else {
            sb.append((CharSequence)XwebUtil.debugInfoRow("HTTP Session", WbfwUtil.httpSessionInfo(httpSession).toString()));
            XwebSessionData sessionData = XwebUtil.getAttribute1((HttpSession)httpSession, XwebSessionData.class);
            sb.append((CharSequence)XwebUtil.debugInfoRow("---- WbxTokenContext", ""));
            for (Map.Entry<String, WbxTokenContext> mapEntry : sessionData.tokenContextMap.entrySet()) {
                WbxTokenContext tokenContext = mapEntry.getValue();
                sb.append((CharSequence)XwebUtil.debugInfoRow(XwebUtil.createTokenString(tokenContext), "cnt=" + tokenContext.cnt + " URL=" + tokenContext.note));
            }
            sb.append((CharSequence)XwebUtil.debugInfoRow(WbxConstants.SessionAttributeKey.userAccount.name(), httpSession.getAttribute(WbxConstants.SessionAttributeKey.userAccount.name())));
            sb.append((CharSequence)XwebUtil.debugInfoRow(WbxConstants.SessionAttributeKey.userPersonBasic.name(), httpSession.getAttribute(WbxConstants.SessionAttributeKey.userPersonBasic.name())));
        }
        sb.append((CharSequence)XwebUtil.debugInfoRow("QueryString", wcbArg.getRequest().getQueryString()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("ContextPath", wcbArg.getRequest().getContextPath()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("ServletPath", wcbArg.getRequest().getServletPath()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("PathInfo", wcbArg.getRequest().getPathInfo()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("PathTranslated", wcbArg.getRequest().getPathTranslated()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("Method", wcbArg.getRequest().getMethod()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("AuthType", wcbArg.getRequest().getAuthType()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("RemoteUser", wcbArg.getRequest().getRemoteUser()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("ServerName", wcbArg.getRequest().getServerName()));
        sb.append((CharSequence)XwebUtil.debugInfoRow("ServerPort", wcbArg.getRequest().getServerPort()));
        sb.append(htmlBuilder.table_end());
        return sb.toString();
    }

    public static StringBuilder debugInfoRow(Object ... cells) throws Exception {
        HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
        StringBuilder sb = new StringBuilder();
        sb.append(htmlBuilder.tr_start());
        int i = 0;
        while (i < cells.length) {
            sb.append("<td>");
            sb.append(cells[i]);
            sb.append(htmlBuilder.td_end());
            ++i;
        }
        sb.append(htmlBuilder.tr_end());
        return sb;
    }

    public static Wbs1Access createAccessLog(WbfwWcbArgument wcbArg) throws Exception {
        HttpServletRequest httpReq = wcbArg.getRequest();
        Wbs1Access access = new Wbs1Access();
        access.accessDate = BcTimeUtil.toYyyyMMdd(wcbArg.startDateTime);
        access.accessTime = BcTimeUtil.toHHmmssSSS(wcbArg.startDateTime);
        access.remoteAddress = httpReq.getRemoteAddr();
        access.remotePort = httpReq.getRemotePort();
        access.remoteUser = httpReq.getRemoteUser();
        access.requestUrl = httpReq.getRequestURL().toString();
        access.referer = httpReq.getHeader(HttpConstants.RequestHeader.Referer.value);
        return access;
    }

    public static String createMsg(XsysValidationResult validationResult) throws Exception {
        String msg = null;
        msg = validationResult != null ? HtmlUtil.encode(validationResult.result.getErrorList()) : new String();
        return msg;
    }

    public static List getList(Map<String, XsysValidationElement> msgMap, String key) throws Exception {
        XsysValidationElement validationElement;
        List msgList = null;
        if (msgMap != null && (validationElement = msgMap.get(key)) != null) {
            msgList = validationElement.msgList;
        }
        return msgList;
    }

    public static List getFieldErrorMsg(XsysValidationResult validationResult, String key) throws Exception {
        List errMsgList = null;
        if (validationResult != null) {
            errMsgList = XwebUtil.getList(validationResult.fieldErrMap, key);
        }
        return errMsgList;
    }

    public static StringBuilder div_radius(CharSequence content) throws Exception {
        HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
        CssBuiler cssBuiler = new CssBuiler();
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.style = cssBuiler.padding("0.4rem", "0.4rem").border("1px", "solid", "#a9a9a9").border_radius("6px").box_shadow("4px 4px 8px -4px #dcdcdc").build();
        sb.append(htmlBuilder.div_start(globalAttribute));
        sb.append(content);
        sb.append(htmlBuilder.div_end());
        return sb;
    }

    public static String getRequiredBox(String fontSize, String text) throws Exception {
        if (requiredBox != null) {
            return requiredBox.toString();
        }
        HtmlBuilder htmlBuilder = HtmlBuilder.getInstance();
        CssBuiler cssBuiler = new CssBuiler();
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.style = cssBuiler.padding("0px", "0px", "2px", "0px").text_align("top").build();
        sb.append(htmlBuilder.tagStart(HtmlConstants.HtmlTag.box, globalAttribute, true));
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.style = cssBuiler.padding("1px", "2px").border_radius("2px").background_color(HtmlConstants.HtmlColor.tomato).box_shadow("1px 1px var(--shadow-color)").font_size(fontSize).color(HtmlConstants.HtmlColor.white).vertical_align("2px").build();
        sb.append((CharSequence)htmlBuilder.span_start(globalAttribute));
        if (!BcStringUtil.isEmpty(text)) {
            sb.append(text);
        }
        sb.append(htmlBuilder.tagEnd(HtmlConstants.HtmlTag.span, true));
        sb.append(htmlBuilder.tagEnd(HtmlConstants.HtmlTag.box, true));
        requiredBox = sb;
        return requiredBox.toString();
    }

    public static StringBuilder divPadding(HtmlBuilder htmlBuilder, CharSequence html, int ... pxs) throws Exception {
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute htmlGlobalAttribute = new HtmlGlobalAttribute();
        htmlGlobalAttribute.style = "padding:" + XwebUtil.temp1("px", pxs) + ";";
        sb.append(htmlBuilder.div_start(htmlGlobalAttribute, true));
        sb.append(html);
        sb.append(htmlBuilder.div_end());
        return sb;
    }

    public static StringBuilder temp1(String unit, int ... pxs) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < pxs.length) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(pxs[i]);
            sb.append(unit);
            ++i;
        }
        return sb;
    }

    public static List<List<Map.Entry<Field, MmdField>>> createGroupList(Class entityClass) throws Exception {
        List<Map.Entry<Field, MmdField>> mapEntryList = MmdxUtil.createFieldEntryList(entityClass);
        ArrayList<List<Map.Entry<Field, MmdField>>> groupList = new ArrayList<List<Map.Entry<Field, MmdField>>>();
        ArrayList<Map.Entry<Field, MmdField>> mapEntryList2 = null;
        int i = 0;
        while (i < mapEntryList.size()) {
            Map.Entry<Field, MmdField> mapEntry = mapEntryList.get(i);
            Field field = mapEntry.getKey();
            MmdField mmdField = mapEntry.getValue();
            int arrangement = 0;
            ApcmFieldAnnotation fieldAnnotation = field.getAnnotation(ApcmFieldAnnotation.class);
            if (fieldAnnotation != null) {
                arrangement = BcNumberUtil.parseInt(fieldAnnotation.arrangement(), 0);
            }
            if (arrangement != 1 || mapEntryList2 == null) {
                if (mapEntryList2 != null) {
                    groupList.add((List<Map.Entry<Field, MmdField>>)mapEntryList2);
                }
                mapEntryList2 = new ArrayList<Map.Entry<Field, MmdField>>();
            }
            mapEntryList2.add(mapEntry);
            ++i;
        }
        groupList.add(mapEntryList2);
        return groupList;
    }

    public static WbxTokenContext getToken(WbfwWcbArgument wcbArg) throws Exception {
        WbfwRequestParameter requestParameter = wcbArg.getRequestParameter();
        String tokenReq = requestParameter.getAsString(WbxConstants.SessionAttributeKey.token.name());
        BcLogUtil.debug("tokenReq=" + tokenReq);
        if (BcStringUtil.isEmpty(tokenReq)) {
            return null;
        }
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, false);
        if (httpSession == null) {
            return null;
        }
        String tokenPrefix = null;
        String tokenSuffix = null;
        int index1 = tokenReq.indexOf("-");
        if (index1 >= 0) {
            tokenPrefix = tokenReq.substring(0, index1);
            tokenSuffix = tokenReq.substring(index1 + 1);
        }
        BcLogUtil.debug("tokenPrefix=" + tokenPrefix + " tokenSuffix=" + tokenSuffix);
        XwebSessionData sessionData = XwebUtil.getAttribute1(httpSession, XwebSessionData.class);
        if (sessionData == null) {
            return null;
        }
        WbxTokenContext tokenContext = sessionData.tokenContextMap.get(tokenPrefix);
        return tokenContext;
    }

    public static WbxTokenContext checkToken(WbfwWcbArgument wcbArg, WbxConstants.TokenType tokenType) throws Exception {
        XwebSessionData sessionData;
        int index1;
        HttpSession httpSession = null;
        httpSession = tokenType == WbxConstants.TokenType.form ? WbfwUtil.getSession(wcbArg, false, true) : WbfwUtil.getSession(wcbArg, true, false);
        WbfwRequestParameter requestParameter = wcbArg.getRequestParameter();
        String tokenReq = requestParameter.getAsString(WbxConstants.SessionAttributeKey.token.name());
        String tokenPrefix = null;
        String tokenSuffix = null;
        if (!BcStringUtil.isEmpty(tokenReq) && (index1 = tokenReq.indexOf("-")) >= 0) {
            tokenPrefix = tokenReq.substring(0, index1);
            tokenSuffix = tokenReq.substring(index1 + 1);
        }
        if ((sessionData = XwebUtil.getAttribute1(httpSession, XwebSessionData.class)) == null) {
            sessionData = new XwebSessionData();
            XwebUtil.setAttribute(httpSession, (Object)sessionData);
        }
        WbxTokenContext tokenContext = null;
        if (!BcStringUtil.isEmpty(tokenPrefix)) {
            tokenContext = sessionData.tokenContextMap.get(tokenPrefix);
            if (tokenContext == null) {
                if (tokenType == WbxConstants.TokenType.form || tokenType == WbxConstants.TokenType.status) {
                    throw new Exception("\u4e0d\u6b63\u306a\u30da\u30fc\u30b8\u79fb\u52d5\u3067\u3059\u3002");
                }
            } else if (!tokenContext.tokenSuffix.equals(tokenSuffix)) {
                BcLogUtil.debug("tokenSuffix \u304c\u7570\u306a\u308a\u307e\u3059\u3002:SV=" + tokenContext.tokenSuffix + " REQ=" + tokenSuffix);
                if (tokenType == WbxConstants.TokenType.form) {
                    throw new Exception("\u4e0d\u6b63\u306a\u30da\u30fc\u30b8\u79fb\u52d5\u3067\u3059\u3002");
                }
            }
        }
        if (tokenContext == null) {
            tokenContext = new WbxTokenContext();
            tokenContext.tokenType = tokenType;
            tokenContext.tokenPrefix = BcRandamUtil.createCodeSecure(5, 32);
            tokenContext.httpSession = httpSession;
            tokenContext.note = wcbArg.getRequest().getRequestURL().toString();
            sessionData.tokenContextMap.put(tokenContext.tokenPrefix, tokenContext);
        }
        if (tokenType == WbxConstants.TokenType.form || BcStringUtil.isEmpty(tokenContext.tokenSuffix)) {
            tokenContext.tokenSuffix = BcRandamUtil.createCodeSecure(5, 16);
        }
        ++tokenContext.cnt;
        return tokenContext;
    }

    public static WbxTokenContext checkTokenForForm(WbfwWcbArgument wcbArg) throws Exception {
        return XwebUtil.checkToken(wcbArg, WbxConstants.TokenType.form);
    }

    public static WbxTokenContext checkTokenForSearch(WbfwWcbArgument wcbArg) throws Exception {
        WbxTokenContext tokenContext = XwebUtil.checkToken(wcbArg, WbxConstants.TokenType.search);
        XwebUtil.savePreUrl(wcbArg, tokenContext);
        return tokenContext;
    }

    public static WbxTokenContext checkTokenForStatus(WbfwWcbArgument wcbArg) throws Exception {
        return XwebUtil.checkToken(wcbArg, WbxConstants.TokenType.status);
    }

    public static String createTokenHiddn(HtmlBuilder htmlBuilder, WbxTokenContext tokenContext) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(htmlBuilder.hidden(WbxConstants.SessionAttributeKey.token.name(), XwebUtil.createTokenString(tokenContext), WbxConstants.SessionAttributeKey.token.name()));
        return sb.toString();
    }

    public static boolean removeTokenContext(WbfwWcbArgument wcbArg, WbxTokenContext tokenContext) throws Exception {
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, false);
        WbxTokenContext tokenContext2 = null;
        if (httpSession != null) {
            tokenContext2 = (WbxTokenContext)httpSession.getAttribute(WbxConstants.SessionAttributeKey.token.name());
        }
        return tokenContext2 != null;
    }

    public static String createTokenString(String tokenPrefix, String tokenSuffix) throws Exception {
        return String.valueOf(tokenPrefix) + "-" + tokenSuffix;
    }

    public static String createTokenString(WbxTokenContext tokenContext) throws Exception {
        return XwebUtil.createTokenString(tokenContext.tokenPrefix, tokenContext.tokenSuffix);
    }

    public static void saveValidationResult(HttpSession httpSession, XsysValidationResult validationResult) throws Exception {
        validationResult.id = BcRandamUtil.createCodeSecure(5, 32);
        httpSession.setAttribute(WbxConstants.SessionAttributeKey.validationId.name(), (Object)validationResult);
    }

    public static void redirectForError(WbfwWcbArgument wcbArg, XsysValidationResult validationResult, String path) throws Exception {
        if (!BcCollectionUtil.isEmpty(validationResult.fieldErrMap) && !validationResult.result.hasError()) {
            validationResult.result.addError(WbxConstants.MSG.\u5165\u529b\u5185\u5bb9\u306b\u4e0d\u5099\u304c\u3042\u308b\u3088\u3046\u3067\u3059_\u304a\u624b\u6570\u3067\u3059\u304c\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u3054\u78ba\u8a8d\u306e\u4e0a_\u3082\u3046\u4e00\u5ea6\u3054\u5165\u529b\u304f\u3060\u3055\u3044.value);
        }
        String url = String.valueOf(path) + WbfwUtil.createUrlQuery(XwebUtil.createValidationIdParameter(validationResult));
        wcbArg.getResponse().sendRedirect(url);
    }

    public static String createValidationIdParameter(XsysValidationResult validationResult) throws Exception {
        return WbfwUtil.createParameter(WbxConstants.SessionAttributeKey.validationId.name(), (Object)validationResult.id);
    }

    public static void inputErrorPreprocessing(WbxTokenContext tokenContext, WbfwRequestParameter requestParameter, XsysValidationResult validationResult) throws Exception {
        requestParameter.map.put(WbxConstants.SessionAttributeKey.token.name(), XwebUtil.createTokenString(tokenContext));
        if (!BcCollectionUtil.isEmpty(validationResult.fieldErrMap) && !validationResult.result.hasError()) {
            validationResult.result.addError(WbxConstants.MSG.\u5165\u529b\u5185\u5bb9\u306b\u4e0d\u5099\u304c\u3042\u308b\u3088\u3046\u3067\u3059_\u304a\u624b\u6570\u3067\u3059\u304c\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u3054\u78ba\u8a8d\u306e\u4e0a_\u3082\u3046\u4e00\u5ea6\u3054\u5165\u529b\u304f\u3060\u3055\u3044.value);
        }
    }

    public static void validatePpassword(XsysValidationResult validationResult, String password1, String password2) throws Exception {
        Pattern pattern;
        Matcher matcher;
        if (!BcStringUtil.isEmpty(password1) && !BcStringUtil.isEmpty(password2) && (matcher = (pattern = Pattern.compile("^([a-zA-Z0-9]{8,})$")).matcher(password1)).matches() && !password1.equals(password2)) {
            validationResult.result.addError(WbxConstants.MSG.\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u78ba\u8a8d\u7528\u3068\u4e00\u81f4\u3057\u307e\u305b\u3093.value);
        }
    }

    public static WbfwConstants.TerminalType getTerminalType(String userAgentName) throws Exception {
        BcLogUtil.debug("userAgentName=" + userAgentName);
        WbfwConstants.TerminalType terminalType = WbfwConstants.TerminalType.PC;
        if (userAgentName.toLowerCase().indexOf("iphone") >= 0) {
            terminalType = WbfwConstants.TerminalType.Smartphone;
        } else if (userAgentName.toLowerCase().indexOf("qndroid") >= 0) {
            if (userAgentName.toLowerCase().indexOf("mobile") >= 0) {
                terminalType = WbfwConstants.TerminalType.Smartphone;
            }
        } else if (userAgentName.toLowerCase().indexOf("windows phone") >= 0) {
            terminalType = WbfwConstants.TerminalType.Smartphone;
        } else if (userAgentName.toLowerCase().indexOf("ipad") >= 0) {
            terminalType = WbfwConstants.TerminalType.Tablet;
        }
        return terminalType;
    }

    public static WbfwConstants.TerminalType getTerminalType(WbfwWcbArgument wcbArg) throws Exception {
        if (wcbArg.terminalType != null) {
            return wcbArg.terminalType;
        }
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, true, false);
        wcbArg.terminalType = (WbfwConstants.TerminalType)((Object)httpSession.getAttribute(WbxConstants.SessionAttributeKey.terminalType.name()));
        if (wcbArg.terminalType != null) {
            return wcbArg.terminalType;
        }
        String userAgentName = wcbArg.getRequest().getHeader(HttpConstants.RequestHeader.User_Agent.value);
        wcbArg.terminalType = XwebUtil.getTerminalType(userAgentName);
        if (wcbArg.terminalType != null) {
            BcLogUtil.debug("terminalType=" + (Object)((Object)wcbArg.terminalType));
            httpSession.setAttribute(WbxConstants.SessionAttributeKey.terminalType.name(), (Object)wcbArg.terminalType);
        }
        return wcbArg.terminalType;
    }

    public static short parserTiem(String hhmmStr) throws Exception {
        short hhmm = 0;
        BcStringUtil.isEmpty(hhmm);
        String tmpString = hhmmStr.replace(BcStringUtil.COLON_STR, "");
        hhmm = Short.parseShort(tmpString);
        return hhmm;
    }

    public static StringBuilder include_lightbox(WbfSiteContext siteContext) throws Exception {
        String path = "ext_js/include/lightbox.txt";
        return XwebUtil.getText(siteContext, path);
    }

    public static StringBuilder include_react_test(WbfSiteContext siteContext) throws Exception {
        String path = "ext_js/include/react_test.txt";
        return XwebUtil.getText(siteContext, path);
    }

    public static StringBuilder getText(WbfSiteContext siteContext, String path) throws Exception {
        File file = null;
        for (File dir : siteContext.resourceDirList) {
            file = new File(dir, path);
            if (file.exists()) break;
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        StringBuilder sb = new StringBuilder();
        sb.append(BcStreamUtil.readAsString((InputStream)is, BcConstants.charset));
        return sb;
    }

    public static String toContextPath(String path) {
        return "/" + path;
    }

    public static String toContextPath(WbxPath path) {
        return XwebUtil.toContextPath(path.getPath());
    }

    public static String toRelativePath(HttpServletRequest httpReq, String path) {
        return "./" + path;
    }

    public static String toRelativePath(HttpServletRequest httpReq, WbxPath path) {
        return XwebUtil.toRelativePath(httpReq, path.getPath());
    }

    public static String getContextRootPath(HttpServletRequest httpReq) {
        return XwebUtil.toRelativePath(httpReq, "");
    }

    public static String toAbsolutePath(HttpServletRequest httpReq, String path) {
        return String.valueOf(HttpUtil.getUrlContextPath(httpReq)) + "/" + path;
    }

    public static String toAbsolutePath(HttpServletRequest httpReq, WbxPath path) {
        return XwebUtil.toAbsolutePath(httpReq, path.getPath());
    }

    public static Map<String, String> parseQuery(String query) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] stringArray = query.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String q = stringArray[n2];
            String[] qa = q.split("=");
            String name = URLDecoder.decode(qa[0]);
            String value = "";
            if (qa.length == 2) {
                value = URLDecoder.decode(qa[1]);
            }
            map.put(name, value);
            ++n2;
        }
        return map;
    }

    public static DtsSession createDataSourceSession(WbfSiteContext siteContext, Object owner) throws Exception {
        return DtsSessionFactoryManegaer.getInstance().createSession(siteContext.getDataSourceName(), owner);
    }

    public static Wbs1FileResource createFileResource(String fileName) throws Exception {
        Wbs1FileResource fileResource = new Wbs1FileResource();
        fileResource.fileName = fileName;
        fileResource.fileExtention = BcFileUtil.getExtention(fileName);
        return fileResource;
    }

    public static String createFileName(Wbs1FileResource fileResource) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(BcStringUtil.fillPrefix(fileResource.id, 8));
        if (!BcStringUtil.isEmpty(fileResource.fileExtention)) {
            sb.append('.');
            sb.append(fileResource.fileExtention);
        }
        return sb.toString();
    }

    public static File createNewFileName(File file) throws Exception {
        BcLogUtil.debug("createNewFileName:file.getPath()=" + file.getPath() + " exists=" + file.exists());
        if (!file.exists()) {
            return file;
        }
        String baseName = BcFileUtil.getBaseName(file);
        String extention = BcFileUtil.getExtention(file);
        File dir = file.getParentFile();
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            String newFileName = BcFileUtil.createFileName(String.valueOf(baseName) + BcStringUtil.TILDE_STR + i, extention);
            File newFile = new File(dir, newFileName);
            if (!newFile.exists()) {
                return newFile;
            }
            ++i;
        }
        String msg = "\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u4f5c\u6210\u51fa\u6765\u307e\u305b\u3093\u3002file=" + file.getPath();
        throw new Exception(msg);
    }

    public static List<XwebFileContext> createFileContextList(WbfwWcbArgument wcbArg, DtsSession dtsSession, BcLogger logger) throws Exception {
        WbfwRequestParameter requestParameter = wcbArg.getRequestParameter();
        BcLogUtil.debug("uploadContextList.size()=" + requestParameter.uploadContextList.size());
        ArrayList<XwebFileContext> fileContextList = new ArrayList<XwebFileContext>();
        int i = 0;
        while (i < requestParameter.uploadContextList.size()) {
            WbfwUploadContext uploadContext = requestParameter.uploadContextList.get(i);
            BcLogUtil.debug("uploadContext.fileName=" + uploadContext.fileName);
            if (!BcStringUtil.isEmpty(uploadContext.fileName)) {
                Wbs1FileResource fileResource = JsonNodeVisitorForEditorJs.fileProc(wcbArg, uploadContext.tempFile, dtsSession, uploadContext.fileName, logger);
                XwebFileContext fileContext = new XwebFileContext();
                fileContext.fileResource = fileResource;
                fileContext.uploadContext = uploadContext;
                fileContextList.add(fileContext);
            }
            ++i;
        }
        return fileContextList;
    }

    public static XwebFileContext createFileContext(WbfwWcbArgument wcbArg, DtsSession dtsSession, long fileId) throws Exception {
        XwebFileContext fileContext = new XwebFileContext();
        Wbs1FileResource fileResource = null;
        if (fileId > 0L) {
            fileResource = (Wbs1FileResource)Wbs1FileResourceDAO.getInstance().getById(dtsSession, fileId);
        }
        if (fileResource != null) {
            fileContext.fileName = fileResource.fileName;
            fileContext.href = String.valueOf(XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1ImageWCB.Method.getImage)) + "/" + fileResource.fileName3;
        }
        return fileContext;
    }

    public static File createNewFile(File file, File tmpFile, boolean doRename) throws Exception {
        File newFile;
        block2: {
            File dir = file.getParentFile();
            String baseName = BcFileUtil.getBaseName(file);
            String extention = BcFileUtil.getExtention(file);
            long num = -1L;
            while (true) {
                if (++num == Long.MAX_VALUE) {
                    String msg = "\u30d5\u30a1\u30a4\u30eb\u540d\u751f\u6210\u306e\u4e0a\u9650\u306b\u9054\u3057\u307e\u3057\u305f\u3002";
                    throw new Exception(msg);
                }
                String newName = null;
                newName = num <= 0L ? file.getName() : BcFileUtil.createFileName(String.valueOf(baseName) + "-" + num, extention);
                newFile = new File(dir, newName);
                if (newFile.exists()) continue;
                if (!doRename) break block2;
                if (tmpFile.renameTo(newFile)) break;
            }
            return newFile;
        }
        return newFile;
    }

    public static Wbs1Account getLoginAccount(WbfwWcbArgument wcbArg, boolean doThrow) throws Exception {
        Wbs1Account account = (Wbs1Account)XwebUtil.getAttribute1(wcbArg, doThrow, WbxConstants.SessionAttributeKey.userAccount);
        if (account == null && doThrow) {
            throw new WbSessionTimeoutException("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u304f\u308c\uff01");
        }
        return account;
    }

    public static Wbs1PersonBasic getLoginPersonBasic(WbfwWcbArgument wcbArg, boolean doThrow) throws Exception {
        Wbs1PersonBasic personBasic = (Wbs1PersonBasic)XwebUtil.getAttribute1(wcbArg, doThrow, WbxConstants.SessionAttributeKey.userPersonBasic);
        if (personBasic == null && doThrow) {
            throw new WbSessionTimeoutException("\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u304f\u308c\uff01");
        }
        return personBasic;
    }

    public static boolean isAdmin(Wbs1Account account) throws Exception {
        return EtcEnumStrUtil.contains(account.authoritys, Wbs1Constants.Authority.\u7ba1\u7406\u8005.code);
    }

    public static boolean isAdmin(WbfwWcbArgument wcbArg) throws Exception {
        Wbs1Account loginAccount = XwebUtil.getLoginAccount(wcbArg, false);
        if (loginAccount == null) {
            return false;
        }
        return XwebUtil.isAdmin(loginAccount);
    }

    public static String toOpeningHours(Short startHHmm, Short endHHmm) throws Exception {
        StringBuilder sb = new StringBuilder();
        if (startHHmm != null) {
            sb.append(BcTimeUtil.toStringFromHHmm(startHHmm, "HH:mm"));
        }
        sb.append(" \uff5e ");
        if (endHHmm != null) {
            sb.append(BcTimeUtil.toStringFromHHmm(endHHmm, "HH:mm"));
        }
        return sb.toString();
    }

    public static StringBuilder createLeftNaviForAdmin(WbfwWcbArgument wcbArg, XwebHtmlBuilder htmlBuilder) throws Exception {
        WbfSiteContext siteContext = wcbArg.getSiteContext();
        StringBuilder sb = new StringBuilder();
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1AdministrationWCB.Method.admin);
        sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
        sb.append(MdcConstants.icon(MdcConstants.MdcIcon.face, -1));
        sb.append(XsysWords.getInstance().\u7ba1\u7406\u8005\u30da\u30fc\u30b8);
        sb.append(htmlBuilder.a_end());
        if (XwebUtil.hasFunction(wcbArg.getSiteContext(), WbxConstants.SiteFunction.attendance)) {
            href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1AdministrationWCB.Method.attendanceCheck);
            sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
            sb.append(MdcConstants.icon(MdcConstants.MdcIcon.logout, -1));
            sb.append(XsysWords.getInstance().\u52e4\u6020\u7ba1\u7406);
            sb.append(htmlBuilder.a_end());
        }
        href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1LoginWCB.Method.logout);
        sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
        sb.append(MdcConstants.icon(MdcConstants.MdcIcon.logout, -1));
        sb.append("Logout");
        sb.append(htmlBuilder.a_end());
        href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1TestWCB.Method.accessInfo);
        sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
        sb.append(MdcConstants.icon(MdcConstants.MdcIcon.settings, -1));
        sb.append("\u30a2\u30af\u30bb\u30b9\u6570");
        sb.append(htmlBuilder.a_end());
        href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1TestWCB.Method.dubugSwitch);
        sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
        sb.append(MdcConstants.icon(MdcConstants.MdcIcon.settings, -1));
        sb.append("\u30c7\u30d0\u30c3\u30b0\u30d5\u30e9\u30b0\u5207\u66ff");
        sb.append(htmlBuilder.a_end());
        if (AfbApplication.getInstance().isDebug) {
            href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1TestWCB.Method.error1);
            sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
            sb.append(MdcConstants.icon(MdcConstants.MdcIcon.error, -1));
            sb.append("\u30bf\u30a4\u30d7\u30a2\u30a6\u30c8\u4f8b\u5916");
            sb.append(htmlBuilder.a_end());
            href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1TestWCB.Method.seriousException);
            sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
            sb.append(MdcConstants.icon(MdcConstants.MdcIcon.error, -1));
            sb.append("\u91cd\u5927\u306a\u4f8b\u5916");
            sb.append(htmlBuilder.a_end());
            href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1TestWCB.Method.exceptionLoop);
            sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
            sb.append(MdcConstants.icon(MdcConstants.MdcIcon.error, -1));
            sb.append("\u4f8b\u5916\u30eb\u30fc\u30d7");
            sb.append(htmlBuilder.a_end());
        }
        return sb;
    }

    public static StringBuilder createLeftNaviForGeneralUser(WbfwWcbArgument wcbArg, XwebHtmlBuilder htmlBuilder) throws Exception {
        WbfSiteContext siteContext = wcbArg.getSiteContext();
        StringBuilder sb = new StringBuilder();
        String href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1MyPageWCB.Method.myPage);
        sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
        sb.append(MdcConstants.icon(MdcConstants.MdcIcon.face, -1));
        sb.append(XsysWords.getInstance().\u30de\u30a4\u30da\u30fc\u30b8);
        sb.append(htmlBuilder.a_end());
        href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1MailAdrrssChange1WCB.Method.form);
        sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
        sb.append(MdcConstants.icon(MdcConstants.MdcIcon.email, -1));
        sb.append(XsysWords.getInstance().\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u5909\u66f4);
        sb.append(htmlBuilder.a_end());
        href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1PasswordChangeWCB.Method.form);
        sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
        sb.append(MdcConstants.icon(MdcConstants.MdcIcon.password, -1));
        sb.append(XsysWords.getInstance().\u30d1\u30b9\u30ef\u30fc\u30c9\u5909\u66f4);
        sb.append(htmlBuilder.a_end());
        href = wcbArg.getRequest().getContextPath();
        sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
        sb.append(MdcConstants.icon(MdcConstants.MdcIcon.home, -1));
        sb.append(XsysWords.getInstance().Home);
        sb.append(htmlBuilder.a_end());
        if (XwebUtil.isAdmin(wcbArg)) {
            href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1AdministrationWCB.Method.admin);
            sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
            sb.append(MdcConstants.icon(MdcConstants.MdcIcon.menu, -1));
            sb.append(XsysWords.getInstance().\u7ba1\u7406\u8005\u30da\u30fc\u30b8);
            sb.append(htmlBuilder.a_end());
        }
        href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1LoginWCB.Method.logout);
        sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
        sb.append(MdcConstants.icon(MdcConstants.MdcIcon.logout, -1));
        sb.append("Logout");
        sb.append(htmlBuilder.a_end());
        href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1TestWCB.Method.dubugSwitch);
        sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
        sb.append(MdcConstants.icon(MdcConstants.MdcIcon.settings, -1));
        sb.append("\u30c7\u30d0\u30c3\u30b0\u30d5\u30e9\u30b0\u5207\u66ff");
        sb.append(htmlBuilder.a_end());
        if (AfbApplication.getInstance().isDebug) {
            href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1TestWCB.Method.error1);
            sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
            sb.append(MdcConstants.icon(MdcConstants.MdcIcon.error, -1));
            sb.append("\u30bf\u30a4\u30d7\u30a2\u30a6\u30c8\u4f8b\u5916");
            sb.append(htmlBuilder.a_end());
            href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1TestWCB.Method.seriousException);
            sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
            sb.append(MdcConstants.icon(MdcConstants.MdcIcon.error, -1));
            sb.append("\u91cd\u5927\u306a\u4f8b\u5916");
            sb.append(htmlBuilder.a_end());
            href = XwebUtil.toRelativePath(wcbArg.getRequest(), Wbs1TestWCB.Method.exceptionLoop);
            sb.append(htmlBuilder.a_start(href, MdlConstants.MdlClass.mdl_navigation__link.value, null));
            sb.append(MdcConstants.icon(MdcConstants.MdcIcon.error, -1));
            sb.append("\u4f8b\u5916\u30eb\u30fc\u30d7");
            sb.append(htmlBuilder.a_end());
        }
        return sb;
    }

    public static boolean isAcceptDate(int yyyyMMdd) throws Exception {
        Calendar calendar2 = BcTimeUtil.createCalendar();
        calendar2.add(2, 3);
        BcTimeUtil.setMonthEnd(calendar2);
        BcLogUtil.debug("calendar2=" + BcTimeUtil.toString(calendar2));
        return yyyyMMdd >= BcTimeUtil.createYyyyMMdd() && yyyyMMdd < BcTimeUtil.toYyyyMMdd(calendar2);
    }

    public static boolean isAcceptDate(Calendar calendar) throws Exception {
        return XwebUtil.isAcceptDate(BcTimeUtil.toYyyyMMdd(calendar));
    }

    public static StringBuilder createCradTitle(XwebHtmlBuilder htmlBuilder, String title, String iconTag) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(htmlBuilder.div_start(ExtwCssUtil.ExtwClass.extw_row.className, ExtwCssUtil.ExtwClass.extw_flex_baseline.className));
        if (!BcStringUtil.isEmpty(iconTag)) {
            sb.append(iconTag);
            sb.append((CharSequence)htmlBuilder.div(ExtwCssUtil.ExtwClass.extw_width_05rem.className));
        }
        sb.append(htmlBuilder.h(6, title));
        sb.append(htmlBuilder.div_end());
        sb.append((CharSequence)htmlBuilder.div(ExtwCssUtil.ExtwClass.extw_height_05rem.className));
        return sb;
    }

    public static StringBuilder createLargeButton(WbfwWcbArgument wcbArg, XwebHtmlBuilder htmlBuilder, CssBuiler cssBuiler, String path, String iconTag, String title, String description) throws Exception {
        String onclickAction = WbfJslUtil.locationHref(path);
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = BcStringUtil.toSsv(ExtwCssUtil.ExtwClass.extw_box_radius_8px.className, ExtwCssUtil.ExtwClass.extw_box_shadow_6px.className, "large_button");
        sb.append(htmlBuilder.button_start(globalAttribute, HtmlConstants.HtmlButtonType.button, null, null, false, onclickAction));
        sb.append(htmlBuilder.div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        sb.append("<div style=\"vertical-align: top; width: 3rem;\">");
        BcStringUtil.append(sb, iconTag);
        sb.append(htmlBuilder.div_end());
        sb.append(htmlBuilder.div_start());
        sb.append(htmlBuilder.div_start(ExtwCssUtil.ExtwClass.extw_row.className));
        sb.append(htmlBuilder.h(6, title));
        sb.append(htmlBuilder.div_end());
        sb.append("<div style=\"vertical-align: top;\">");
        globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.style = cssBuiler.text_align("left").font_size("0.8rem").padding("0 0.8rem 0 0").build();
        sb.append(htmlBuilder.p(globalAttribute, description, true, false));
        sb.append(htmlBuilder.div_end());
        sb.append(htmlBuilder.div_end());
        sb.append(htmlBuilder.div_end());
        sb.append(htmlBuilder.button_end());
        return sb;
    }

    public static void savePreUrl(WbfwWcbArgument wcbArg, WbxTokenContext tokenContext) throws Exception {
        String preUrl = null;
        if (BcStringUtil.isEmpty(wcbArg.getRequest().getQueryString())) {
            WbfwRequestParameter requestParameter = wcbArg.getRequestParameter();
            WbfwUrlParameterMap decryptMap = WbfwUtil.getDecryptMap(requestParameter.map);
            String[] params = new String[requestParameter.map.size()];
            int index = -1;
            for (Map.Entry mapEntry : requestParameter.map.entrySet()) {
                ++index;
                String value = null;
                if (List.class.isAssignableFrom(mapEntry.getValue().getClass())) {
                    List valueList = (List)mapEntry.getValue();
                    value = BcStringUtil.toCsv(valueList);
                } else {
                    value = (String)mapEntry.getValue();
                }
                params[index] = WbfwUtil.createParameter((String)mapEntry.getKey(), (Object)value);
            }
            preUrl = String.valueOf(wcbArg.getRequest().getRequestURI()) + WbfwUtil.createUrlQuery(params);
        } else {
            preUrl = WbfwUtil.createRequestUrl(wcbArg.getRequest());
        }
        BcLogUtil.debug("savePreUrl:preUrl=" + preUrl);
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, true, true);
        httpSession.setAttribute(WbxConstants.SessionAttributeKey.preUrl.name(), (Object)preUrl);
        httpSession.setAttribute(WbxConstants.SessionAttributeKey.preToken.name(), (Object)XwebUtil.createTokenString(tokenContext));
    }

    public static void redirectPreUrl(WbfwWcbArgument wcbArg) throws Exception {
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, true, true);
        String preUrl = (String)httpSession.getAttribute(WbxConstants.SessionAttributeKey.preUrl.name());
        String preToken = (String)httpSession.getAttribute(WbxConstants.SessionAttributeKey.preToken.name());
        if (BcStringUtil.isEmpty(preUrl)) {
            String msg = "preUrl is empty.";
            throw new Exception(msg);
        }
        wcbArg.getResponse().sendRedirect(preUrl);
    }

    public static String onclickActionToBack(WbfwWcbArgument wcbArg) throws Exception {
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, true, true);
        String preUrl = (String)httpSession.getAttribute(WbxConstants.SessionAttributeKey.preUrl.name());
        String onclickAction = WbfJslUtil.locationHref(preUrl);
        return onclickAction;
    }

    public static void addRow(BcTableModel tableModel, String name, String value) throws Exception {
        tableModel.addRow(Arrays.asList(name, ":" + HtmlConstants.HtmlSpecialCharacter.space.value, value));
    }

    public static String toPasswordForDosp(String pw) throws Exception {
        String start = null;
        if (BcStringUtil.length(pw) > 1) {
            start = pw.substring(0, 1);
        }
        int fillCnt = 8 - BcStringUtil.length(start);
        return BcStringUtil.fillSuffix(start, fillCnt, '*');
    }

    public static String simpleMessage(HtmlBuilder htmlBuilder, String title, String body, String option) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)htmlBuilder.div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(htmlBuilder.h(5, title));
        sb.append((CharSequence)htmlBuilder.div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append((CharSequence)htmlBuilder.div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        sb.append(htmlBuilder.p(body, true));
        sb.append((CharSequence)htmlBuilder.div(ExtwCssUtil.ExtwClass.extw_height_1rem.className));
        if (!BcStringUtil.isEmpty(option)) {
            sb.append(option);
        }
        sb = MdlCreator.getInstance().grid_cell(6, sb);
        sb = MdlCreator.getInstance().grid_portfolio(sb);
        return sb.toString();
    }

    public static String simpleMessage(HtmlBuilder htmlBuilder, String title, String body) throws Exception {
        return XwebUtil.simpleMessage(htmlBuilder, title, body, null);
    }

    public static void validateEmailAddress(String emailAddress, List msgList) throws Exception {
        if (!BcMailUtil.checkEmailAddress(emailAddress)) {
            msgList.add("E\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306e\u66f8\u5f0f\u304c\u59a5\u5f53\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
    }

    public static void validateEmailAddress(XsysValidationResult validationResult, String inputName, String emailAddress) throws Exception {
        if (!BcMailUtil.checkEmailAddress(emailAddress)) {
            validationResult.addFieldError(inputName, "E\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u306e\u66f8\u5f0f\u304c\u59a5\u5f53\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
    }

    public static String toElementName(String className, String fieldName, boolean isArray) {
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append('.');
        sb.append(fieldName);
        if (isArray) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static String toElementName(Class clazz, Enum fieldName, boolean isArray) {
        return XwebUtil.toElementName(clazz.getSimpleName(), fieldName.name(), isArray);
    }

    public static void putToMap(Map map, Class clazz, Object value) {
        map.put(clazz.getName(), value);
    }

    public static void putToMap(Map map, Object value) {
        XwebUtil.putToMap(map, value.getClass(), value);
    }

    public static <T> T getMapValue(Map map, Class clazz) {
        return (T)map.get(clazz.getName());
    }

    public static <T> T of(Object value) {
        return (T)value;
    }

    public static String readTextFile(InputStream is) throws Exception {
        return BcStreamUtil.readAsString(is, BcConstants.charset);
    }

    public static String readTextFile(File file) throws Exception {
        BcFileUtil.notEexistsException(file);
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        return XwebUtil.readTextFile(is);
    }

    public static XsysValidationResult getValidationResult(WbfwWcbArgument wcbArg) throws Exception {
        WbfwRequestParameter requestParameter = wcbArg.getRequestParameter();
        String validationId = requestParameter.getAsString(WbxConstants.SessionAttributeKey.validationId.name());
        BcLogUtil.debug("validationId=" + validationId);
        if (BcStringUtil.isEmpty(validationId)) {
            return null;
        }
        HttpSession httpSession = WbfwUtil.getSession(wcbArg, false, true);
        XsysValidationResult validationResult = (XsysValidationResult)XwebUtil.getAttribute1(httpSession, WbxConstants.SessionAttributeKey.validationId);
        if (validationResult == null) {
            throw new Exception("\u691c\u8a3c\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        if (!validationId.equals(validationResult.id)) {
            throw new Exception("\u691c\u8a3cID\u304c\u4e0d\u6b63\u3067\u3059\u3002");
        }
        return validationResult;
    }

    public static String getSuffix(String src, String target) {
        int index = src.indexOf(target);
        return src.substring(index + target.length());
    }

    public static String toEmenetId(String src) {
        return String.valueOf(src) + "__eid";
    }

    public static String toDataListId(String src) {
        return String.valueOf(src) + "__datalist";
    }

    public static EtcPagination cretaePagination(WbfwWcbArgument wcbArg) throws Exception {
        WbfwRequestParameter requestParameter = wcbArg.getRequestParameter();
        String page = requestParameter.getAsString(WbxConstants.SessionAttributeKey.page.name());
        BcLogUtil.debug("page=" + page);
        EtcPagination pagination = new EtcPagination();
        pagination.setPageNumReq(BcNumberUtil.parseInteger(page, -1));
        return pagination;
    }

    public static String cretaeBbreadcrumbs(WbfwWcbArgument wcbArg, WbxPath ... xwebPaths) throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < xwebPaths.length) {
            WbxPath wbxPath = xwebPaths[i];
            ++i;
        }
        return sb.toString();
    }

    public static boolean hasFunction(WbfSiteContext siteContext, String element) throws Exception {
        String siteFunction = siteContext.propertyMap.get(WbxConstants.SitePropertyKey.function.name());
        return EtcEnumStrUtil.contains(siteFunction, element);
    }

    public static boolean hasFunction(WbfSiteContext siteContext, Enum aEnum) throws Exception {
        return XwebUtil.hasFunction(siteContext, aEnum.name());
    }

    public static CmsvMessage createMail(WbfSiteContext siteContext) throws Exception {
        CmsvMessage wbs1Mail = new CmsvMessage();
        BcLogUtil.debug("####### createMail:siteContext.mailSenderAddresse=" + siteContext.mailSenderAddress);
        wbs1Mail.from = siteContext.mailSenderAddress;
        wbs1Mail.personal = siteContext.mailSenderPersonal;
        return wbs1Mail;
    }

    public static CmsvMessage addMailToQueue(WbfwWcbArgument wcbArg, DtsSession dtsSessionSite, String mailTo, String subject, String content) throws Exception {
        WbfSiteContext siteContext = wcbArg.getSiteContext();
        XwebMailContentHelper mailContentHelper = XwebMailContentHelper.getInstance();
        CmsvMessage toWbs1Mail = XwebUtil.createMail(siteContext);
        toWbs1Mail.to = mailTo;
        toWbs1Mail.subject = mailContentHelper.subject(siteContext.mailSubjectPrefix, subject);
        StringBuilder contentSb = new StringBuilder();
        contentSb.append(content);
        contentSb.append(mailContentHelper.temp2(wcbArg));
        toWbs1Mail.content = contentSb.toString();
        Wbs1ServerUtil.getInstance().addMailToQueue(dtsSessionSite, toWbs1Mail);
        return toWbs1Mail;
    }

    public static CmsvMessage addMailToQueue(WbfwWcbArgument wcbArg, DtsSession dtsSessionSite, long toPersonId, String subject, String content) throws Exception {
        PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
        Wbs1Account account = personManager.getAccountByPersonId(toPersonId);
        return XwebUtil.addMailToQueue(wcbArg, dtsSessionSite, account.loginId, subject, content);
    }

    public static String createAccountSummary(Wbs1Account account) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u500b\u4ebaID=" + account.personId);
        sb.append("\n\u500b\u4ebaID=" + account.nickname);
        sb.append("\n\u6027\u5225=" + account.sexCode);
        sb.append("\n\u62db\u5f85\u30b3\u30fc\u30c9=" + account.inviteCode);
        return sb.toString();
    }
}

