/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.util.ArrayList;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil;
import jp.co.extreme.base.core.BcUnicode;
import jp.co.extreme.base.util.BcPair;
import jp.co.extreme.html.common.HtmlBuilder;
import jp.co.extreme.module.wbfw.container.WbfwWcbArgument;
import jp.co.extreme.module.wbs1.common.Wbs1Constants;
import jp.co.extreme.module.wbs1.common.Wbs1Words;
import jp.co.extreme.module.wbs1.model.Wbs1Account;
import jp.co.extreme.module.wbs1.model.Wbs1JudgementGetter;
import jp.co.extreme.module.wbs1.model.Wbs1JudgementSetter;
import jp.co.extreme.module.wbs1.model.WbsJudgementCondition;
import jp.co.extreme.module.wbs1.server.PersonManager;
import jp.co.extreme.module.xdts.wcb.XdsSearchUtil;

public final class XwebJudgementUtil {
    private XwebJudgementUtil() {
    }

    public static String createJudgementCondition(HtmlBuilder htmlBuilder, String judgementStatusStr) throws Exception {
        ArrayList<BcPair<Integer, String>> pairList = new ArrayList<BcPair<Integer, String>>();
        Wbs1Constants.JudgementStatus[] judgementStatusArray = Wbs1Constants.JudgementStatus.values();
        int n = judgementStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            Wbs1Constants.JudgementStatus judgementStatus = judgementStatusArray[n2];
            BcPair<Integer, String> pair = new BcPair<Integer, String>(judgementStatus.id, judgementStatus.nameJp);
            pairList.add(pair);
            ++n2;
        }
        return XdsSearchUtil.createCondition(htmlBuilder, WbsJudgementCondition.FieldName.judgementStatusId.fieldName, pairList, judgementStatusStr, "\u3010" + Wbs1Words.getInstance().\u5224\u5b9a\u72b6\u614b + "\u3011");
    }

    public static void judgementSet(Wbs1JudgementGetter judgementGetter, Wbs1JudgementSetter judgementSetter) {
        judgementSetter.setJudgementDatetime(judgementGetter.getJudgementDatetime());
        judgementSetter.setJudgementStatusId(judgementGetter.getJudgementStatusId());
        judgementSetter.setJudgementReason(judgementGetter.getJudgementReason());
    }

    public static String createJudgementHtml(HtmlBuilder htmlBuilder, Wbs1JudgementGetter judgementGetter, WbfwWcbArgument wcbArg, long judgementPersonId) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(htmlBuilder.div_start());
        String judgementDatetimeStr = BcStringUtil.fill(BcUnicode.HALFWIDTH_KATAKANA_MIDDLE_DOT.char_, "yyyy/MM/dd HH:mm:ss".length());
        if (judgementGetter.getJudgementDatetime() != null) {
            judgementDatetimeStr = BcTimeUtil.toString(judgementGetter.getJudgementDatetime(), "yyyy/MM/dd HH:mm:ss");
        }
        sb.append("\u5224\u5b9a\u65e5\u6642: " + judgementDatetimeStr);
        sb.append(htmlBuilder.space(2));
        Wbs1Constants.JudgementStatus judgementStatus = Wbs1Constants.JudgementStatus.getById(judgementGetter.getJudgementStatusId());
        sb.append(htmlBuilder.space(1));
        sb.append("\u5224\u5b9a: " + judgementStatus.nameJp);
        sb.append(htmlBuilder.space(2));
        PersonManager personManager = PersonManager.getInstance(wcbArg.getSiteContext().getDataSourceName());
        Wbs1Account account = personManager.getAccountByPersonId(judgementPersonId);
        StringBuilder judge = new StringBuilder();
        if (account != null) {
            judge.append(account.nickname);
            judge.append("(ID=" + account.personId + ")");
        }
        sb.append("\u5224\u5b9a\u8005: " + judge);
        sb.append(htmlBuilder.br());
        sb.append(htmlBuilder.span("\u5224\u5b9a\u7406\u7531: " + BcStringUtil.toNotNull(judgementGetter.getJudgementReason()), true));
        sb.append(htmlBuilder.div_end());
        return sb.toString();
    }
}

