/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xweb.common;

import java.util.Calendar;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.core.BcTimeUtil_JP;
import jp.co.extreme.base.log.BcLoggableObject;
import jp.co.extreme.html.common.HtmlGlobalAttribute;
import jp.co.extreme.module.xweb.common.MonthCalendar;
import jp.co.extreme.module.xweb.common.XwebHtmlBuilder;

public class CalendarTableCreator
extends BcLoggableObject {
    protected XwebHtmlBuilder htmlBuilder;

    public void setHtmlBuilder(XwebHtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    public StringBuilder create(int year, int month) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.tableStart());
        InnerMonthCalendar monthCalendar = new InnerMonthCalendar();
        StringBuilder calendarHtml = monthCalendar.create(year, month);
        sb.append((CharSequence)calendarHtml);
        sb.append(this.htmlBuilder.table_end());
        return sb;
    }

    protected StringBuilder tableStart() throws Exception {
        StringBuilder sb = new StringBuilder();
        HtmlGlobalAttribute globalAttribute = new HtmlGlobalAttribute();
        globalAttribute.clazz = "calendar";
        sb.append(this.htmlBuilder.table_start(globalAttribute, "100%", null, 0, 0, 0, null));
        return sb;
    }

    protected String createDateLabelCell(Calendar calendar, int targetMonth) throws Exception {
        StringBuilder sb = new StringBuilder();
        String cssClass = "calendar_date_label";
        if (calendar.get(7) == 7) {
            cssClass = String.valueOf(cssClass) + " saturday";
        } else if (calendar.get(7) == 1) {
            cssClass = String.valueOf(cssClass) + " sunday";
        }
        sb.append(this.htmlBuilder.tableCell(-1, -1, cssClass));
        String cellValue = this.createDateLabelCellValue(calendar, targetMonth);
        BcStringUtil.append(sb, cellValue);
        sb.append(this.htmlBuilder.td_end());
        return sb.toString();
    }

    protected String createDateLabelCellValue(Calendar calendar, int targetMonth) throws Exception {
        StringBuilder sb = new StringBuilder();
        int month = calendar.get(2) + 1;
        if (month != targetMonth) {
            sb.append(Integer.toString(month));
            sb.append("/");
        }
        sb.append(Integer.toString(calendar.get(5)));
        return sb.toString();
    }

    protected String createDateNoteCell(Calendar calendar) throws Exception {
        StringBuilder sb = new StringBuilder();
        String cssClass = "calendar_date_body";
        if (calendar.get(7) == 7) {
            cssClass = String.valueOf(cssClass) + " saturday";
        } else if (calendar.get(7) == 1) {
            cssClass = String.valueOf(cssClass) + " sunday";
        }
        sb.append(this.htmlBuilder.tableCell(-1, -1, cssClass));
        String cellValue = this.createDateNoteCellValue(calendar);
        BcStringUtil.append(sb, cellValue);
        sb.append(this.htmlBuilder.td_end());
        return sb.toString();
    }

    protected String createDateNoteCellValue(Calendar calendar) throws Exception {
        return null;
    }

    class InnerMonthCalendar
    extends MonthCalendar {
        StringBuilder sb;

        public StringBuilder create(int year, int month) throws Exception {
            this.sb = new StringBuilder();
            this.start(year, month);
            return this.sb;
        }

        @Override
        protected void week(int colmnId, int weekId) throws Exception {
            String cssClass = "week_index";
            this.sb.append(CalendarTableCreator.this.htmlBuilder.th(1, 1, cssClass));
            this.sb.append(BcTimeUtil_JP.toDayOfWeekName(weekId));
            this.sb.append(CalendarTableCreator.this.htmlBuilder.th_end());
        }

        @Override
        protected void bodyStart() throws Exception {
            this.sb.append(CalendarTableCreator.this.htmlBuilder.tbody_start());
        }

        @Override
        protected void weekStart(boolean isHeader) throws Exception {
            if (isHeader) {
                this.sb.append(CalendarTableCreator.this.htmlBuilder.thead_start());
            }
            this.sb.append(CalendarTableCreator.this.htmlBuilder.tr_start());
        }

        @Override
        protected void dateLabel(int rowId, int colmnId, Calendar calendar) throws Exception {
            this.sb.append(CalendarTableCreator.this.createDateLabelCell(calendar, this.month));
        }

        @Override
        protected void dateValue(int rowId, int colmnId, Calendar calendar) throws Exception {
            this.sb.append(CalendarTableCreator.this.createDateNoteCell(calendar));
        }

        @Override
        protected void weekEnd(boolean isHeader) throws Exception {
            this.sb.append(CalendarTableCreator.this.htmlBuilder.tr_end());
            if (isHeader) {
                this.sb.append(CalendarTableCreator.this.htmlBuilder.thead_end());
            }
        }

        @Override
        protected void bodyEnd() throws Exception {
            this.sb.append(CalendarTableCreator.this.htmlBuilder.tbody_end());
        }
    }
}

