/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.image.Image;
import jp.co.extreme.base.core.BcStringUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.module.xsod.common.XsodUtil;

public class FxxImageCash {
    private Map<String, Image> imageMap = new HashMap<String, Image>();

    private FxxImageCash() {
    }

    public static FxxImageCash getInstance() throws Exception {
        return SingletonHolder.instance;
    }

    public Image getImage(String fileName) throws Exception {
        BcLogUtil.debug("getImage:fileName=" + fileName);
        if (BcStringUtil.isEmpty(fileName)) {
            return null;
        }
        Image image = this.imageMap.get(fileName);
        if (image != null) {
            return image;
        }
        File file = new File(XsodUtil.getImageDir(), fileName);
        BcLogUtil.debug("file=" + file.getPath());
        if (!file.exists()) {
            BcLogUtil.debug("Not found. file=" + file.getPath());
            return null;
        }
        if (file.length() <= 0L) {
            BcLogUtil.debug("\u30d5\u30a1\u30a4\u30eb\u306e\u30b5\u30a4\u30ba\u304c\u30bc\u30ed\u3067\u3059\u3002 file=" + file.getPath());
            return null;
        }
        FileInputStream is = new FileInputStream(file);
        image = new Image((InputStream)is);
        this.imageMap.put(fileName, image);
        return image;
    }

    public Image getImageNI(String fileName) throws Exception {
        Image image = this.getImage(fileName);
        if (image != null) {
            return image;
        }
        image = this.getImage("no_image.png");
        return image;
    }

    /* synthetic */ FxxImageCash(FxxImageCash fxxImageCash) {
        this();
    }

    private static final class SingletonHolder {
        private static final FxxImageCash instance = new FxxImageCash(null);

        private SingletonHolder() {
        }
    }
}

