/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xsod.common;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.model.XfilUriEntity;

class FileVisitor1
extends SimpleFileVisitor<Path> {
    List<XfilUriEntity> uriEntityList;

    public FileVisitor1(List<XfilUriEntity> uriEntityList) {
        this.uriEntityList = uriEntityList;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
        try {
            XfilUriEntity uriEntity = XfilUtil.toUriEntity(path, true);
            this.uriEntityList.add(uriEntity);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path path, IOException ex) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path path, IOException ex) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

