/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.swg;

import java.awt.Desktop;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Comparator;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.Parent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jp.co.extreme.awt.AwtImageHelper;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.table.BcTableColumn;
import jp.co.extreme.base.table.BcTableModel;
import jp.co.extreme.base.table.BcTableUtil;
import jp.co.extreme.base.util.BcGeneralComparator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xfil.common.XfilConstants;
import jp.co.extreme.module.xfil.common.XfilUtil;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.fx.XfilConditionSet;
import jp.co.extreme.module.xfil.fx.XfilFxHelper;
import jp.co.extreme.module.xfil.model.XfilAnalysisCondition;
import jp.co.extreme.module.xfil.rmo.XfilUriEntityListRMO;
import jp.co.extreme.module.xfil.stub.XfilUriEntityStub;
import jp.co.extreme.module.xfil.swg.XfilTableCellRendererDuration;
import jp.co.extreme.module.xfil.swg.XfilTableCellRendererFileSize;
import jp.co.extreme.module.xfil.swg.XfilTagCellEditor;
import jp.co.extreme.module.xfil.swg.XfilTagCellRenderer;
import jp.co.extreme.module.xfil.swg.XfilThumbnailCellRenderer;
import jp.co.extreme.rmi.model.RmiRequest;
import jp.co.extreme.scf3.client.ScfTableLoadTask;
import jp.co.extreme.scf5.swg.IswgAbstractDataViewPanel;
import jp.co.extreme.scf5.swg.IswgLoadableTablePanel;
import jp.co.extreme.scf6.swg.JswgAbstractDataViewPanel_FxCondition;
import jp.co.extreme.swing.SwgButton;
import jp.co.extreme.swing.SwgOptionPane;
import jp.co.extreme.swing.SwgTableView;
import jp.co.extreme.swing.SwgTableViewUtil;
import jp.co.extreme.swing.SwgUtil;
import jp.co.extreme.swing.SwgxTableUtil;

public class XfilFileIndexListPanel
extends JswgAbstractDataViewPanel_FxCondition {
    XfilAnalysisCondition analysisCondition;

    public XfilFileIndexListPanel() throws Exception {
        super(IswgAbstractDataViewPanel.DataViewStyle.Default);
        Parent conditionNode = this.createConditionNode(-1, null);
        this.setConditionNode(conditionNode);
    }

    @Override
    public String getTitle() throws Exception {
        return XfilWords.getInstance().indexList.toPlain();
    }

    @Override
    protected Parent createConditionNode(int tabIndex, Node preConditionNode) throws Exception {
        InnerConditionPane conditionPane = new InnerConditionPane();
        XfilConditionSet conditionSet = conditionPane.conditionSet;
        conditionPane.addNodeUnit(conditionSet.indexGroupUnit);
        conditionPane.addNodeUnit(conditionSet.crawlerUnit);
        conditionPane.addNodeUnit(conditionSet.keywordUnit);
        conditionPane.addNodeUnit(conditionSet.registrationPeriodUnit);
        conditionPane.addNodeUnit(conditionSet.missingOnlyUnit);
        conditionPane.addNodeUnit(conditionSet.registrationDateTimeColumnUnit);
        conditionPane.addNodeUnit(conditionSet.resolutionColumnUnit);
        conditionPane.addNodeUnit(conditionSet.fileAttributeColumnUnit);
        if (preConditionNode != null) {
            InnerConditionPane preConditionPane = (InnerConditionPane)preConditionNode;
            conditionSet.setConditionSet(preConditionPane.conditionSet);
        }
        FxUtil.defaultInitialize((Node)conditionPane);
        return conditionPane;
    }

    @Override
    protected BcResult validateCondition() throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        this.analysisCondition = conditionPane.conditionSet.getCondition();
        BcResult result = new BcResult();
        return result;
    }

    @Override
    protected RmiRequest createRequest() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(XfilUriEntityListRMO.class.getName());
        rmiReq.setMethodName(XfilUriEntityListRMO.Method.list.getMethodName());
        rmiReq.addData(this.analysisCondition);
        return rmiReq;
    }

    @Override
    public IswgLoadableTablePanel createTablePanel() throws Exception {
        InnerTablePanel tablePanel = new InnerTablePanel();
        return tablePanel;
    }

    @Override
    public int getDividerLocation() throws Exception {
        return 180;
    }

    @Override
    protected Image getIconImage() throws Exception {
        return AwtImageHelper.getImage("table_view_64x64.png");
    }

    public void setCrawlSessionId(long crawId) throws Exception {
        InnerConditionPane conditionPane = (InnerConditionPane)this.getConditionNode();
        XfilConditionSet conditionSet = conditionPane.conditionSet;
        conditionSet.setCrawlerId(crawId);
    }

    class InnerConditionPane
    extends FxFlowPane {
        XfilConditionSet conditionSet;

        public InnerConditionPane() throws Exception {
            super(11);
            this.conditionSet = new XfilConditionSet();
            this.conditionSet.fileCheckBox.setSelected(true);
            this.conditionSet.initIndexGroupUnit(true, false);
            this.conditionSet.initCrawlerUnit(true, null);
        }
    }

    class InnerTablePanel
    extends IswgLoadableTablePanel {
        List<List> rowList;
        Number entityId;
        int columnId_entityId;
        int columnId_thumbnail_files;
        int columnId_select;
        XfilThumbnailCellRenderer thumbnailCellRenderer;
        SwgButton openFileButton;
        SwgButton openDirectoryButton;
        SwgButton openThumbnailDirectoryButton;
        SwgButton editButton;
        SwgButton deleteButton;
        SwgButton selectAllButton;
        SwgButton releaseAllButton;
        boolean isOk;

        public InnerTablePanel() throws Exception {
            this.openFileButton = SwgUtil.createOpenButton(XfilWords.getInstance().openByAssociatedApplication.toPlain(), null);
            this.openDirectoryButton = SwgUtil.createOpenDirectoryButton();
            this.openThumbnailDirectoryButton = SwgUtil.createOpenDirectoryButton(XfilWords.getInstance().openThumbnailDirectory.toPlain(), null);
            this.editButton = SwgUtil.createOpenDirectoryButton(BcWords.getInstance().edit, null);
            this.deleteButton = SwgUtil.createDeleteButton();
            this.selectAllButton = SwgUtil.createSelectAllBbutton();
            this.releaseAllButton = SwgUtil.createReleaseAllButton();
            this.isOk = false;
            this.setVisualSaveEnavled(true);
            this.openFileButton.addActionListener(this.actionListener);
            this.openFileButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.openFileButton);
            this.openDirectoryButton.addActionListener(this.actionListener);
            this.openDirectoryButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.openDirectoryButton);
            this.openThumbnailDirectoryButton.addActionListener(this.actionListener);
            this.openThumbnailDirectoryButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.openThumbnailDirectoryButton);
            this.deleteButton.addActionListener(this.actionListener);
            this.deleteButton.setEnabled(false);
            this.tableControlPanel.addControl3(this.deleteButton);
            if (this.isOk) {
                this.editButton.addActionListener(this.actionListener);
                this.editButton.setEnabled(false);
                this.tableControlPanel.addControl3(this.editButton);
                this.selectAllButton.addActionListener(this.actionListener);
                this.selectAllButton.setEnabled(false);
                this.tableControlPanel.addControl3(this.selectAllButton);
                this.releaseAllButton.addActionListener(this.actionListener);
                this.releaseAllButton.setEnabled(false);
                this.tableControlPanel.addControl3(this.releaseAllButton);
            }
        }

        @Override
        public void tableModelCreated(BcTableModel tableModel) throws Exception {
            this.columnId_entityId = tableModel.getTableColumnModel().getColumn(XfilConstants.xfil_entity.id.fullName()).getModelIndex();
            this.columnId_thumbnail_files = tableModel.getTableColumnModel().getColumn(XfilConstants.xfil_entity.thumbnail_files.fullName()).getModelIndex();
            int columnId_image_files = tableModel.getTableColumnModel().getColumn(XfilConstants.xfil_entity.image_files.fullName()).getModelIndex();
            BcTableColumn tableColumn = tableModel.getTableColumnModel().getColumn(XfilConstants.xfil_entity.size_.fullName());
            XfilTableCellRendererFileSize tableCellRendererFileSize = new XfilTableCellRendererFileSize();
            tableColumn.setCellRenderer(tableCellRendererFileSize);
            tableColumn = tableModel.getTableColumnModel().getColumn(XfilConstants.xfil_entity.duration_millis.fullName());
            XfilTableCellRendererDuration tableCellRendererDuration = new XfilTableCellRendererDuration();
            tableColumn.setCellRenderer(tableCellRendererDuration);
            tableColumn = (BcTableColumn)tableModel.getTableColumnModel().getColumn(this.columnId_thumbnail_files);
            this.thumbnailCellRenderer = new XfilThumbnailCellRenderer();
            this.thumbnailCellRenderer.columnId_entityId = this.columnId_entityId;
            this.thumbnailCellRenderer.columnId_image_files = columnId_image_files;
            tableColumn.setCellRenderer(this.thumbnailCellRenderer);
            tableColumn = (BcTableColumn)tableModel.getTableColumnModel().getColumn(columnId_image_files);
            tableColumn.setVisible(false);
            tableColumn = tableModel.getTableColumnModel().getColumn(XfilConstants.xfil_entity.tag.fullName());
            tableColumn.isEditable = true;
            XfilTagCellRenderer tagCellRenderer = new XfilTagCellRenderer();
            tableColumn.setCellRenderer(tagCellRenderer);
            XfilTagCellEditor tagCellEditor = new XfilTagCellEditor();
            tagCellEditor.columnId_entityId = this.columnId_entityId;
            tableColumn.setCellEditor(tagCellEditor);
            super.tableModelCreated(tableModel);
        }

        @Override
        protected SwgTableView createTableView(BcTableModel tableModel) throws Exception {
            InnerTableView tableView = new InnerTableView(tableModel, tableModel.getTableColumnModel());
            SwgTableViewUtil.setHeaderRowCount(tableView.getTableHeader(), 3.0);
            tableView.setRowHeight(SwgTableViewUtil.ROW_HEIGHT * 3);
            tableView.columnId_thumbnail_files = this.columnId_thumbnail_files;
            tableView.ThumbnailCellRenderer = this.thumbnailCellRenderer;
            return tableView;
        }

        @Override
        public void rowListReceived(ScfTableLoadTask tableLoadTask, List<List> rowList) throws Exception {
            SwgxTableUtil.addBoolean(rowList, false);
            super.rowListReceived(tableLoadTask, rowList);
        }

        @Override
        protected void tableSelectionChanged(ListSelectionEvent ev) throws Exception {
            super.tableSelectionChanged(ev);
            if (!ev.getValueIsAdjusting()) {
                SwgTableView tableView = this.getTableView();
                this.openFileButton.setEnabled(false);
                this.openDirectoryButton.setEnabled(false);
                this.openThumbnailDirectoryButton.setEnabled(false);
                this.editButton.setEnabled(false);
                this.deleteButton.setEnabled(false);
                if (tableView.getSelectedRows().length > 0) {
                    this.rowList = SwgTableViewUtil.getRowList(tableView, tableView.getSelectedRows(), XfilConstants.xfil_entity.id.fullName(), XfilConstants.xfil_entity.index_group_id.fullName(), XfilConstants.xfil_entity.directory_.fullName(), XfilConstants.xfil_entity.name_.fullName());
                    this.deleteButton.setEnabled(true);
                }
                if (tableView.getSelectedRows().length == 1) {
                    this.entityId = (Number)this.rowList.get(0).get(0);
                    this.openFileButton.setEnabled(true);
                    this.openDirectoryButton.setEnabled(true);
                    this.openThumbnailDirectoryButton.setEnabled(true);
                    this.editButton.setEnabled(true);
                }
            }
        }

        @Override
        protected void tableMouseClicked(MouseEvent ev) throws Exception {
            super.tableMouseClicked(ev);
            if (ev.getClickCount() != 2) {
                return;
            }
        }

        @Override
        protected void actionPerformed2(ActionEvent ev) throws Exception {
            super.actionPerformed2(ev);
            if (ev.getSource() == this.openFileButton || ev.getSource() == this.openDirectoryButton) {
                String directory = (String)this.rowList.get(0).get(2);
                String fileName = (String)this.rowList.get(0).get(3);
                boolean isFile = ev.getSource() == this.openFileButton;
                this.openFile(directory, fileName, isFile);
            } else if (ev.getSource() == this.openThumbnailDirectoryButton) {
                Long entityId = (Long)this.rowList.get(0).get(this.columnId_entityId);
                this.openThumbnailDirectory(entityId);
            } else if (ev.getSource() == this.editButton) {
                Long uriEntityId = (Long)this.rowList.get(0).get(0);
                XfilFxHelper.getInstance().openUriEntityPane(uriEntityId);
            } else if (ev.getSource() == this.deleteButton) {
                List<List> rowList = SwgTableViewUtil.getSelectedRowList(this.getTableView(), this.columnId_entityId);
                List<Object> entityIdList1 = BcTableUtil.getValueList(rowList, this.columnId_entityId);
                String msg = String.format(BcWords.getInstance().Do_you_want_to_delete, new Object[0]);
                if (SwgOptionPane.showConfirmDialog(this, msg, BcWords.getInstance().confirmation, 0) == 0) {
                    List<Long> entityIdList2 = XfilUriEntityStub.getInstance().deleteEntities(entityIdList1);
                    BcTableModel tableModel = (BcTableModel)this.getTableView().getModel();
                    List<Integer> rowIndexList = BcTableUtil.getSameValueRowIndex((TableModel)tableModel, this.columnId_entityId, entityIdList2, (Comparator)BcGeneralComparator.getInstance());
                    int[] rowIndexes = BcNumberUtil.toIntArray(rowIndexList);
                    tableModel.removeRows(rowIndexes);
                }
            } else if (ev.getSource() == this.selectAllButton) {
                SwgTableViewUtil.setValueAllRowAtModel(this.getTableView(), true, this.columnId_select);
            } else if (ev.getSource() == this.releaseAllButton) {
                SwgTableViewUtil.setValueAllRowAtModel(this.getTableView(), false, this.columnId_select);
            }
        }

        protected void openFile(String directory, String fileName, boolean isFile) throws Exception {
            File dir = new File(directory);
            File file = new File(dir, fileName);
            if (isFile) {
                if (!file.exists()) {
                    String msg = BcWords.getInstance().File_does_not_exists("file=" + file.getPath());
                    SwgOptionPane.showMessageDialog(this, msg, BcWords.getInstance().error, 0);
                    return;
                }
                Desktop.getDesktop().open(file);
            } else {
                if (!file.getParentFile().exists()) {
                    BcWords.getInstance().File_does_not_exists(file.getParentFile().getPath());
                    String msg = BcWords.getInstance().File_does_not_exists(file.getPath());
                    SwgOptionPane.showMessageDialog(this, msg, BcWords.getInstance().error, 0);
                    return;
                }
                Desktop.getDesktop().open(file.getParentFile());
            }
        }

        protected void openThumbnailDirectory(long entityId) throws Exception {
            File dir = XfilUtil.getThumbnailsDir(entityId);
            Desktop.getDesktop().open(dir);
        }
    }

    class InnerTableView
    extends SwgTableView {
        int columnId_thumbnail_files;
        XfilThumbnailCellRenderer ThumbnailCellRenderer;
        BufferedImage bufferedImage1;

        public InnerTableView(TableModel tableModel, TableColumnModel tableColumnModel) throws Exception {
            super(tableModel, tableColumnModel);
            this.addMouseMotionListener(new MouseAdapter(){

                @Override
                public void mouseMoved(MouseEvent ev) {
                    InnerTableView.this.mouseMotionEvent(ev);
                }
            });
        }

        protected void mouseMotionEvent(MouseEvent ev) {
            try {
                switch (ev.getID()) {
                    case 503: {
                        this.mouseMoved(ev);
                    }
                }
            }
            catch (Exception ex) {
                this.exceptionHandle(ex);
            }
        }

        protected void mouseMoved(MouseEvent ev) throws Exception {
            Point point = ev.getPoint();
            int rowIndex = this.rowAtPoint(point);
            if (rowIndex < 0) {
                return;
            }
            int columnIndex = this.columnAtPoint(point);
            BcTableModel tableModel = (BcTableModel)this.getModel();
            int rowId = tableModel.toRowId(rowIndex);
            int columnId = tableModel.getTableColumnModel().toModelIndex(columnIndex);
            if (columnId == this.columnId_thumbnail_files) {
                Rectangle cellRectangle = this.getCellRect(rowIndex, columnIndex, false);
                Object[] res = this.ThumbnailCellRenderer.getImage(this, rowId, point, cellRectangle);
                BufferedImage bufferedImage2 = null;
                Rectangle rectangle2 = null;
                if (res != null) {
                    bufferedImage2 = (BufferedImage)res[0];
                    rectangle2 = (Rectangle)res[1];
                }
                boolean b = false;
                if (bufferedImage2 != null) {
                    b = this.bufferedImage1 != null ? bufferedImage2.hashCode() != this.bufferedImage1.hashCode() : true;
                } else {
                    boolean bl = b = this.bufferedImage1 != null;
                }
                if (b) {
                    double ratio = 1.0;
                    Point2D.Double pointWk1 = null;
                    if (bufferedImage2 != null) {
                        pointWk1 = new Point2D.Double();
                        pointWk1.x = (double)rectangle2.x - ((double)bufferedImage2.getWidth() * ratio - rectangle2.getWidth()) / 2.0;
                        pointWk1.y = (double)rectangle2.y - (double)bufferedImage2.getHeight() * ratio - 2.0;
                    }
                    XfilFxHelper.getInstance().openImagePane(bufferedImage2, ratio, pointWk1);
                }
                this.bufferedImage1 = bufferedImage2;
            } else {
                XfilFxHelper.getInstance().closeImagePane();
            }
        }
    }
}

