/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxNumberField;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.scene.FxScene;
import jp.co.extreme.fx.stage.FxStage;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.xfil.common.XfilWords;
import jp.co.extreme.module.xfil.fx.XfilFxHelper;
import jp.co.extreme.module.xfil.model.XfilIndexGroup;
import jp.co.extreme.module.xfil.stub.XfilIndexGroupStub;
import jp.co.extreme.module.xsys.validation.XsysValidator;

public class XfilIndexGroupPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxNumberField idField = new FxNumberField(-1, 0, false);
    FxTextField nameField = new FxTextField();
    FxTextField noteField = new FxTextField();
    FxButton completionButton = FxUtil.createCompletionButton();
    FxButton cancelButton = FxUtil.createCancelButton();
    XfilIndexGroup indexGroup;
    Stage stage;

    public XfilIndexGroupPane() throws Exception {
        this.completionButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.completionButton);
        this.cancelButton.setOnAction(this.actionEventHandler);
        this.getControlPane().addControl((Node)this.cancelButton);
        this.idField.setEditable(false);
        this.idField.setPrefColumnCount(6);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().id), new Node[]{this.idField});
        this.centerPane.addNodeUnit(controlUnit);
        this.nameField.setPrefColumnCount(80);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().name), new Node[]{this.nameField});
        this.centerPane.addNodeUnit(controlUnit);
        this.noteField.setPrefColumnCount(80);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().note), new Node[]{this.noteField});
        this.centerPane.addNodeUnit(controlUnit);
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setData(XfilIndexGroup indexGroup) throws Exception {
        this.indexGroup = indexGroup;
        this.idField.setValue(indexGroup.id);
        this.nameField.setText(indexGroup.name);
        this.noteField.setText(indexGroup.note);
    }

    protected void storeData(XfilIndexGroup indexGroup) throws Exception {
        indexGroup.id = this.idField.getBigDecimal().longValue();
        indexGroup.name = this.nameField.getText();
        indexGroup.note = this.noteField.getText();
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            this.storeData(this.indexGroup);
            XsysValidator validator = XsysValidator.getInstance();
            BcResult result1 = validator.validateForGui(this.indexGroup);
            if (result1.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result1.getErrorList());
                FxOptionPane.showMessageDialog((Node)this, (Object)msg, BcWords.getInstance().warning, 2);
                return;
            }
            XfilIndexGroupStub.getInstance().put(this.indexGroup);
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
        XfilFxHelper.getInstance().remove(((Object)((Object)this)).getClass(), this.indexGroup.id);
    }

    public void show(long entityId) throws Exception {
        XfilIndexGroup indexGroup = null;
        indexGroup = entityId > 0L ? (XfilIndexGroup)XfilIndexGroupStub.getInstance().get(entityId) : new XfilIndexGroup();
        this.setData(indexGroup);
        this.stage = new FxStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(800.0);
        this.stage.setHeight(320.0);
        this.stage.setResizable(false);
        this.stage.setTitle(XfilWords.getInstance().indexGroup.toPlain());
        FxImageHelper.setStageIcon(this.stage);
        this.stage.show();
    }
}

