/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableValue;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.fx.table.FxTableCellValueFactory;
import jp.co.extreme.fx.table.FxTableColumn;
import jp.co.extreme.module.xfil.model.XfilUriEntity;

public class XfilFileCellValueFactory
extends FxTableCellValueFactory {
    int mode;

    public XfilFileCellValueFactory(int mode) {
        this.mode = mode;
    }

    @Override
    public ObservableValue getCellValue(FxTableColumn tableColumn, Object item) {
        XfilUriEntity uriEntity = (XfilUriEntity)item;
        Object value = null;
        switch (this.mode) {
            case 1: {
                value = this.getCellValue1(tableColumn, uriEntity);
                break;
            }
            case 2: {
                value = this.getCellValue2(tableColumn, uriEntity);
            }
        }
        return new ReadOnlyObjectWrapper(value);
    }

    protected Object getCellValue1(FxTableColumn tableColumn, XfilUriEntity uriEntity) {
        Object value = null;
        switch (tableColumn.index) {
            case 0: {
                value = this.createPath(uriEntity);
                break;
            }
            case 1: {
                value = uriEntity.name;
                break;
            }
            case 2: {
                try {
                    value = BcNumberUtil.toString(uriEntity.size);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                break;
            }
            case 3: {
                value = uriEntity.extention;
                break;
            }
            case 4: {
                value = uriEntity.short01;
            }
        }
        return value;
    }

    public Object getCellValue2(FxTableColumn tableColumn, XfilUriEntity uriEntity) {
        Object value = null;
        switch (tableColumn.index) {
            case 0: {
                value = uriEntity.name;
                break;
            }
            case 1: {
                try {
                    value = BcNumberUtil.toString(uriEntity.size);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
                break;
            }
            case 2: {
                value = uriEntity.childCount;
            }
        }
        return value;
    }

    protected StringBuilder createPath(XfilUriEntity uriEntity) {
        StringBuilder sb = new StringBuilder();
        sb.append(uriEntity.directory);
        return sb;
    }
}

