/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xfil.fx;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.module.xfil.model.XfilAnalysisCondition;
import jp.co.extreme.module.xfil.model.XfilAnalysisResult;
import jp.co.extreme.module.xfil.model.XfilUriEntity;
import jp.co.extreme.task.TskAbstractCallable;

public class XfilFileAnalyzeTask
extends TskAbstractCallable {
    public XfilAnalysisCondition analysisCondition;
    List<XfilUriEntity> uriEntityList;
    public XfilAnalysisResult analysisResult;
    List<XfilUriEntity> uriEntityList2 = new ArrayList<XfilUriEntity>();
    public List<String> deleteExtentionLIst = new ArrayList<String>();
    String[] suffixs = new String[]{"_t", "-thumb"};
    int directoryCnt;
    int fileCnt;
    FileVisitor<Path> fileVisitor = new SimpleFileVisitor<Path>(){

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
            return XfilFileAnalyzeTask.this.preVisitDirectory(path, attrs);
        }

        @Override
        public FileVisitResult postVisitDirectory(Path path, IOException ex) throws IOException {
            return XfilFileAnalyzeTask.this.postVisitDirectory(path, ex);
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            return XfilFileAnalyzeTask.this.visitFile(path, attrs);
        }

        @Override
        public FileVisitResult visitFileFailed(Path path, IOException ex) throws IOException {
            return super.visitFileFailed(path, ex);
        }
    };

    public Object taskProcess() throws Exception {
        Files.walkFileTree(this.analysisCondition.targerPath, this.fileVisitor);
        if (this.uriEntityList2.size() > 0) {
            this.uriEntityList2.clear();
        }
        return null;
    }

    protected FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
        ++this.directoryCnt;
        if (this.directoryCnt % 100 == 0) {
            BcLogUtil.debug("directoryCnt=" + this.directoryCnt);
        }
        if (path.getNameCount() == 2) {
            this.getLogger().debug("preVisitDirectory=" + path + " nameCount=" + path.getNameCount());
        }
        FileVisitResult fileVisitResult = FileVisitResult.SKIP_SUBTREE;
        String fileName = path.getFileName().toString();
        fileVisitResult = fileName.startsWith("_") ? FileVisitResult.SKIP_SUBTREE : FileVisitResult.CONTINUE;
        return fileVisitResult;
    }

    protected FileVisitResult postVisitDirectory(Path path, IOException ex) {
        FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
        try {
            File[] files;
            if (this.analysisCondition.emptyDirdel && (files = path.toFile().listFiles()).length == 0) {
                this.getLogger().info("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea=" + path + " \u30d5\u30a1\u30a4\u30eb\u6570=" + files.length);
                this.evacuation(path);
            }
            fileVisitResult = FileVisitResult.CONTINUE;
        }
        catch (Exception ex2) {
            this.getLogger().error(ex2);
        }
        return fileVisitResult;
    }

    protected FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
        ++this.fileCnt;
        if (this.fileCnt % 1000 == 0) {
            BcLogUtil.debug("fileCnt=" + this.fileCnt);
        }
        FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
        try {
            fileVisitResult = this.visitFile_L2(path, attrs);
        }
        catch (Exception ex) {
            this.getLogger().error("Error:path=" + path);
            this.getLogger().error(ex);
        }
        return fileVisitResult;
    }

    protected FileVisitResult visitFile_L2(Path path, BasicFileAttributes attrs) throws Exception {
        String fileBaseName;
        boolean doMove;
        FileVisitResult fileVisitResult = FileVisitResult.CONTINUE;
        String fileName = path.getFileName().toString();
        int idx = fileName.indexOf("?");
        if (idx >= 0) {
            Path newPath = Paths.get(path.getParent().toString(), fileName.substring(0, idx));
            this.getLogger().info("\u30d5\u30a1\u30a4\u30eb\u540d\u5909\u66f4:" + newPath.getFileName());
            Files.move(path, newPath, new CopyOption[0]);
            path = newPath;
        }
        if (!(doMove = this.isDelete(path)) && this.analysisCondition.minLenfth > 0L) {
            Files.size(path);
            long cfr_ignored_0 = this.analysisCondition.minLenfth;
        }
        if (!doMove && path.toString().indexOf("oldax.com") >= 0) {
            if (fileName.startsWith("preview")) {
                doMove = true;
            }
            if (path.getParent().getFileName().toString().equals("p")) {
                doMove = true;
            }
        }
        if (!doMove && path.toString().indexOf("metart.qruq.com") >= 0 && (fileName.startsWith("t") || fileName.startsWith("preview"))) {
            doMove = true;
        }
        if (!doMove) {
            int i = 0;
            while (i < this.suffixs.length) {
                String suffix = this.suffixs[i];
                doMove = this.isThumbnail_v3(path, suffix);
                if (doMove) break;
                ++i;
            }
        }
        if (!doMove && fileName.equals(fileBaseName = BcFileUtil.getBaseName(fileName))) {
            this.getLogger().info("\u62e1\u5f35\u5b50\u7121\u3057:path=" + path);
            doMove = true;
        }
        if (doMove) {
            this.evacuation(path);
        }
        return fileVisitResult;
    }

    public boolean isDelete(Path aPath) throws Exception {
        String extention1 = BcFileUtil.getExtention(aPath.getFileName().toString());
        int i = 0;
        while (i < this.deleteExtentionLIst.size()) {
            String extention2 = this.deleteExtentionLIst.get(i);
            if (extention2.equalsIgnoreCase(extention1)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isThumbnail_v3(Path aPath, String suffix) throws Exception {
        String fileBaseName;
        String fileName = aPath.getFileName().toString();
        if (fileName.equals(fileBaseName = BcFileUtil.getBaseName(fileName))) {
            return false;
        }
        if (fileBaseName.endsWith(suffix)) {
            String prefix = fileBaseName.substring(0, fileBaseName.length() - 1);
            this.getLogger().info("aPath=" + aPath + " prefix=" + prefix);
            Path parentPath = aPath.getParent();
            Path[] paths = (Path[])Files.list(parentPath).toArray(Path[]::new);
            int i = 0;
            while (i < paths.length) {
                Path tmpPath = paths[i];
                if (!tmpPath.equals(aPath) && tmpPath.getFileName().toString().startsWith(prefix) && Files.size(aPath) < Files.size(tmpPath)) {
                    this.getLogger().info("\u30b5\u30e0\u30cd\u30a4\u30eb");
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void evacuation(Path path) throws IOException {
        Path relativizePath = this.analysisCondition.targerPath.relativize(path);
        Path evacuationDisPath = Paths.get(this.analysisCondition.deletePath.toString(), relativizePath.getParent().toString());
        if (!Files.exists(evacuationDisPath, LinkOption.NOFOLLOW_LINKS)) {
            Files.createDirectories(evacuationDisPath, new FileAttribute[0]);
        }
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            String baseName = BcFileUtil.getBaseName(path.getFileName().toString());
            if (i > 0) {
                baseName = String.valueOf(baseName) + "(" + i + ")";
            }
            String extention = BcFileUtil.getExtention(path.getFileName().toString());
            String newFileName = BcFileUtil.createFileName(baseName, extention);
            Path evacuationFilePath = Paths.get(evacuationDisPath.toString(), newFileName);
            if (!Files.exists(evacuationFilePath, LinkOption.NOFOLLOW_LINKS)) {
                Files.move(path, evacuationFilePath, new CopyOption[0]);
                break;
            }
            ++i;
        }
    }
}

