/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.server;

import java.sql.ResultSet;
import java.sql.SQLException;
import jp.co.extreme.base.core.BcNumberUtil;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.sql.SqlResultSet;
import jp.co.extreme.sql.context.SqlContext;
import jp.co.extreme.task.TskAbstractCallable;

public abstract class XsysResultSetIterationTask
extends TskAbstractCallable<BcResult> {
    protected SqlResultSet rs;
    protected SqlContext sqlContext;

    public void setResultSet(SqlResultSet rs) throws SQLException {
        this.rs = rs;
        this.sqlContext = rs.getStatement().getSqlContext();
    }

    @Override
    public BcResult taskProcess() throws Exception {
        this.started();
        BcResult result = new BcResult();
        int rowNumber = 0;
        try {
            while (this.rs.next()) {
                if (++rowNumber % 1000 == 0) {
                    this.getLogger().info("Row Number=" + BcNumberUtil.toString(rowNumber));
                }
                this.selected(this.rs, rowNumber);
            }
        }
        finally {
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (Exception ex) {
                    this.getLogger().error(ex);
                }
            }
        }
        this.getLogger().info("rowCount=" + rowNumber);
        this.finised(rowNumber);
        return result;
    }

    protected void started() throws Exception {
    }

    protected void selected(ResultSet rs, int rowNumber) throws Exception {
    }

    protected void finised(int rowNumber) throws Exception {
    }
}

