/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.MouseEvent;
import jp.co.extreme.base.mmd.MmdModel;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.tree.FxTreeCell;
import jp.co.extreme.fx.tree.FxTreeFolder;
import jp.co.extreme.fx.tree.FxTreeItem;
import jp.co.extreme.fx.util.FxImageHelper;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.module.xdts.common.EtcSqlConditionUtil;
import jp.co.extreme.module.xdts.common.XdtsConstants;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.common.XdtsWords;
import jp.co.extreme.module.xdts.fx.XdtsPersistence;
import jp.co.extreme.module.xdts.fx.XdtsProfileTreeItemHelper;
import jp.co.extreme.module.xdts.fx.XdtsTransferPane;
import jp.co.extreme.module.xdts.model.XdtsCustomSql;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.model.XdtsUserSetting;
import jp.co.extreme.module.xdts.model.v001.XdtsExtractionCondition;
import jp.co.extreme.module.xdts.stub.XdtsExtractionConditionStub;
import jp.co.extreme.module.xdts.stub.XdtsSchemaStub;
import jp.co.extreme.module.xdts.swg.XdtsDataViewPanel_Auto;
import jp.co.extreme.module.xdts.swg.XdtsDataViewPanel_Sql;
import jp.co.extreme.sql.SqlWords;
import jp.co.extreme.sql.model.SqlSelectQuery;

class XdtsViewTreeItemHelper
extends XdtsProfileTreeItemHelper {
    List<XdtsSchemaObject> schemaObjectList;
    ContextMenu contextMenu1;
    ContextMenu contextMenu2;
    MenuItem deleteMenuItem;
    MenuItem refreshMenuItem;
    MenuItem dataViewConditionMenuItem;
    MenuItem dataViewSqlMenuItem;

    XdtsViewTreeItemHelper() {
    }

    @Override
    public FxTreeItem creaeSubTreeItem() throws Exception {
        FxTreeItem treeItem = this.creaeTreeItem();
        treeItem.setValue(new FxTreeFolder(SqlWords.getInstance().view));
        treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
        return treeItem;
    }

    @Override
    public String getItemText(FxTreeItem treeItem) throws Exception {
        String str = null;
        if (XdtsSchemaObject.class.isInstance(treeItem.getValue())) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            str = XdtsUtil.apendLogicalName(this.wordManager, schemaObject.name1);
        } else {
            str = super.getItemText(treeItem);
        }
        return str;
    }

    @Override
    public void refresh() throws Exception {
        super.refresh();
        this.initTree();
    }

    protected void initTree() throws Exception {
        List<String> viewNameList = XdtsSchemaStub.getInstance().getViewNameList(this.profile.getDataId());
        List<XdtsSchemaObject> schemaObjectList = XdtsUtil.toSchemaObjectList(viewNameList, XdtsConstants.SchemaObjectType.view, true);
        this.setSchemaObjectList(schemaObjectList);
    }

    protected void setSchemaObjectList(List<XdtsSchemaObject> schemaObjectList) throws Exception {
        this.schemaObjectList = schemaObjectList;
        this.getSubTreeItem().getChildren().clear();
        ArrayList<FxTreeItem> treeItemList = new ArrayList<FxTreeItem>();
        int i = 0;
        while (i < schemaObjectList.size()) {
            XdtsSchemaObject schemaObject = schemaObjectList.get(i);
            FxTreeItem treeItem = this.creaeTreeItem();
            treeItem.setValue(schemaObject);
            treeItem.setGraphic((Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
            treeItemList.add(treeItem);
            ++i;
        }
        this.getSubTreeItem().getChildren().addAll(treeItemList);
        String str = String.format(String.valueOf(SqlWords.getInstance().view) + "(%d)", treeItemList.size());
        this.getSubTreeItem().setValue(new FxTreeFolder(str));
    }

    @Override
    public void treeItemClicked(MouseEvent ev, FxTreeItem treeItem, FxTreeCell treeCell, boolean doubleClicked) throws Exception {
        super.treeItemClicked(ev, treeItem, treeCell, doubleClicked);
        if (treeItem.getParent() == this.getSubTreeItem() && doubleClicked) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            this.profileTreeView.parentPane.profilePane.addTable(schemaObject.name1, -1);
        }
    }

    @Override
    public void setContextMenu(FxTreeItem treeItem, FxTreeCell treeCell, EventHandler contextMeneEventHandler) throws Exception {
        if (this.contextMenu1 == null) {
            this.contextMenu1 = new ContextMenu();
            this.contextMenu2 = new ContextMenu();
            this.deleteMenuItem = new MenuItem(String.valueOf(BcWords.getInstance().delete) + "(" + SqlWords.getInstance().sql_DROP_VIEW + ")", (Node)FxImageHelper.createImageView_icon("cancel_64x64.png"));
            this.deleteMenuItem.setOnAction(contextMeneEventHandler);
            this.refreshMenuItem = new MenuItem(BcWords.getInstance().refresh, (Node)FxImageHelper.createImageView_icon("refresh_64x64.png"));
            this.refreshMenuItem.setOnAction(contextMeneEventHandler);
            this.dataViewConditionMenuItem = new MenuItem(XdtsWords.getInstance().dataView_Condition, (Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
            this.dataViewConditionMenuItem.setOnAction(contextMeneEventHandler);
            this.dataViewSqlMenuItem = new MenuItem(XdtsWords.getInstance().dataView_Sql, (Node)FxImageHelper.createImageView_icon("table_view_64x64.png"));
            this.dataViewSqlMenuItem.setOnAction(contextMeneEventHandler);
        }
        this.deleteMenuItem.setUserData((Object)treeCell);
        this.refreshMenuItem.setUserData((Object)treeCell);
        this.dataViewConditionMenuItem.setUserData((Object)treeCell);
        this.dataViewSqlMenuItem.setUserData((Object)treeCell);
        if (treeItem == this.getSubTreeItem()) {
            this.contextMenu1.getItems().clear();
            this.contextMenu1.getItems().add((Object)this.deleteMenuItem);
            this.contextMenu1.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu1.getItems().add((Object)this.refreshMenuItem);
            treeCell.setContextMenu(this.contextMenu1);
        } else {
            this.contextMenu2.getItems().clear();
            this.contextMenu2.getItems().add((Object)this.dataViewConditionMenuItem);
            this.contextMenu2.getItems().add((Object)this.dataViewSqlMenuItem);
            this.contextMenu2.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu2.getItems().add((Object)this.deleteMenuItem);
            this.contextMenu2.getItems().add((Object)new SeparatorMenuItem());
            this.contextMenu2.getItems().add((Object)this.refreshMenuItem);
            treeCell.setContextMenu(this.contextMenu2);
        }
    }

    @Override
    public void contextMenuHandle(Event ev, FxTreeItem treeItem) throws Exception {
        if (ev.getSource() == this.deleteMenuItem) {
            List<XdtsSchemaObject> selectedSchemaObjectList = this.getSelectedSchemaObjectList(treeItem);
            XdtsTransferPane transferPane = new XdtsTransferPane();
            if (ev.getSource() == this.deleteMenuItem) {
                transferPane.setProfile(this.profile, XdtsTransferPane.Mode.dropView);
            }
            transferPane.schemaObjectSelectionPane.setSchemaObjectList(selectedSchemaObjectList);
            transferPane.setOnAction(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                }
            });
            transferPane.show(this.getTreeView().getScene().getWindow());
        } else if (ev.getSource() == this.refreshMenuItem) {
            this.refresh();
        } else if (ev.getSource() == this.dataViewConditionMenuItem) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            BcResult result = XdtsExtractionConditionStub.getInstance().createExtractionConditionByTable(this.profile.getDataId(), schemaObject.name1);
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(result.getErrorList());
                FxOptionPane.showMessageDialog((Node)this.getTreeView(), (Object)msg, BcWords.getInstance().error, 0);
                return;
            }
            XdtsExtractionCondition extractionCondition = (XdtsExtractionCondition)result.getUserObject();
            String fileName2 = XdtsPersistence.createFileName(this.profile.getDataId(), XdtsConstants.Category.dev, schemaObject.name1, XdtsConstants.FileType.user);
            XdtsUserSetting userSetting = (XdtsUserSetting)XdtsPersistence.readObject(fileName2);
            if (userSetting == null) {
                userSetting = new XdtsUserSetting();
            }
            XdtsDataViewPanel_Auto dataViewPanel = new XdtsDataViewPanel_Auto();
            dataViewPanel.setProfile(this.profile);
            dataViewPanel.setData(extractionCondition, userSetting, true);
            dataViewPanel.setTitle(String.valueOf(this.profile.name) + " : " + schemaObject.name1);
            dataViewPanel.init();
            dataViewPanel.showAsFrame();
        } else if (ev.getSource() == this.dataViewSqlMenuItem) {
            XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItem.getValue();
            MmdModel mmdModel = XdtsSchemaStub.getInstance().getModelMetaData(this.profile.getDataId(), schemaObject.name1);
            SqlSelectQuery selectQuery = EtcSqlConditionUtil.createSelectQuery(this.sqlContext, mmdModel);
            XdtsUtil.setOption(selectQuery);
            XdtsCustomSql customSql = new XdtsCustomSql();
            customSql.sql = this.sqlContext.buildSelectQuery(selectQuery).toString();
            customSql.name = String.valueOf(this.profile.name) + " : " + schemaObject.name1;
            XdtsDataViewPanel_Sql dataViewPanel = new XdtsDataViewPanel_Sql();
            dataViewPanel.setProfile(this.profile);
            dataViewPanel.setCustomSql(customSql);
            dataViewPanel.init();
            dataViewPanel.showAsFrame();
        }
    }

    public List<XdtsSchemaObject> getSelectedSchemaObjectList(FxTreeItem treeItem) throws Exception {
        List<XdtsSchemaObject> selectedSchemaObject = null;
        if (treeItem == this.getSubTreeItem()) {
            selectedSchemaObject = this.schemaObjectList;
        } else {
            selectedSchemaObject = new ArrayList<XdtsSchemaObject>();
            ObservableList treeItemList = this.getTreeView().getSelectionModel().getSelectedItems();
            int i = 0;
            while (i < treeItemList.size()) {
                FxTreeItem treeItemWk = (FxTreeItem)((Object)treeItemList.get(i));
                if (treeItemWk.getParent() == this.getSubTreeItem()) {
                    XdtsSchemaObject schemaObject = (XdtsSchemaObject)treeItemWk.getValue();
                    selectedSchemaObject.add(schemaObject);
                }
                ++i;
            }
        }
        return selectedSchemaObject;
    }
}

