/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcInputValidator;
import jp.co.extreme.base.util.BcMessageCreator;
import jp.co.extreme.base.util.BcResult;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.extension.FxxProgressIndicationPane;
import jp.co.extreme.fx.extension.FxxRadioButtonPane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxOptionPane;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.impt.common.ImptImportUtil;
import jp.co.extreme.module.xdts.common.XdtsImportAnalysis;
import jp.co.extreme.module.xdts.fx.XdtsDataImportWizard;
import jp.co.extreme.poi.PoiWorkbookUtil;
import jp.co.extreme.scf4.fx.XdtsWizardPane;
import org.apache.poi.ss.usermodel.Workbook;

class XdtsImportPanel1
extends XdtsWizardPane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField filePathField = new FxTextField();
    FxButton fileChooseButton;
    FileChooser fileChooser;
    XdtsDataImportWizard wizard;

    public XdtsImportPanel1(XdtsDataImportWizard wizard) throws Exception {
        this.fileChooseButton = new FxButton(BcWords.getInstance().browse);
        this.fileChooser = new FileChooser();
        this.wizard = wizard;
    }

    @Override
    public void initComponent() throws Exception {
        super.initComponent();
        this.centerPane.removeAll();
        this.mainDecoratePane.setCenter((Node)this.centerPane);
        String description = "<html><font size=\"2\">\u53d6\u308a\u8fbc\u307f\u5bfe\u8c61\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002<br>\u300c\u6b21\u3078\u300d\u30dc\u30bf\u30f3\u3092\u62bc\u4e0b\u306b\u3088\u308a\u5206\u6790\u3092\u884c\u3044\u307e\u3059\u3002</font></html>";
        this.mainDecoratePane.setDescription(description);
        this.filePathField.setPrefColumnCount(110);
        this.fileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().file), new Node[]{this.filePathField, this.fileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        this.nextButton.setVisible(true);
        this.cancelButton.setVisible(true);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileChooseButton) {
            FxUtil.initFileChooser(this.fileChooser, this.filePathField.getText());
            File file = this.fileChooser.showOpenDialog((Window)this.wizard.stage);
            if (file != null) {
                this.filePathField.setText(file.getPath());
            }
        }
    }

    protected BcResult validateInputValue() throws Exception {
        BcResult result = new BcResult();
        BcInputValidator inputValidator = BcInputValidator.getInstance();
        this.wizard.importContext.file = new File(this.filePathField.getText());
        inputValidator.isFileExists(this.wizard.importContext.file.getPath(), BcWords.getInstance().file, result.getErrorList());
        return result;
    }

    @Override
    protected void nextButtonAction() throws Exception {
        BcResult result = this.validateInputValue();
        if (result.hasError()) {
            String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
            FxOptionPane.showMessageDialog((Window)this.wizard.stage, (Object)message, BcWords.getInstance().warning, 2);
            return;
        }
        this.wizard.importContext.importDefine.datasourceType = ImptImportUtil.getInstance().toDatasourceTypeByFileName(this.filePathField.getText());
        if (this.wizard.importContext.importDefine.datasourceType == 31) {
            FileInputStream fileInputStream = new FileInputStream(this.filePathField.getText());
            Workbook ssWorkbook = PoiWorkbookUtil.createWorkbook(fileInputStream);
            List<String> sheetNameList = PoiWorkbookUtil.createSheetNameList(ssWorkbook);
            if (sheetNameList.size() == 1) {
                this.wizard.importContext.sheetName = sheetNameList.get(0);
            } else {
                FxxRadioButtonPane radioButtonPane = new FxxRadioButtonPane();
                radioButtonPane.setData(sheetNameList);
                radioButtonPane.setSelectedValue(sheetNameList.get(0));
                boolean isSelected = radioButtonPane.show((Window)this.wizard.stage, 440.0, 200.0, "\u30b7\u30fc\u30c8\u9078\u629e");
                BcLogUtil.debug("isSelected=" + isSelected + " radioButtonPane.getSelectedValue()=" + radioButtonPane.getSelectedValue());
                if (isSelected) {
                    this.wizard.importContext.sheetName = radioButtonPane.getSelectedValue();
                } else {
                    return;
                }
            }
        }
        FxxProgressIndicationPane progressIndicationPane = this.crateProgressIndicationPane();
        progressIndicationPane.msgLabel.setText(String.valueOf(BcWords.getInstance().underAnalysis) + "...");
        InnerTask task = new InnerTask();
        new Thread((Runnable)((Object)task)).start();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.wizard.closeConfirm();
    }

    @Override
    protected void handleException(final Throwable throwable) {
        BcLogUtil.error(throwable);
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                String msg = throwable.getMessage();
                FxOptionPane.showMessageDialog((Window)XdtsImportPanel1.this.wizard.stage, (Object)msg, BcWords.getInstance().error, 0);
                try {
                    XdtsImportPanel1.this.setMianContent();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    class InnerTask
    extends Task {
        public Void call() {
            try {
                XdtsImportAnalysis importAnalysis = new XdtsImportAnalysis();
                XdtsImportPanel1.this.wizard.tableModel = importAnalysis.doParse1(XdtsImportPanel1.this.wizard.importContext);
                FxPlatform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ((InnerTask)InnerTask.this).XdtsImportPanel1.this.wizard.phase2();
                        }
                        catch (Exception ex) {
                            BcLogUtil.error(ex);
                        }
                    }
                });
            }
            catch (Exception ex) {
                XdtsImportPanel1.this.handleException(ex);
            }
            return null;
        }
    }
}

