/*
 * Decompiled with CFR 0.152.
 */
package jp.co.extreme.module.xdts.fx;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import jp.co.extreme.app.common.AfbApplication;
import jp.co.extreme.awt.AwtUtil;
import jp.co.extreme.base.io.BcFileUtil;
import jp.co.extreme.base.log.BcLogUtil;
import jp.co.extreme.base.util.BcWords;
import jp.co.extreme.datasource.util.DtsWordManagerImpl;
import jp.co.extreme.etc.model.EtcWord;
import jp.co.extreme.etc.util.EtcWordUtil;
import jp.co.extreme.fx.FxPlatform;
import jp.co.extreme.fx.control.FxButton;
import jp.co.extreme.fx.control.FxCheckBox;
import jp.co.extreme.fx.control.FxLabel;
import jp.co.extreme.fx.control.FxTextField;
import jp.co.extreme.fx.layout.FxDecoratePane;
import jp.co.extreme.fx.layout.FxFlowPane;
import jp.co.extreme.fx.layout.FxNodeUnit;
import jp.co.extreme.fx.util.FxUtil;
import jp.co.extreme.module.mmdx.model.MmdxModel;
import jp.co.extreme.module.xdts.common.XdtsDefinitionCreator;
import jp.co.extreme.module.xdts.common.XdtsUtil;
import jp.co.extreme.module.xdts.fx.XdtsDefinitionCreatePane;
import jp.co.extreme.module.xdts.model.XdtsSchemaObject;
import jp.co.extreme.module.xdts.stub.XdtsSchemaStub;
import jp.co.extreme.module.xdts.stub.XdtsWordStub;
import jp.co.extreme.poi.PoiWorkbookUtil;
import jp.co.extreme.scf4.fx.HfxProcessingPane;
import jp.co.extreme.sql.context.SqlTableMetadata;
import org.apache.poi.ss.usermodel.Workbook;

class XdtsDefinitionIndicationPane2
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField templeteFilePathField = new FxTextField();
    FxButton templeteFileChooseButton = FxUtil.createBrowsButton(null);
    FxTextField destFilePathField = new FxTextField();
    FxButton destFileChooseButton = FxUtil.createBrowsButton(null);
    FileChooser fileChooser = new FileChooser();
    FxCheckBox fileOpenCheckBox = new FxCheckBox();
    Button executeButton;
    Button closeButton;
    XdtsDefinitionCreatePane parentPane;
    InnerProcessingPane processingPane;

    public XdtsDefinitionIndicationPane2(XdtsDefinitionCreatePane parentPane) throws Exception {
        this.parentPane = parentPane;
        this.initComponent();
    }

    protected void initComponent() throws Exception {
        this.executeButton = FxUtil.createExecuteButton();
        this.executeButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.executeButton);
        this.closeButton = FxUtil.createCloseButton();
        this.closeButton.setOnAction(this.actionEventHandler);
        this.addControlNode((Node)this.closeButton);
        this.templeteFilePathField.setPrefColumnCount(100);
        this.templeteFileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8"), new Node[]{this.templeteFilePathField, this.templeteFileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        this.destFilePathField.setPrefColumnCount(100);
        this.destFileChooseButton.setOnAction(this.actionEventHandler);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().destination), new Node[]{this.destFilePathField, this.destFileChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().openFile), new Node[]{this.fileOpenCheckBox});
        this.centerPane.addNodeUnit(nodeUnit);
        this.fileOpenCheckBox.setSelected(true);
        this.setCenter((Node)this.centerPane);
        File tempateDir = new File(AfbApplication.getInstance().toReal("${APP}resource/template/"));
        File templeteFile = new File(tempateDir, "table_definition.xlsx");
        this.templeteFilePathField.setText(templeteFile.getPath());
        File destDir = new File(AfbApplication.getInstance().toReal("${APP}export/"));
        String destFileName = "table_definition_" + BcFileUtil.create_yyyyMMdd_HHmmssSSS() + ".xlsx";
        File destFile = new File(destDir, destFileName);
        this.destFilePathField.setText(destFile.getPath());
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.templeteFileChooseButton) {
            FxUtil.initFileChooser(this.fileChooser, this.templeteFilePathField.getText());
            File file = this.fileChooser.showOpenDialog((Window)this.parentPane.getStage());
            if (file != null) {
                this.templeteFilePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.destFileChooseButton) {
            FxUtil.initFileChooser(this.fileChooser, this.destFilePathField.getText());
            File file = this.fileChooser.showSaveDialog((Window)this.parentPane.getStage());
            if (file != null) {
                this.destFilePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.executeButton) {
            this.processingPane = new InnerProcessingPane();
            this.processingPane.show(this.parentPane.title, (Window)this.parentPane.getStage());
        } else if (ev.getSource() == this.closeButton) {
            this.parentPane.close();
        }
    }

    protected void creatDefinitione() throws Exception {
        this.processingPane.consolePane.addLine("\u30b9\u30ad\u30fc\u30de\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u3092\u53d6\u5f97\u4e2d...");
        List<EtcWord> wordList = XdtsWordStub.getInstance().getWordList(this.parentPane.profile.getDataId());
        DtsWordManagerImpl wordManager = new DtsWordManagerImpl();
        EtcWordUtil.setWordCollection(wordManager, wordList);
        List<XdtsSchemaObject> schemaObjectList = this.parentPane.schemaObjectSelectionPane.getSelecteSchemaObjectList();
        List<String> objectNameList = XdtsUtil.toNameList(schemaObjectList);
        Map<String, MmdxModel> mdxMap = XdtsSchemaStub.getInstance().getXmmdModelMap(this.parentPane.profile.getDataId(), objectNameList);
        this.processingPane.consolePane.addLine("mdxMap.size()=" + mdxMap.size());
        Map<String, SqlTableMetadata> tableMetadataMap = XdtsSchemaStub.getInstance().getTableMetadataMap(this.parentPane.profile.getDataId(), objectNameList);
        ArrayList<MmdxModel> mdxList = new ArrayList<MmdxModel>();
        for (Map.Entry<String, MmdxModel> mapEntry : mdxMap.entrySet()) {
            mdxList.add(mapEntry.getValue());
        }
        this.processingPane.consolePane.addLine("\u30c6\u30f3\u30d7\u30ec\u30fc\u30c8\u3092\u8aad\u307f\u8fbc\u307f\u4e2d...");
        this.processingPane.consolePane.addLine("\u30d5\u30a1\u30a4\u30eb=" + this.templeteFilePathField.getText());
        File templateFile = new File(this.templeteFilePathField.getText());
        BcFileUtil.notEexistsException(templateFile);
        Workbook workbook = PoiWorkbookUtil.createWorkbook(new FileInputStream(templateFile));
        InnerDefinitionCreator definitionCreator = new InnerDefinitionCreator();
        definitionCreator.create(mdxList, wordManager, tableMetadataMap, workbook);
        File destFile = new File(this.destFilePathField.getText());
        PoiWorkbookUtil.writeWorkbook(workbook, destFile);
        if (this.fileOpenCheckBox.isSelected()) {
            AwtUtil.openFile(destFile);
        }
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XdtsDefinitionIndicationPane2.this.processingPane.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    class InnerDefinitionCreator
    extends XdtsDefinitionCreator {
        @Override
        protected void msg(String msg) throws Exception {
            super.msg(msg);
            XdtsDefinitionIndicationPane2.this.processingPane.consolePane.addLine(msg);
        }
    }

    class InnerProcessingPane
    extends HfxProcessingPane {
        @Override
        protected void doConnect() {
            try {
                XdtsDefinitionIndicationPane2.this.creatDefinitione();
            }
            catch (Exception ex) {
                this.exceptionOccurred(ex);
            }
        }

        @Override
        protected void loopL1() {
        }
    }
}

